/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cordovasim.eclipse.servlet.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.jboss.tools.cordovasim.eclipse.Activator;
import org.jboss.tools.cordovasim.eclipse.launch.CordovaSimLaunchParametersUtil;

public class ConfigXMLServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private IProject project;

    public ConfigXMLServlet(IProject project) {
        this.project = project;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        IFile configXml = CordovaSimLaunchParametersUtil.getConfigXml(this.project);
        if (configXml == null || !configXml.exists()) {
            response.sendError(404);
            return;
        }
        response.setContentType("text/xml");
        try {
            InputStream contents = configXml.getContents();
            if (contents != null) {
                InputStreamReader isr = new InputStreamReader(contents);
                BufferedReader reader = new BufferedReader(isr);
                PrintWriter writer = response.getWriter();
                String text = "";
                while ((text = reader.readLine()) != null) {
                    writer.println(text);
                }
            }
        }
        catch (CoreException e) {
            Activator.logError(e.getMessage(), e);
            response.sendError(500);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }
}

