/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.angularjs.internal;

import java.io.IOException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jst.web.kb.WebKbPlugin;
import org.jboss.tools.jst.web.kb.internal.HTMLRecognizer;
import org.jboss.tools.jst.web.kb.internal.JSRecognizer;
import org.jboss.tools.jst.web.kb.taglib.ITagLibrary;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AngularJSRecognizer
extends HTMLRecognizer {
    private static final String ANGULAR_JS_LIB_NAME = "angular";
    private static final String ANGULAR_JS_PATTERN = ".*(angular).*(.js).*";
    private static final String ANGULAR_NG_ATTRIBUTE_PATTERN = "//*/@*[starts-with(name(), 'ng-')]|//*/@*[starts-with(name(), 'data-ng-')]";

    protected boolean recalculateResult(ITagLibrary lib, ELContext context, IFile file) {
        if (super.recalculateResult(lib, context, file)) {
            final Boolean[] result = new Boolean[]{JSRecognizer.getJSReferenceVersion((IFile)context.getResource(), (String)ANGULAR_JS_LIB_NAME) != null};
            if (!result[0].booleanValue()) {
                StructuredModelWrapper.execute((IFile)context.getResource(), (StructuredModelWrapper.ICommand)new StructuredModelWrapper.ICommand(){

                    public void execute(IDOMDocument xmlDocument) {
                        try {
                            NodeList list = (NodeList)XPathFactory.newInstance().newXPath().compile(AngularJSRecognizer.ANGULAR_NG_ATTRIBUTE_PATTERN).evaluate(xmlDocument, XPathConstants.NODESET);
                            int i = 0;
                            while (i < list.getLength()) {
                                IDOMAttr cfr_ignored_0 = (IDOMAttr)list.item(i);
                                ++i;
                            }
                            result[0] = list.getLength() > 0;
                        }
                        catch (XPathExpressionException e) {
                            WebKbPlugin.getDefault().logError((Throwable)e);
                        }
                    }
                });
            }
            return result[0];
        }
        return false;
    }

    public static boolean isAngularTemplate(IFile file) {
        String ext = file.getFileExtension();
        if (ext == null || !ext.toLowerCase().startsWith("htm")) {
            return false;
        }
        String doctype = FileUtil.getDoctype((String)FileUtil.getContentFromEditorOrFile((IFile)file));
        if (doctype != null) {
            return false;
        }
        IStructuredModel model = null;
        try {
            IDOMDocument xmlDocument;
            model = StructuredModelManager.getModelManager().getModelForRead(file);
            IDOMDocument iDOMDocument = xmlDocument = model instanceof IDOMModel ? ((IDOMModel)model).getDocument() : null;
            if (xmlDocument == null) {
                return false;
            }
            NodeList list = xmlDocument.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node n = list.item(i);
                if (n instanceof Element) {
                    String name = ((Element)n).getNodeName().toLowerCase();
                    return !name.equals("html") && !name.equals("body") && !name.equals("head");
                    {
                    }
                }
                try {
                    ++i;
                    continue;
                }
                catch (IOException e) {
                    WebKbPlugin.getDefault().logError((Throwable)e);
                }
                catch (CoreException e) {
                    WebKbPlugin.getDefault().logError((Throwable)e);
                }
                break;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return false;
    }
}

