/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.dashboard.internal.ui.editors;

import com.sun.syndication.feed.synd.SyndCategory;
import com.sun.syndication.feed.synd.SyndEntry;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public class UpdateNotification {
    private final Set<Artifact> conflictingBundles = new HashSet<Artifact>();
    private final SyndEntry entry;
    private String platformFilter;
    private final Set<Artifact> requiredBundles = new HashSet<Artifact>();
    private String severity;
    private String versionRange;

    public UpdateNotification(List<String> properties) {
        this.entry = null;
        for (String property : properties) {
            this.parseProperty(property);
        }
    }

    public UpdateNotification(SyndEntry entry) {
        this.entry = entry;
        List categories = entry.getCategories();
        int i = 0;
        while (i < categories.size()) {
            Object obj = categories.get(i);
            if (obj instanceof SyndCategory) {
                SyndCategory category = (SyndCategory)obj;
                String text = category.getName();
                this.parseProperty(text);
            }
            ++i;
        }
    }

    public Set<Artifact> getConflictingBundles() {
        return Collections.unmodifiableSet(this.conflictingBundles);
    }

    public SyndEntry getEntry() {
        return this.entry;
    }

    public String getPlatformFilter() {
        return this.platformFilter;
    }

    public Set<Artifact> getRequiredBundles() {
        return Collections.unmodifiableSet(this.requiredBundles);
    }

    public String getSeverity() {
        return this.severity;
    }

    public String getVersionRange() {
        return this.versionRange;
    }

    public boolean matches(Version ideVersion, Set<String> installedFeatureIds, Dictionary<?, ?> environment) {
        VersionRange range;
        if (this.versionRange != null && !(range = new VersionRange(this.versionRange)).isIncluded(ideVersion)) {
            return false;
        }
        if (installedFeatureIds != null && !this.requiredBundles.isEmpty()) {
            for (Artifact artifact : this.requiredBundles) {
                if (installedFeatureIds.contains(artifact.bundleId)) continue;
                return false;
            }
        }
        if (installedFeatureIds != null && !this.conflictingBundles.isEmpty()) {
            for (Artifact artifact : this.conflictingBundles) {
                if (!installedFeatureIds.contains(artifact.bundleId)) continue;
                return false;
            }
        }
        if (this.platformFilter != null) {
            try {
                Filter filter = FrameworkUtil.createFilter((String)this.platformFilter);
                if (!filter.match(environment)) {
                    return false;
                }
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
        }
        return true;
    }

    private Artifact parseArtifact(String substring) {
        String[] tokens;
        String bundleId = null;
        VersionRange bundleVersion = null;
        String[] stringArray = tokens = substring.split(";");
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (token.contains("=")) {
                if (token.startsWith("version=")) {
                    try {
                        bundleVersion = new VersionRange(token.replaceFirst("version=", ""));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return null;
                    }
                }
            } else {
                bundleId = token;
            }
            ++n2;
        }
        if (bundleId == null) {
            return null;
        }
        return new Artifact(bundleId, bundleVersion);
    }

    private void parseProperty(String text) {
        if (text.startsWith("severity=")) {
            this.severity = text.replaceFirst("severity=", "");
        } else if (text.startsWith("version=")) {
            this.versionRange = text.replaceFirst("version=", "");
        } else if (text.startsWith("platform.filter=")) {
            this.platformFilter = text.replaceFirst("platform.filter=", "");
        } else if (text.startsWith("bundle=")) {
            String bundle = text.replaceFirst("bundle=", "");
            if (bundle.startsWith("!")) {
                Artifact artifact = this.parseArtifact(bundle.substring(1));
                if (artifact != null) {
                    this.conflictingBundles.add(artifact);
                }
            } else {
                Artifact artifact = this.parseArtifact(bundle);
                if (artifact != null) {
                    this.requiredBundles.add(artifact);
                }
            }
        }
    }

    public int hashCode() {
        if (this.entry.getTitle() != null) {
            return this.entry.getTitle().hashCode();
        }
        return -1;
    }

    public boolean equals(Object other) {
        return other instanceof UpdateNotification && ((UpdateNotification)other).getEntry() != null && ((UpdateNotification)other).getEntry().getTitle().equals(this.entry.getTitle());
    }

    public static class Artifact {
        final String bundleId;
        final VersionRange versionRange;

        public Artifact(String bundleId, VersionRange bundleVersion) {
            Assert.isNotNull((Object)bundleId);
            this.bundleId = bundleId;
            this.versionRange = bundleVersion;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Artifact other = (Artifact)obj;
            if (this.bundleId == null ? other.bundleId != null : !this.bundleId.equals(other.bundleId)) {
                return false;
            }
            return !(this.versionRange == null ? other.versionRange != null : !this.versionRange.equals((Object)other.versionRange));
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.bundleId == null ? 0 : this.bundleId.hashCode());
            result = 31 * result + (this.versionRange == null ? 0 : this.versionRange.hashCode());
            return result;
        }

        public String toString() {
            return "Artifact [bundleId=" + this.bundleId + ", versionRange=" + this.versionRange + "]";
        }
    }
}

