/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.dataflow;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.views.dataflow.DataflowGraph;
import net.sourceforge.pmd.eclipse.ui.views.dataflow.DataflowGraphTable;
import net.sourceforge.pmd.eclipse.ui.views.dataflow.DataflowGraphTableData;
import net.sourceforge.pmd.eclipse.util.IOUtil;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.dfa.DataFlowNode;
import net.sourceforge.pmd.lang.dfa.VariableAccess;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class DataflowGraphViewer
extends Composite {
    private Node method;
    private String resourceString;
    private DataflowGraphTable table;
    private DataflowGraph graph;
    protected static final int NODE_RADIUS = 12;
    protected static final int LINE_LENGTH = 25;
    protected static final int ROW_HEIGHT = 49;
    protected int[] colWidths;
    protected Color bgColor;
    protected Color lineColor;
    protected Color textColor;

    public DataflowGraphViewer(Composite parent, int style) {
        super(parent, style);
        this.setLayoutData(new GridData(1808));
        this.table = this.initTable(this, style);
        GridLayout mainLayout = new GridLayout(1, false);
        mainLayout.marginWidth = 0;
        mainLayout.marginHeight = 0;
        mainLayout.verticalSpacing = 0;
        mainLayout.horizontalSpacing = 0;
        this.setLayout((Layout)mainLayout);
    }

    public void addMouseListener(MouseListener mouseListener) {
        if (this.graph != null) {
            this.graph.addMouseListener(mouseListener);
        }
    }

    private DataflowGraphTable initTable(Composite parent, int style) {
        DataflowGraphTable dfaTable = new DataflowGraphTable(parent, style);
        this.colWidths = new int[]{50, 250, 70, 220, 300};
        String[] headerTitles = new String[]{this.getString("view.dataflow.graph.column_line"), this.getString("view.dataflow.graph.column_graph"), this.getString("view.dataflow.graph.column_nextnodes"), this.getString("view.dataflow.graph.column_values"), this.getString("view.dataflow.graph.column_code")};
        dfaTable.setColumns(this.colWidths, headerTitles, 1);
        Display display = parent.getDisplay();
        this.bgColor = display.getSystemColor(1);
        this.lineColor = new Color(null, 192, 192, 192);
        this.textColor = display.getSystemColor(2);
        dfaTable.setColors(this.textColor, this.bgColor, this.lineColor);
        return dfaTable;
    }

    public void setData(Node node, String resString) {
        if (this.method != null) {
            this.table.dispose();
            this.table = this.initTable(this, 0);
            this.layout();
        }
        this.method = node;
        this.resourceString = resString;
        this.table.setRows(node.getDataFlowNode().getFlow().size(), 49);
        this.table.setTableData(this.createDataFields(node));
        this.graph = new DataflowGraph(this.table.getGraphArea(), node, 12, 25, 49);
    }

    public DataflowGraph getGraph() {
        return this.graph;
    }

    private String nextNodeNumberStringFrom(DataFlowNode dfNode) {
        List dfNodes = dfNode.getChildren();
        if (dfNodes.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(Integer.toString(((DataFlowNode)dfNodes.get(0)).getIndex()));
        int j = 1;
        while (j < dfNodes.size()) {
            sb.append(", ").append(((DataFlowNode)dfNodes.get(j)).getIndex());
            ++j;
        }
        return sb.toString();
    }

    private String referenceStringFrom(DataFlowNode dfNode) {
        List access = dfNode.getVariableAccess();
        if (access == null) {
            return null;
        }
        StringBuilder exp = new StringBuilder();
        int k = 0;
        while (k < access.size()) {
            if (k > 0) {
                exp.append(", ");
            }
            VariableAccess va = (VariableAccess)access.get(k);
            switch (va.getAccessType()) {
                case 0: {
                    exp.append("d(");
                    break;
                }
                case 1: {
                    exp.append("r(");
                    break;
                }
                case 2: {
                    exp.append("u(");
                    break;
                }
                default: {
                    exp.append("?(");
                }
            }
            exp.append(va.getVariableName()).append(')');
            ++k;
        }
        return exp.toString();
    }

    protected List<List<DataflowGraphTableData>> createDataFields(Node node) {
        List flow = node.getDataFlowNode().getFlow();
        ArrayList<List<DataflowGraphTableData>> tableData = new ArrayList<List<DataflowGraphTableData>>();
        for (DataFlowNode inode : flow) {
            ArrayList<DataflowGraphTableData> rowData = new ArrayList<DataflowGraphTableData>();
            rowData.add(new DataflowGraphTableData(String.valueOf(inode.getLine()), 0x1000000));
            rowData.add(null);
            String cellContent = this.nextNodeNumberStringFrom(inode);
            rowData.add(new DataflowGraphTableData(cellContent, 16448));
            cellContent = this.referenceStringFrom(inode);
            if (cellContent != null) {
                rowData.add(new DataflowGraphTableData(cellContent, 16448));
            } else {
                rowData.add(null);
            }
            if (this.resourceString != null) {
                cellContent = this.getCodeLine(this.resourceString, inode.getLine()).trim();
                rowData.add(new DataflowGraphTableData(cellContent, 16448));
            } else {
                rowData.add(null);
            }
            tableData.add(rowData);
        }
        return tableData;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getCodeLine(String code, int line) {
        reader = null;
        try {
            reader = new LineNumberReader(new StringReader(code));
            ** GOTO lbl-1000
        }
        catch (IOException ioe) {
            PMDPlugin.getDefault().logError("message.error.io_exception" + this.toString(), ioe);
            IOUtil.closeQuietly(reader);
            return null;
        }
        catch (Throwable var5_7) {
            IOUtil.closeQuietly(reader);
            throw var5_7;
        }
lbl12:
        // 1 sources

        while (true) {
            IOUtil.closeQuietly(reader);
            return var6_6;
        }
lbl-1000:
        // 2 sources

        {
            ** while (reader.ready())
        }
lbl-1000:
        // 1 sources

        {
            retString = reader.readLine();
            if (reader.getLineNumber() != line) continue;
            var6_6 = retString;
            ** continue;
lbl20:
            // 1 sources

            ** GOTO lbl12
        }
lbl21:
        // 1 sources

        IOUtil.closeQuietly(reader);
        return null;
    }

    private String getString(String key) {
        return PMDPlugin.getDefault().getStringTable().getString(key);
    }
}

