/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.cpd;

import java.util.ArrayList;
import java.util.Iterator;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.views.cpd.CPDViewDoubleClickEventListener;
import net.sourceforge.pmd.eclipse.ui.views.cpd.CPDViewLabelProvider;
import net.sourceforge.pmd.eclipse.ui.views.cpd.CPDViewTooltipListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class CPDView
extends ViewPart
implements IPropertyListener {
    private TreeViewer treeViewer;
    private TreeNodeContentProvider contentProvider;
    private CPDViewLabelProvider labelProvider;
    private CPDViewDoubleClickEventListener doubleClickListener;
    private CPDViewTooltipListener tooltipListener;
    private static final int MAX_MATCHES = 100;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.contentProvider = new TreeNodeContentProvider();
        this.labelProvider = new CPDViewLabelProvider();
        this.doubleClickListener = new CPDViewDoubleClickEventListener(this);
        this.tooltipListener = new CPDViewTooltipListener(this);
    }

    public void createPartControl(Composite parent) {
        int treeStyle = 66306;
        this.treeViewer = new TreeViewer(parent, treeStyle);
        this.treeViewer.setUseHashlookup(true);
        Tree tree = this.treeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.addDoubleClickListener((IDoubleClickListener)this.doubleClickListener);
        this.tooltipListener.initialize();
        tree.addListener(12, (Listener)this.tooltipListener);
        tree.addListener(1, (Listener)this.tooltipListener);
        tree.addListener(5, (Listener)this.tooltipListener);
        tree.addListener(32, (Listener)this.tooltipListener);
        this.createColumns(tree);
    }

    private void createColumns(Tree tree) {
        TreeColumn plusColumn = new TreeColumn(tree, 131072);
        plusColumn.setWidth(20);
        TreeColumn imageColumn = new TreeColumn(tree, 0x1000000);
        imageColumn.setWidth(20);
        TreeColumn messageColumn = new TreeColumn(tree, 16384);
        messageColumn.setText(this.getString("view.column.message"));
        messageColumn.setWidth(300);
        TreeColumn classColumn = new TreeColumn(tree, 16384);
        classColumn.setText(this.getString("view.column.class"));
        classColumn.setWidth(300);
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    private String getString(String key) {
        return PMDPlugin.getDefault().getStringTable().getString(key);
    }

    public void setFocus() {
        this.treeViewer.getTree().setFocus();
    }

    public void setData(Iterator<Match> matches) {
        ArrayList<TreeNode> elements = new ArrayList<TreeNode>();
        if (matches != null) {
            int count = 0;
            while (matches.hasNext() && count < 100) {
                Match match = matches.next();
                TreeNode matchNode = new TreeNode((Object)match);
                elements.add(matchNode);
                TreeNode[] children = new TreeNode[match.getMarkCount()];
                Iterator entryIterator = match.getMarkSet().iterator();
                int j = 0;
                while (entryIterator.hasNext()) {
                    TokenEntry entry = (TokenEntry)entryIterator.next();
                    children[j] = new TreeNode((Object)entry);
                    children[j].setParent(matchNode);
                    ++j;
                }
                matchNode.setChildren(children);
                ++count;
            }
        }
        this.treeViewer.setInput((Object)elements.toArray(new TreeNode[elements.size()]));
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 1111 && source instanceof Iterator) {
            Iterator iter = (Iterator)source;
            boolean hasResults = iter.hasNext();
            this.setData(iter);
            if (!hasResults) {
                MessageBox box = new MessageBox(this.treeViewer.getControl().getShell());
                box.setText(this.getString("dialog.cpd.no_results.header"));
                box.setMessage(this.getString("dialog.cpd.no_results.body"));
                box.open();
            }
        }
    }
}

