/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.actions;

import java.lang.reflect.InvocationTargetException;
import net.sourceforge.pmd.eclipse.ui.model.AbstractPMDRecord;
import net.sourceforge.pmd.eclipse.ui.model.FileRecord;
import net.sourceforge.pmd.eclipse.ui.model.PackageRecord;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOverview;
import net.sourceforge.pmd.eclipse.ui.views.actions.AbstractPMDAction;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;

public class CalculateStatisticsAction
extends AbstractPMDAction {
    public final ViolationOverview violationView;

    public CalculateStatisticsAction(ViolationOverview view) {
        this.violationView = view;
    }

    @Override
    protected String imageId() {
        return "icons/btn_calculate.gif";
    }

    @Override
    protected String tooltipMsgId() {
        return "view.tooltip.calc_stats";
    }

    private TreeViewer getViewer() {
        return this.violationView.getViewer();
    }

    public void run() {
        try {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
            dialog.setCancelable(true);
            dialog.run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    TreeItem[] items = CalculateStatisticsAction.this.getViewer().getTree().getItems();
                    int unitCount = CalculateStatisticsAction.this.calculateWorkUnits(items);
                    monitor.beginTask(CalculateStatisticsAction.getString("monitor.calc_stats"), unitCount);
                    TreeItem[] treeItemArray = items;
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem item = treeItemArray[n2];
                        if (monitor.isCanceled()) break;
                        if (item.getData() instanceof PackageRecord) {
                            PackageRecord record = (PackageRecord)item.getData();
                            AbstractPMDRecord[] children = record.getChildren();
                            monitor.subTask(String.valueOf(CalculateStatisticsAction.getString("monitor.calc_stats.package")) + ": " + record.getName());
                            AbstractPMDRecord[] abstractPMDRecordArray = children;
                            int n3 = children.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                AbstractPMDRecord kid = abstractPMDRecordArray[n4];
                                if (kid instanceof FileRecord) {
                                    CalculateStatisticsAction.this.calculateFileRecord((FileRecord)kid);
                                    monitor.worked(1);
                                }
                                ++n4;
                            }
                        } else if (item.getData() instanceof FileRecord) {
                            CalculateStatisticsAction.this.calculateFileRecord((FileRecord)item.getData());
                            monitor.worked(1);
                        }
                        ++n2;
                    }
                    CalculateStatisticsAction.this.getViewer().refresh(true);
                }
            });
        }
        catch (InvocationTargetException e) {
            CalculateStatisticsAction.logErrorByKey("message.error.invocationtarget_exception", e);
        }
        catch (InterruptedException e) {
            CalculateStatisticsAction.logErrorByKey("message.error.interrupted_exception", e);
        }
    }

    private void calculateFileRecord(FileRecord fileRecord) {
        if (fileRecord.getLOC() == 0) {
            fileRecord.calculateLinesOfCode();
            fileRecord.calculateNumberOfMethods();
        }
    }

    private int calculateWorkUnits(TreeItem[] items) {
        int count = 0;
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            Object data = item.getData();
            if (data instanceof PackageRecord) {
                count += ((PackageRecord)data).getChildren().length;
            } else if (data instanceof FileRecord) {
                ++count;
            }
            ++n2;
        }
        return count;
    }
}

