/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.PMDRuntimeConstants;
import net.sourceforge.pmd.eclipse.ui.model.AbstractPMDRecord;
import net.sourceforge.pmd.eclipse.ui.model.FileRecord;
import net.sourceforge.pmd.eclipse.ui.model.FileToMarkerRecord;
import net.sourceforge.pmd.eclipse.ui.model.MarkerRecord;
import net.sourceforge.pmd.eclipse.ui.model.PackageRecord;
import net.sourceforge.pmd.eclipse.ui.views.AbstractViolationLabelProvider;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOverview;
import org.eclipse.swt.graphics.Image;

public class ViolationOverviewLabelProvider
extends AbstractViolationLabelProvider {
    private static final String KEY_IMAGE_PACKAGE = "package";
    private static final String KEY_IMAGE_JAVAFILE = "javafile";
    private final ViolationOverview violationView;

    public ViolationOverviewLabelProvider(ViolationOverview overview) {
        this.violationView = overview;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image image = null;
        if (columnIndex == 0) {
            if (element instanceof PackageRecord) {
                image = this.getImage(KEY_IMAGE_PACKAGE, "icons/obj_package.gif");
            } else if (element instanceof FileRecord || element instanceof FileToMarkerRecord) {
                image = this.getImage(KEY_IMAGE_JAVAFILE, "icons/obj_javacu.gif");
            } else if (element instanceof MarkerRecord) {
                MarkerRecord markerRecord = (MarkerRecord)element;
                int priority = markerRecord.getPriority();
                image = ViolationOverviewLabelProvider.getPriorityImage(priority);
            }
        }
        return image;
    }

    public String getColumnText(Object element, int columnIndex) {
        String result = "";
        if (element instanceof AbstractPMDRecord) {
            AbstractPMDRecord record = (AbstractPMDRecord)element;
            switch (columnIndex) {
                case 0: {
                    result = this.getElementName(element);
                    break;
                }
                case 1: {
                    result = this.getNumberOfViolations(record);
                    break;
                }
                case 2: {
                    result = this.getViolationsPerKLOC(record);
                    break;
                }
                case 3: {
                    result = this.getViolationsPerMethod(record);
                    break;
                }
                case 4: {
                    result = this.getProjectName(element);
                }
            }
        }
        return result;
    }

    private String getNumberOfViolations(AbstractPMDRecord element) {
        String ruleName;
        int maxViolations;
        int violations = this.violationView.getNumberOfFilteredViolations(element);
        String result = String.valueOf(violations);
        if (element instanceof MarkerRecord && this.violationView.getShowType() != 3) {
            String ruleName2 = ((MarkerRecord)element).getName();
            int maxViolations2 = this.getMaxViolations(ruleName2);
            if (violations == maxViolations2) {
                result = "(max) " + result;
            }
        } else if (element instanceof FileToMarkerRecord && violations == (maxViolations = this.getMaxViolations(ruleName = ((FileToMarkerRecord)element).getParent().getName()))) {
            result = "(max) " + result;
        }
        return result;
    }

    private int getMaxViolations(String ruleName) {
        int maxViolations = PMDPlugin.getDefault().loadPreferences().getMaxViolationsPerFilePerRule();
        Rule rule = PMDPlugin.getDefault().getPreferencesManager().getRuleSet().getRuleByName(ruleName);
        if (rule != null) {
            if (rule.hasDescriptor((PropertyDescriptor)PMDRuntimeConstants.MAX_VIOLATIONS_DESCRIPTOR)) {
                return (Integer)rule.getProperty((PropertyDescriptor)PMDRuntimeConstants.MAX_VIOLATIONS_DESCRIPTOR);
            }
            return (Integer)PMDRuntimeConstants.MAX_VIOLATIONS_DESCRIPTOR.defaultValue();
        }
        return maxViolations;
    }

    private String getElementName(Object element) {
        String name = "";
        if (element instanceof PackageRecord) {
            name = ((PackageRecord)element).getName();
        } else if (element instanceof FileRecord) {
            name = ((FileRecord)element).getName();
        } else if (element instanceof MarkerRecord) {
            name = ((MarkerRecord)element).getName();
        } else if (element instanceof FileToMarkerRecord) {
            name = ((FileToMarkerRecord)element).getParent().getParent().getName();
        }
        return name;
    }

    private String getViolationsPerKLOC(AbstractPMDRecord element) {
        String result = "";
        int vioCount = this.violationView.getNumberOfFilteredViolations(element);
        int loc = this.violationView.getLOC(element);
        if (loc == 0) {
            result = "N/A";
        } else {
            double vioPerLoc = (double)(vioCount * 1000) / (double)loc;
            if (vioPerLoc < 0.1) {
                result = "< 0.1";
            } else {
                DecimalFormat format = (DecimalFormat)NumberFormat.getInstance(Locale.US);
                format.applyPattern("##0.0");
                result = format.format(vioPerLoc);
            }
        }
        return result;
    }

    private String getViolationsPerMethod(AbstractPMDRecord element) {
        String result = "";
        int vioCount2 = this.violationView.getNumberOfFilteredViolations(element);
        int numMethods = this.violationView.getNumberOfMethods(element);
        if (numMethods == 0) {
            result = "N/A";
        } else {
            double vioPerMethod = (double)vioCount2 / (double)numMethods;
            if (vioPerMethod < 0.01 || numMethods == 0) {
                result = "< 0.01";
            } else {
                DecimalFormat format = (DecimalFormat)NumberFormat.getInstance(Locale.US);
                format.applyPattern("##0.00");
                result = format.format(vioPerMethod);
            }
        }
        return result;
    }

    private String getProjectName(Object element) {
        String projectName = "";
        AbstractPMDRecord projectRec = null;
        if (element instanceof PackageRecord) {
            projectRec = ((PackageRecord)element).getParent();
        } else if (element instanceof FileRecord) {
            projectRec = ((FileRecord)element).getParent().getParent();
        } else if (element instanceof MarkerRecord) {
            projectRec = ((MarkerRecord)element).getParent().getParent().getParent();
        } else if (element instanceof FileToMarkerRecord) {
            projectRec = ((FileToMarkerRecord)element).getParent().getParent().getParent().getParent();
        }
        if (projectRec != null) {
            projectName = projectRec.getName();
        }
        return projectName;
    }

    private Image getImage(String key, String iconPath) {
        return PMDPlugin.getDefault().getImage(key, iconPath);
    }
}

