/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import name.herlin.command.CommandException;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.builder.MarkerUtil;
import net.sourceforge.pmd.eclipse.runtime.cmd.DeleteMarkersCommand;
import net.sourceforge.pmd.eclipse.ui.model.AbstractPMDRecord;
import net.sourceforge.pmd.eclipse.ui.model.FileRecord;
import net.sourceforge.pmd.eclipse.ui.model.FileToMarkerRecord;
import net.sourceforge.pmd.eclipse.ui.model.MarkerRecord;
import net.sourceforge.pmd.eclipse.ui.model.PackageRecord;
import net.sourceforge.pmd.eclipse.ui.model.RootRecord;
import net.sourceforge.pmd.eclipse.ui.views.PriorityFilter;
import net.sourceforge.pmd.eclipse.ui.views.ProjectFilter;
import net.sourceforge.pmd.eclipse.ui.views.TableColumnSorter;
import net.sourceforge.pmd.eclipse.ui.views.ViewMemento;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOverviewContentProvider;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOverviewDoubleClickListener;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOverviewLabelProvider;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOverviewMenuManager;
import net.sourceforge.pmd.util.NumericConstants;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class ViolationOverview
extends ViewPart
implements ISelectionProvider,
ITreeViewerListener {
    private TreeViewer treeViewer;
    private ViolationOverviewContentProvider contentProvider;
    private ViolationOverviewLabelProvider labelProvider;
    private PriorityFilter priorityFilter;
    private ProjectFilter projectFilter;
    private ViolationOverviewMenuManager menuManager;
    private ViolationOverviewDoubleClickListener doubleClickListener;
    private RootRecord root;
    private ViewMemento memento;
    protected final Integer[] columnWidths = new Integer[5];
    protected final int[] columnSortOrder = new int[]{1, -1, -1, -1, 1};
    protected int currentSortedColumn;
    private int showType;
    protected static final String PACKAGE_SWITCH = "packageSwitch";
    protected static final String PRIORITY_LIST = "priorityFilterList";
    protected static final String PROJECT_LIST = "projectFilterList";
    protected static final String COLUMN_WIDTHS = "tableColumnWidths";
    protected static final String COLUMN_SORTER = "tableColumnSorter";
    public static final int SHOW_PACKAGES_FILES_MARKERS = 1;
    public static final int SHOW_FILES_MARKERS = 2;
    public static final int SHOW_MARKERS_FILES = 3;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.root = (RootRecord)this.getInitialInput();
        this.contentProvider = new ViolationOverviewContentProvider(this);
        this.labelProvider = new ViolationOverviewLabelProvider(this);
        this.priorityFilter = new PriorityFilter();
        this.projectFilter = new ProjectFilter();
        this.doubleClickListener = new ViolationOverviewDoubleClickListener(this);
        this.menuManager = new ViolationOverviewMenuManager(this);
        this.showType = 1;
        this.memento = new ViewMemento("/violationOverview_memento.xml");
        if (this.memento != null) {
            this.rememberFilterSettings();
        }
    }

    public void createPartControl(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 770);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.getTree().setHeaderVisible(true);
        this.treeViewer.getTree().setLinesVisible(true);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.addFilter((ViewerFilter)this.priorityFilter);
        this.treeViewer.addFilter((ViewerFilter)this.projectFilter);
        this.treeViewer.addTreeListener((ITreeViewerListener)this);
        this.menuManager.setupActions();
        this.createColumns(this.treeViewer.getTree());
        this.menuManager.createActionBars(this.getViewSite().getActionBars().getToolBarManager());
        this.menuManager.createDropDownMenu(this.getViewSite().getActionBars().getMenuManager());
        this.menuManager.createContextMenu();
        this.treeViewer.setInput((Object)this.root);
        this.treeViewer.addDoubleClickListener((IDoubleClickListener)this.doubleClickListener);
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        if (this.memento != null) {
            this.rememberTreeSettings();
        }
    }

    public void dispose() {
        this.memento.putList(PRIORITY_LIST, this.priorityFilter.getPriorityFilterList());
        List<AbstractPMDRecord> projects = this.projectFilter.getProjectFilterList();
        ArrayList<String> projectNames = new ArrayList<String>();
        int k = 0;
        while (k < projects.size()) {
            AbstractPMDRecord project = projects.get(k);
            projectNames.add(project.getName());
            ++k;
        }
        this.memento.putList(PROJECT_LIST, projectNames);
        List<Integer> widthList = Arrays.asList(this.columnWidths);
        this.memento.putList(COLUMN_WIDTHS, widthList);
        Integer[] sorterProps = new Integer[]{this.currentSortedColumn, this.columnSortOrder[this.currentSortedColumn]};
        List<Integer> sorterList = Arrays.asList(sorterProps);
        this.memento.putList(COLUMN_SORTER, sorterList);
        this.memento.putInteger(PACKAGE_SWITCH, this.getShowType());
        this.memento.save();
        super.dispose();
    }

    private Object getInitialInput() {
        return new RootRecord(ResourcesPlugin.getWorkspace().getRoot());
    }

    private void createColumns(Tree tree) {
        TreeColumn plusColumn = new TreeColumn(tree, 16384);
        plusColumn.setText(this.getString("view.overview.column_element"));
        plusColumn.setWidth(260);
        TreeColumn vioTotalColumn = new TreeColumn(tree, 131072);
        vioTotalColumn.setText(this.getString("view.overview.column_vio_total"));
        vioTotalColumn.setWidth(100);
        TreeColumn vioLocColumn = new TreeColumn(tree, 131072);
        vioLocColumn.setText(this.getString("view.overview.column_vio_loc"));
        vioLocColumn.setWidth(100);
        TreeColumn vioMethodColumn = new TreeColumn(tree, 131072);
        vioMethodColumn.setText(this.getString("view.overview.column_vio_method"));
        vioMethodColumn.setWidth(100);
        TreeColumn projectColumn = new TreeColumn(tree, 0x1000000);
        projectColumn.setText(this.getString("view.overview.column_project"));
        projectColumn.setWidth(100);
        this.createColumnAdapters(this.treeViewer.getTree());
        this.getViewerSorter(3);
    }

    private void createColumnAdapters(Tree tree) {
        TreeColumn[] columns = tree.getColumns();
        int k = 0;
        while (k < columns.length) {
            this.columnWidths[k] = columns[k].getWidth();
            columns[k].addSelectionListener((SelectionListener)new ColumnSelectionAdapter(k));
            columns[k].addControlListener((ControlListener)new ColumnControlAdapter(k));
            ++k;
        }
    }

    private ViewerSorter getViewerSorter(int columnNr) {
        TreeColumn column = this.treeViewer.getTree().getColumn(columnNr);
        int sortOrder = this.columnSortOrder[columnNr];
        ViewerSorter viewerSorter = null;
        switch (columnNr) {
            case 1: {
                viewerSorter = this.newViolationsCountSorter(column, sortOrder);
                break;
            }
            case 2: {
                viewerSorter = this.newViolationsPerLOCSorter(column, sortOrder);
                break;
            }
            case 3: {
                viewerSorter = this.newViolationsPerMethodsCount(column, sortOrder);
                break;
            }
            case 4: {
                viewerSorter = this.newProjectNameSorter(column, sortOrder);
                break;
            }
            default: {
                viewerSorter = this.newPackagesSorter(column, sortOrder);
            }
        }
        return viewerSorter;
    }

    public int getNumberOfFilteredViolations(AbstractPMDRecord record) {
        int number = 0;
        List<Integer> filterList = this.priorityFilter.getPriorityFilterList();
        int i = 0;
        while (i < filterList.size()) {
            Integer priority = filterList.get(i);
            number += record.getNumberOfViolationsToPriority(priority, this.getShowType() == 3);
            ++i;
        }
        return number;
    }

    public void setShowType(int type) {
        this.showType = type;
    }

    public int getShowType() {
        return this.showType;
    }

    public List<AbstractPMDRecord> getProjectFilterList() {
        return this.projectFilter.getProjectFilterList();
    }

    public List<Integer> getPriorityFilterList() {
        return this.priorityFilter.getPriorityFilterList();
    }

    public void setColumnWidths() {
        if (!this.treeViewer.getTree().isDisposed()) {
            TreeColumn[] columns = this.treeViewer.getTree().getColumns();
            int k = 0;
            while (k < this.columnWidths.length) {
                if (this.columnWidths[k] == null) {
                    this.columnWidths[k] = 75;
                }
                columns[k].setWidth(this.columnWidths[k].intValue());
                ++k;
            }
        }
    }

    public void setSorterProperties(Integer[] properties) {
        if (properties.length > 0) {
            this.currentSortedColumn = properties[0];
            this.columnSortOrder[this.currentSortedColumn] = properties[1];
            this.treeViewer.setSorter(this.getViewerSorter(this.currentSortedColumn));
        }
    }

    public void setFocus() {
        this.treeViewer.getTree().setFocus();
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    public AbstractPMDRecord[] getAllProjects() {
        AbstractPMDRecord[] projects = AbstractPMDRecord.EMPTY_RECORDS;
        if (this.root != null) {
            projects = this.root.getChildren();
        }
        return projects;
    }

    public void refresh() {
        if (!this.treeViewer.getControl().isDisposed()) {
            this.treeViewer.refresh();
            this.refreshMenu();
        }
    }

    public void refreshMenu() {
        this.menuManager.createDropDownMenu(this.getViewSite().getActionBars().getMenuManager());
        this.menuManager.createContextMenu();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.treeViewer.addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return this.treeViewer.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.treeViewer.removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.treeViewer.setSelection(selection);
    }

    private String getString(String key) {
        return PMDPlugin.getDefault().getStringTable().getString(key);
    }

    private void rememberFilterSettings() {
        Integer type;
        List<String> projectNames;
        List<Integer> priorityList = this.memento.getIntegerList(PRIORITY_LIST);
        if (!priorityList.isEmpty()) {
            this.priorityFilter.setPriorityFilterList(priorityList);
        }
        if (!(projectNames = this.memento.getStringList(PROJECT_LIST)).isEmpty()) {
            ArrayList<AbstractPMDRecord> projectList = new ArrayList<AbstractPMDRecord>();
            int k = 0;
            while (k < projectNames.size()) {
                AbstractPMDRecord project = this.root.findResourceByName(projectNames.get(k), 4);
                if (project != null) {
                    projectList.add(project);
                }
                ++k;
            }
            this.projectFilter.setProjectFilterList(projectList);
        }
        if ((type = this.memento.getInteger(PACKAGE_SWITCH)) != null) {
            this.setShowType(type);
        }
    }

    private void rememberTreeSettings() {
        List<Integer> sorterList;
        List<Integer> widthList = this.memento.getIntegerList(COLUMN_WIDTHS);
        if (!widthList.isEmpty()) {
            widthList.toArray(this.columnWidths);
            this.setColumnWidths();
        }
        if (!(sorterList = this.memento.getIntegerList(COLUMN_SORTER)).isEmpty()) {
            Integer[] sorterProps = new Integer[sorterList.size()];
            sorterList.toArray(sorterProps);
            this.setSorterProperties(sorterProps);
        }
    }

    private ViewerSorter newPackagesSorter(TreeColumn column, final int sortOrder) {
        return new TableColumnSorter(column, sortOrder){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String name1 = "";
                String name2 = "";
                if (e1 instanceof PackageRecord && e2 instanceof PackageRecord) {
                    name1 = ((PackageRecord)e1).getName();
                    name2 = ((PackageRecord)e2).getName();
                } else if (e1 instanceof FileRecord && e2 instanceof FileRecord) {
                    name1 = ((FileRecord)e1).getName();
                    name2 = ((FileRecord)e2).getName();
                }
                return name1.compareToIgnoreCase(name2) * sortOrder;
            }
        };
    }

    private ViewerSorter newViolationsCountSorter(TreeColumn column, final int sortOrder) {
        return new TableColumnSorter(column, sortOrder){

            public int compare(Viewer viewer, Object e1, Object e2) {
                int vio1 = 0;
                int vio2 = 0;
                if (e1 instanceof PackageRecord && e2 instanceof PackageRecord || e1 instanceof FileRecord && e2 instanceof FileRecord || e1 instanceof MarkerRecord && e2 instanceof MarkerRecord || e1 instanceof FileToMarkerRecord && e2 instanceof FileToMarkerRecord) {
                    vio1 = ViolationOverview.this.getNumberOfFilteredViolations((AbstractPMDRecord)e1);
                    vio2 = ViolationOverview.this.getNumberOfFilteredViolations((AbstractPMDRecord)e2);
                }
                return Integer.valueOf(vio1).compareTo(vio2) * sortOrder;
            }
        };
    }

    private ViewerSorter newViolationsPerLOCSorter(TreeColumn column, final int sortOrder) {
        return new TableColumnSorter(column, sortOrder){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Float vioPerLoc1 = NumericConstants.FLOAT_ZERO;
                Float vioPerLoc2 = NumericConstants.FLOAT_ZERO;
                if (e1 instanceof PackageRecord && e2 instanceof PackageRecord || e1 instanceof FileRecord && e2 instanceof FileRecord || e1 instanceof MarkerRecord && e2 instanceof MarkerRecord || e1 instanceof FileToMarkerRecord && e2 instanceof FileToMarkerRecord) {
                    int vio1 = ViolationOverview.this.getNumberOfFilteredViolations((AbstractPMDRecord)e1);
                    int vio2 = ViolationOverview.this.getNumberOfFilteredViolations((AbstractPMDRecord)e2);
                    int loc1 = ViolationOverview.this.getLOC((AbstractPMDRecord)e1);
                    int loc2 = ViolationOverview.this.getLOC((AbstractPMDRecord)e2);
                    if (loc1 > 0) {
                        vioPerLoc1 = Float.valueOf((float)vio1 / (float)loc1);
                    }
                    if (loc2 > 0) {
                        vioPerLoc2 = Float.valueOf((float)vio2 / (float)loc2);
                    }
                }
                return vioPerLoc1.compareTo(vioPerLoc2) * sortOrder;
            }
        };
    }

    private ViewerSorter newViolationsPerMethodsCount(TreeColumn column, final int sortOrder) {
        return new TableColumnSorter(column, sortOrder){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Float vioPerMethod1 = NumericConstants.FLOAT_ZERO;
                Float vioPerMethod2 = NumericConstants.FLOAT_ZERO;
                if (e1 instanceof PackageRecord && e2 instanceof PackageRecord || e1 instanceof FileRecord && e2 instanceof FileRecord || e1 instanceof MarkerRecord && e2 instanceof MarkerRecord || e1 instanceof FileToMarkerRecord && e2 instanceof FileToMarkerRecord) {
                    int vio1 = ViolationOverview.this.getNumberOfFilteredViolations((AbstractPMDRecord)e1);
                    int vio2 = ViolationOverview.this.getNumberOfFilteredViolations((AbstractPMDRecord)e2);
                    int numMethods1 = ViolationOverview.this.getNumberOfMethods((AbstractPMDRecord)e1);
                    int numMethods2 = ViolationOverview.this.getNumberOfMethods((AbstractPMDRecord)e2);
                    if (numMethods1 > 0) {
                        vioPerMethod1 = Float.valueOf((float)vio1 / (float)numMethods1);
                    }
                    if (numMethods2 > 0) {
                        vioPerMethod2 = Float.valueOf((float)vio2 / (float)numMethods2);
                    }
                }
                return vioPerMethod1.compareTo(vioPerMethod2) * sortOrder;
            }
        };
    }

    private ViewerSorter newProjectNameSorter(TreeColumn column, final int sortOrder) {
        return new TableColumnSorter(column, sortOrder){

            public int compare(Viewer viewer, Object e1, Object e2) {
                AbstractPMDRecord project1 = null;
                AbstractPMDRecord project2 = null;
                int result = 0;
                if (e1 instanceof PackageRecord && e2 instanceof PackageRecord) {
                    project1 = ((PackageRecord)e1).getParent();
                    project2 = ((PackageRecord)e2).getParent();
                    result = project1.getName().compareToIgnoreCase(project2.getName()) * sortOrder;
                }
                return result;
            }
        };
    }

    public void treeCollapsed(TreeExpansionEvent event) {
    }

    public void treeExpanded(TreeExpansionEvent event) {
        Object object = event.getElement();
        if (object instanceof PackageRecord) {
            AbstractPMDRecord[] children;
            PackageRecord record = (PackageRecord)object;
            AbstractPMDRecord[] abstractPMDRecordArray = children = record.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractPMDRecord element = abstractPMDRecordArray[n2];
                if (element instanceof FileRecord) {
                    FileRecord fileRecord = (FileRecord)element;
                    fileRecord.calculateLinesOfCode();
                    fileRecord.calculateNumberOfMethods();
                }
                ++n2;
            }
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ViolationOverview.this.getViewer().refresh();
            }
        });
    }

    public void deleteMarkers(AbstractPMDRecord element) throws CoreException {
        if (element instanceof MarkerRecord) {
            MarkerRecord record = (MarkerRecord)element;
            IMarker[] markers = MarkerUtil.EMPTY_MARKERS;
            switch (this.getShowType()) {
                case 1: 
                case 2: {
                    markers = record.findMarkers();
                    break;
                }
                case 3: {
                    AbstractPMDRecord packRec = record.getParent().getParent();
                    markers = packRec.findMarkersByAttribute("rulename", record.getName());
                }
            }
            this.deleteMarkers(markers);
        } else if (element instanceof FileToMarkerRecord) {
            FileToMarkerRecord record = (FileToMarkerRecord)element;
            IMarker[] markers = record.findMarkers();
            this.deleteMarkers(markers);
        } else {
            MarkerUtil.deleteAllMarkersIn(element.getResource());
        }
    }

    private void deleteMarkers(IMarker[] markers) {
        if (markers.length > 0) {
            DeleteMarkersCommand cmd = new DeleteMarkersCommand();
            cmd.setMarkers(markers);
            try {
                cmd.performExecute();
            }
            catch (CommandException e) {
                PMDPlugin.getDefault().showError(this.getString("message.error.core_exception"), e.getCause());
            }
        }
    }

    public int getLOC(AbstractPMDRecord element) {
        int loc = 0;
        loc = element instanceof MarkerRecord && this.getShowType() == 3 ? element.getParent().getParent().getLOC() : element.getLOC();
        return loc;
    }

    public int getNumberOfMethods(AbstractPMDRecord element) {
        int numberOfMethods = 0;
        numberOfMethods = element instanceof MarkerRecord && this.getShowType() == 3 ? element.getParent().getParent().getNumberOfMethods() : element.getNumberOfMethods();
        return numberOfMethods;
    }

    private class ColumnControlAdapter
    extends ControlAdapter {
        private final int column;

        public ColumnControlAdapter(int column) {
            this.column = column;
        }

        public void controlResized(ControlEvent e) {
            ViolationOverview.this.columnWidths[this.column] = ViolationOverview.this.treeViewer.getTree().getColumn(this.column).getWidth();
        }
    }

    private class ColumnSelectionAdapter
    extends SelectionAdapter {
        private final int column;

        public ColumnSelectionAdapter(int column) {
            this.column = column;
        }

        public void widgetSelected(SelectionEvent e) {
            int n = this.column;
            ViolationOverview.this.columnSortOrder[n] = ViolationOverview.this.columnSortOrder[n] * -1;
            ViolationOverview.this.treeViewer.setSorter(ViolationOverview.this.getViewerSorter(this.column));
        }
    }
}

