/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.priority;

import java.util.EnumSet;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.Shape;
import net.sourceforge.pmd.eclipse.ui.ShapeDescriptor;
import net.sourceforge.pmd.eclipse.ui.ShapePainter;
import net.sourceforge.pmd.eclipse.ui.views.actions.AbstractPMDAction;
import net.sourceforge.pmd.util.StringUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class PriorityDescriptor
implements Cloneable {
    public final RulePriority priority;
    public String label;
    public String description;
    public String filterText;
    public String iconId;
    public ShapeDescriptor shape;
    private static final RGB ProtoTransparentColour = new RGB(1, 1, 1);
    private static final char DELIMITER = '_';

    public static PriorityDescriptor from(String text) {
        String[] values = text.split(Character.toString('_'));
        if (values.length != 7) {
            return null;
        }
        RGB rgb = PriorityDescriptor.rgbFrom(values[5]);
        if (rgb == null) {
            return null;
        }
        return new PriorityDescriptor(RulePriority.valueOf((int)Integer.parseInt(values[0])), values[1], values[2], values[3], PriorityDescriptor.shapeFrom(values[4]), rgb, Integer.parseInt(values[6]));
    }

    private static Shape shapeFrom(String id) {
        int num = Integer.parseInt(id);
        for (Shape shape : EnumSet.allOf(Shape.class)) {
            if (shape.id != num) continue;
            return shape;
        }
        return null;
    }

    private static RGB rgbFrom(String desc) {
        String[] clrs = desc.split(",");
        if (clrs.length != 3) {
            return null;
        }
        return new RGB(Integer.parseInt(clrs[0]), Integer.parseInt(clrs[1]), Integer.parseInt(clrs[2]));
    }

    private static void rgbOn(StringBuilder sb, RGB rgb) {
        sb.append(rgb.red).append(',');
        sb.append(rgb.green).append(',');
        sb.append(rgb.blue);
    }

    public PriorityDescriptor(RulePriority thePriority, String theLabelKey, String theFilterTextKey, String theIconId, ShapeDescriptor theShape) {
        this.priority = thePriority;
        this.label = AbstractPMDAction.getString(theLabelKey);
        this.description = "--";
        this.filterText = AbstractPMDAction.getString(theFilterTextKey);
        this.iconId = theIconId;
        this.shape = theShape;
    }

    public PriorityDescriptor(RulePriority thePriority, String theLabelKey, String theFilterTextKey, String theIconId, Shape theShape, RGB theColor, int theSize) {
        this(thePriority, theLabelKey, theFilterTextKey, theIconId, new ShapeDescriptor(theShape, theColor, theSize));
    }

    private PriorityDescriptor(RulePriority thePriority) {
        this.priority = thePriority;
    }

    public String storeString() {
        StringBuilder sb = new StringBuilder();
        this.storeOn(sb);
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        PriorityDescriptor otherOne = (PriorityDescriptor)other;
        return this.priority.equals((Object)otherOne.priority) && StringUtil.isSame((String)this.label, (String)otherOne.label, (boolean)false, (boolean)false, (boolean)false) && this.shape.equals(otherOne.shape) && StringUtil.isSame((String)this.description, (String)otherOne.description, (boolean)false, (boolean)false, (boolean)false) && StringUtil.isSame((String)this.filterText, (String)otherOne.filterText, (boolean)false, (boolean)false, (boolean)false) && StringUtil.isSame((String)this.iconId, (String)otherOne.iconId, (boolean)false, (boolean)false, (boolean)false);
    }

    public int hashCode() {
        return this.priority.hashCode() ^ this.shape.hashCode() ^ String.valueOf(this.label).hashCode() ^ String.valueOf(this.description).hashCode() ^ String.valueOf(this.iconId).hashCode();
    }

    public void storeOn(StringBuilder sb) {
        sb.append(this.priority.getPriority()).append('_');
        sb.append(this.label).append('_');
        sb.append(this.filterText).append('_');
        sb.append(this.iconId).append('_');
        sb.append(this.shape.shape.id).append('_');
        PriorityDescriptor.rgbOn(sb, this.shape.rgbColor);
        sb.append('_');
        sb.append(this.shape.size).append('_');
    }

    public ImageDescriptor getImageDescriptor() {
        return PMDPlugin.getImageDescriptor(this.iconId);
    }

    public PriorityDescriptor clone() {
        PriorityDescriptor copy = new PriorityDescriptor(this.priority);
        copy.label = this.label;
        copy.description = this.description;
        copy.filterText = this.filterText;
        copy.iconId = this.iconId;
        copy.shape = this.shape.clone();
        return copy;
    }

    public Image getImage(Display display) {
        return ShapePainter.newDrawnImage(display, this.shape.size, this.shape.size, this.shape.shape, ProtoTransparentColour, this.shape.rgbColor);
    }

    public Image getImage(Display display, int maxDimension) {
        return ShapePainter.newDrawnImage(display, Math.min(this.shape.size, maxDimension), Math.min(this.shape.size, maxDimension), this.shape.shape, ProtoTransparentColour, this.shape.rgbColor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RuleDescriptor: ");
        sb.append(this.priority).append(", ");
        sb.append(this.label).append(", ");
        sb.append(this.description).append(", ");
        sb.append(this.filterText).append(", ");
        sb.append(this.iconId).append(", ");
        sb.append(this.shape);
        return sb.toString();
    }
}

