/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.editors;

import java.util.List;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.PropertySource;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.AbstractMultiValueEditorFactory;
import net.sourceforge.pmd.lang.rule.properties.PropertyDescriptorWrapper;
import net.sourceforge.pmd.lang.rule.properties.StringMultiProperty;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.StringUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class MultiStringEditorFactory
extends AbstractMultiValueEditorFactory {
    public static final MultiStringEditorFactory instance = new MultiStringEditorFactory();

    private MultiStringEditorFactory() {
    }

    @Override
    public PropertyDescriptor<?> createDescriptor(String name, String optionalDescription, Control[] otherData) {
        return new StringMultiProperty(name, "String value " + name, new String[]{""}, 0.0f, '|');
    }

    private static StringMultiProperty multiStringPropertyFrom(PropertyDescriptor<?> desc) {
        if (desc instanceof PropertyDescriptorWrapper) {
            return (StringMultiProperty)((PropertyDescriptorWrapper)desc).getPropertyDescriptor();
        }
        return (StringMultiProperty)desc;
    }

    @Override
    protected Control addWidget(Composite parent, Object value, PropertyDescriptor<?> desc, PropertySource source) {
        Text textWidget = new Text(parent, 2052);
        this.setValue((Control)textWidget, value);
        return textWidget;
    }

    @Override
    protected void setValue(Control widget, Object value) {
        ((Text)widget).setText(value == null ? "" : value.toString());
    }

    @Override
    protected void configure(final Text textWidget, final PropertyDescriptor<?> desc, final PropertySource source, final ValueChangeListener listener) {
        final StringMultiProperty smp = MultiStringEditorFactory.multiStringPropertyFrom(desc);
        Listener widgetListener = new Listener(){

            public void handleEvent(Event event) {
                Object[] newValues = MultiStringEditorFactory.this.textWidgetValues(textWidget);
                Object[] existingValues = (String[])MultiStringEditorFactory.this.valueFor(source, (PropertyDescriptor<?>)smp);
                if (CollectionUtil.areSemanticEquals((Object[])existingValues, (Object[])newValues)) {
                    return;
                }
                source.setProperty((PropertyDescriptor)smp, (Object)newValues);
                MultiStringEditorFactory.this.fillWidget(textWidget, desc, source);
                listener.changed(source, desc, (Object)newValues);
            }
        };
        textWidget.addListener(16, widgetListener);
    }

    @Override
    protected void update(PropertySource source, PropertyDescriptor<?> desc, List<Object> newValues) {
        source.setProperty((PropertyDescriptor)((StringMultiProperty)desc), (Object)newValues.toArray(new String[newValues.size()]));
    }

    @Override
    protected Object addValueIn(Control widget, PropertyDescriptor<?> desc, PropertySource source) {
        String[] newValues;
        String newValue = ((Text)widget).getText().trim();
        if (StringUtil.isEmpty((String)newValue)) {
            return null;
        }
        Object[] currentValues = (String[])this.valueFor(source, desc);
        if (currentValues.length == (newValues = (String[])CollectionUtil.addWithoutDuplicates((Object[])currentValues, (Object)newValue)).length) {
            return null;
        }
        source.setProperty((PropertyDescriptor)((StringMultiProperty)desc), (Object)newValues);
        return newValue;
    }

    @Override
    protected Object valueFrom(Control valueControl) {
        return null;
    }
}

