/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.br;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.PropertySource;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleCollection;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleFieldAccessor;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleVisitor;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.Configuration;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.rule.RuleReference;
import net.sourceforge.pmd.lang.rule.XPathRule;
import net.sourceforge.pmd.util.CollectionUtil;

public class RuleUtil {
    private RuleUtil() {
    }

    public static boolean isDefaultValue(Map.Entry<PropertyDescriptor<?>, Object> entry) {
        PropertyDescriptor<?> desc = entry.getKey();
        Object value = entry.getValue();
        return RuleUtil.areEqual(desc.defaultValue(), value);
    }

    public static boolean isXPathRule(PropertySource source) {
        if (source instanceof XPathRule) {
            return true;
        }
        if (source instanceof RuleReference) {
            Rule realOne = ((RuleReference)source).getRule();
            return realOne instanceof XPathRule;
        }
        return false;
    }

    public static boolean areEqual(Object value, Object otherValue) {
        if (value == otherValue) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if (otherValue == null) {
            return false;
        }
        if (value.getClass().getComponentType() != null) {
            return CollectionUtil.arraysAreEqual((Object)value, (Object)otherValue);
        }
        if (value instanceof Float || value instanceof Double) {
            return RuleUtil.areEqualNumbers((Number)value, (Number)otherValue);
        }
        return value.equals(otherValue);
    }

    public static boolean areEqualNumbers(Number a, Number b) {
        double db;
        double da = a.doubleValue();
        double delta = da - (db = b.doubleValue());
        double pctDelta = delta / da;
        return pctDelta < 1.0E-4;
    }

    public static boolean hasDefaultValues(Rule rule) {
        Map<PropertyDescriptor<?>, Object> valuesByProperty = Configuration.filteredPropertiesOf((PropertySource)rule);
        for (Map.Entry<PropertyDescriptor<?>, Object> entry : valuesByProperty.entrySet()) {
            if (RuleUtil.isDefaultValue(entry)) continue;
            return false;
        }
        return true;
    }

    public static Set<PropertyDescriptor<?>> modifiedPropertiesIn(Rule rule) {
        HashSet descs = new HashSet();
        for (Map.Entry<PropertyDescriptor<?>, Object> entry : Configuration.filteredPropertiesOf((PropertySource)rule).entrySet()) {
            if (RuleUtil.isDefaultValue(entry)) continue;
            descs.add(entry.getKey());
        }
        return descs;
    }

    public static Set<Comparable<?>> uniqueItemsIn(Object item, RuleFieldAccessor getter) {
        if (item instanceof Rule) {
            HashSet values = new HashSet(1);
            values.add(getter.valueFor((Rule)item));
            return values;
        }
        if (item instanceof RuleCollection) {
            return getter.uniqueValuesFor((RuleCollection)item);
        }
        return Collections.emptySet();
    }

    private static Class<Rule> rootImplementationClassOf(RuleReference reference) {
        Rule rule = reference.getRule();
        while (rule.getClass() == RuleReference.class) {
            rule = ((RuleReference)rule).getRule();
        }
        return rule.getClass();
    }

    public static Class<Rule> implementationClassOf(Rule rule) {
        if (rule instanceof RuleReference) {
            return RuleUtil.rootImplementationClassOf((RuleReference)rule);
        }
        return rule.getClass();
    }

    public static boolean allUseDefaultValues(RuleCollection collection) {
        if (collection.isEmpty()) {
            return false;
        }
        RuleVisitor visitor = new RuleVisitor(){

            @Override
            public boolean accept(Rule rule) {
                return rule.usesDefaultValues();
            }
        };
        return collection.rulesDo(visitor);
    }

    public static boolean allUseDfa(RuleCollection collection) {
        if (collection.isEmpty()) {
            return false;
        }
        RuleVisitor visitor = new RuleVisitor(){

            @Override
            public boolean accept(Rule rule) {
                return rule.usesDFA();
            }
        };
        return collection.rulesDo(visitor);
    }

    public static boolean allUseTypeResolution(RuleCollection collection) {
        if (collection.isEmpty()) {
            return false;
        }
        RuleVisitor visitor = new RuleVisitor(){

            @Override
            public boolean accept(Rule rule) {
                return rule.usesTypeResolution();
            }
        };
        return collection.rulesDo(visitor);
    }

    public static RulePriority commonPriority(RuleCollection collection) {
        if (collection.isEmpty()) {
            return null;
        }
        final RulePriority[] prio = new RulePriority[1];
        RuleVisitor visitor = new RuleVisitor(){

            @Override
            public boolean accept(Rule rule) {
                if (prio[0] == null) {
                    prio[0] = rule.getPriority();
                }
                if (prio[0] != rule.getPriority()) {
                    prio[0] = null;
                    return false;
                }
                return true;
            }
        };
        collection.rulesDo(visitor);
        return prio[0];
    }

    private static String format(Object item) {
        return item == null ? "" : String.valueOf(item);
    }

    public static String asString(Set<Comparable<?>> items) {
        Iterator<Comparable<?>> iter = items.iterator();
        if (items.size() == 1) {
            return RuleUtil.format(iter.next());
        }
        StringBuilder sb = new StringBuilder(RuleUtil.format(iter.next()));
        while (iter.hasNext()) {
            sb.append(", ").append(RuleUtil.format(iter.next()));
        }
        return sb.toString();
    }

    public static Map<RulePriority, Float> fractionsByPriority(RuleCollection collection) {
        if (collection.isEmpty()) {
            return Collections.emptyMap();
        }
        final HashMap priorityCounts = new HashMap(5);
        final int[] count = new int[1];
        RuleVisitor visitor = new RuleVisitor(){

            @Override
            public boolean accept(Rule rule) {
                RulePriority priority = rule.getPriority();
                count[0] = count[0] + 1;
                Integer count2 = (Integer)priorityCounts.get(priority);
                if (count2 == null) {
                    priorityCounts.put(priority, 1);
                } else {
                    priorityCounts.put(priority, count2 + 1);
                }
                return true;
            }
        };
        collection.rulesDo(visitor);
        int total = count[0];
        HashMap<RulePriority, Float> priorityFractions = new HashMap<RulePriority, Float>();
        for (Map.Entry entry : priorityCounts.entrySet()) {
            float fraction = (float)((Integer)entry.getValue()).intValue() / (float)total;
            priorityFractions.put((RulePriority)entry.getKey(), Float.valueOf(fraction));
        }
        return priorityFractions;
    }

    public static String commonRuleset(RuleCollection collection) {
        if (collection.isEmpty()) {
            return null;
        }
        final HashSet names = new HashSet(2);
        RuleVisitor visitor = new RuleVisitor(){

            @Override
            public boolean accept(Rule rule) {
                names.add(rule.getRuleSetName().trim());
                return names.size() < 2;
            }
        };
        collection.rulesDo(visitor);
        return names.size() > 1 ? null : (String)names.iterator().next();
    }

    public static Class<Rule> commonImplementationClass(RuleCollection collection) {
        if (collection.isEmpty()) {
            return null;
        }
        final HashSet types = new HashSet(2);
        RuleVisitor visitor = new RuleVisitor(){

            @Override
            public boolean accept(Rule rule) {
                types.add(RuleUtil.implementationClassOf(rule));
                return types.size() < 2;
            }
        };
        collection.rulesDo(visitor);
        return types.size() > 1 ? null : (Class)types.iterator().next();
    }

    public static Comparable<?> commonAspect(RuleCollection collection, final RuleFieldAccessor accessor) {
        if (collection.isEmpty()) {
            return null;
        }
        final Comparable[] aspect = new Comparable[1];
        RuleVisitor visitor = new RuleVisitor(){

            @Override
            public boolean accept(Rule rule) {
                if (aspect[0] == null) {
                    aspect[0] = accessor.valueFor(rule);
                    return true;
                }
                if (RuleUtil.areEqual(aspect[0], accessor.valueFor(rule))) {
                    aspect[0] = null;
                    return false;
                }
                return true;
            }
        };
        collection.rulesDo(visitor);
        return aspect[0];
    }

    public static int countNonOccurrencesOf(RuleCollection collection, final RuleFieldAccessor accessor, final Object item) {
        if (collection.isEmpty()) {
            return 0;
        }
        final int[] count = new int[1];
        RuleVisitor visitor = new RuleVisitor(){

            @Override
            public boolean accept(Rule rule) {
                Comparable<?> value = accessor.valueFor(rule);
                if (value != item) {
                    count[0] = count[0] + 1;
                }
                return true;
            }
        };
        collection.rulesDo(visitor);
        return count[0];
    }

    public static Set<Comparable<?>> uniqueAspects(RuleCollection collection, final RuleFieldAccessor accessor) {
        if (collection.isEmpty()) {
            return Collections.emptySet();
        }
        final HashSet aspects = new HashSet();
        RuleVisitor visitor = new RuleVisitor(){

            @Override
            public boolean accept(Rule rule) {
                aspects.add(accessor.valueFor(rule));
                return true;
            }
        };
        collection.rulesDo(visitor);
        return aspects;
    }

    public static Language commonLanguage(RuleCollection collection) {
        if (collection.isEmpty()) {
            return null;
        }
        final Language[] type = new Language[1];
        RuleVisitor visitor = new RuleVisitor(){

            @Override
            public boolean accept(Rule rule) {
                if (type[0] == null) {
                    type[0] = rule.getLanguage();
                    return true;
                }
                if (type[0] != rule.getLanguage()) {
                    type[0] = null;
                    return false;
                }
                return true;
            }
        };
        collection.rulesDo(visitor);
        return type[0];
    }

    public static LanguageVersion commonLanguageMinVersion(RuleCollection collection) {
        if (collection.isEmpty()) {
            return null;
        }
        final LanguageVersion[] version = new LanguageVersion[1];
        RuleVisitor visitor = new RuleVisitor(){

            @Override
            public boolean accept(Rule rule) {
                if (version[0] == null) {
                    version[0] = rule.getMinimumLanguageVersion();
                    return true;
                }
                if (version[0] != rule.getMinimumLanguageVersion()) {
                    version[0] = null;
                    return false;
                }
                return true;
            }
        };
        collection.rulesDo(visitor);
        return version[0];
    }

    public static LanguageVersion commonLanguageMaxVersion(RuleCollection collection) {
        if (collection.isEmpty()) {
            return null;
        }
        final LanguageVersion[] version = new LanguageVersion[1];
        RuleVisitor visitor = new RuleVisitor(){

            @Override
            public boolean accept(Rule rule) {
                if (version[0] == null) {
                    version[0] = rule.getMaximumLanguageVersion();
                    return true;
                }
                if (version[0] != rule.getMaximumLanguageVersion()) {
                    version[0] = null;
                    return false;
                }
                return true;
            }
        };
        collection.rulesDo(visitor);
        return version[0];
    }
}

