/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.br;

import java.util.ArrayList;
import java.util.Set;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.eclipse.plugin.UISettings;
import net.sourceforge.pmd.eclipse.ui.preferences.br.BasicRuleFieldAccessor;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleCollection;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleUtil;
import net.sourceforge.pmd.eclipse.ui.quickfix.PMDResolutionGenerator;
import net.sourceforge.pmd.eclipse.util.Util;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.rule.XPathRule;

public interface RuleFieldAccessor {
    public static final String[] ruleTypeGeneric = new String[]{"-", "Generic"};
    public static final String[] ruleTypeXPath = new String[]{"X", "XPath"};
    public static final String[] ruleTypeDFlow = new String[]{"D", "Dataflow"};
    public static final String[] ruleTypeTypeRes = new String[]{"T", "Type resolving"};
    public static final RuleFieldAccessor since = new BasicRuleFieldAccessor(){

        public Comparable<String> valueFor(Rule rule) {
            return rule.getSince();
        }
    };
    public static final RuleFieldAccessor priority = new BasicRuleFieldAccessor(){

        @Override
        public Comparable<?> valueFor(Rule rule) {
            return rule.getPriority();
        }

        @Override
        public String labelFor(Rule rule) {
            return UISettings.labelFor(rule.getPriority());
        }

        @Override
        public Comparable<?> valueFor(RuleCollection collection) {
            return RuleUtil.commonPriority(collection);
        }
    };
    public static final RuleFieldAccessor priorityName = new BasicRuleFieldAccessor(){

        public Comparable<String> valueFor(Rule rule) {
            return UISettings.labelFor(rule.getPriority());
        }
    };
    public static final RuleFieldAccessor fixCount = new BasicRuleFieldAccessor(){

        public Comparable<Integer> valueFor(Rule rule) {
            return PMDResolutionGenerator.fixCountFor(rule);
        }
    };
    public static final RuleFieldAccessor name = new BasicRuleFieldAccessor(){

        public Comparable<String> valueFor(Rule rule) {
            return rule.getName();
        }
    };
    public static final RuleFieldAccessor description = new BasicRuleFieldAccessor(){

        public Comparable<String> valueFor(Rule rule) {
            return rule.getDescription();
        }
    };
    public static final RuleFieldAccessor usesDFA = new BasicRuleFieldAccessor(){

        public Comparable<Boolean> valueFor(Rule rule) {
            return rule.usesDFA();
        }

        @Override
        public Comparable<?> valueFor(RuleCollection collection) {
            return RuleUtil.allUseDfa(collection);
        }
    };
    public static final RuleFieldAccessor message = new BasicRuleFieldAccessor(){

        public Comparable<String> valueFor(Rule rule) {
            return rule.getMessage();
        }
    };
    public static final RuleFieldAccessor url = new BasicRuleFieldAccessor(){

        public Comparable<String> valueFor(Rule rule) {
            return rule.getExternalInfoUrl();
        }
    };
    public static final RuleFieldAccessor exampleCount = new BasicRuleFieldAccessor(){

        @Override
        public Comparable<?> valueFor(Rule rule) {
            int count = rule.getExamples().size();
            return count > 0 ? Integer.toString(count) : "";
        }
    };
    public static final RuleFieldAccessor ruleType = new BasicRuleFieldAccessor(){
        final int labelTypeIdx = 0;

        public Comparable<String> valueFor(Rule rule) {
            StringBuilder sb = new StringBuilder(3);
            if (rule.hasDescriptor((PropertyDescriptor)XPathRule.XPATH_DESCRIPTOR)) {
                sb.append(ruleTypeXPath[0]);
            }
            if (rule.usesDFA()) {
                sb.append(ruleTypeDFlow[0]);
            }
            if (rule.usesTypeResolution()) {
                sb.append(ruleTypeTypeRes[0]);
            }
            if (sb.length() == 0) {
                sb.append(ruleTypeGeneric[0]);
            }
            return sb.toString();
        }

        @Override
        public String labelFor(Rule rule) {
            ArrayList<String> types = new ArrayList<String>(3);
            if (rule.hasDescriptor((PropertyDescriptor)XPathRule.XPATH_DESCRIPTOR)) {
                types.add(ruleTypeXPath[0]);
            }
            if (rule.usesDFA()) {
                types.add(ruleTypeDFlow[0]);
            }
            if (rule.usesTypeResolution()) {
                types.add(ruleTypeTypeRes[0]);
            }
            if (types.isEmpty()) {
                types.add(ruleTypeGeneric[0]);
            }
            return Util.asString(types, ", ");
        }
    };
    public static final RuleFieldAccessor language = new BasicRuleFieldAccessor(){

        public Comparable<Language> valueFor(Rule rule) {
            return rule.getLanguage();
        }

        @Override
        public String labelFor(Rule rule) {
            return rule.getLanguage().getName();
        }
    };
    public static final RuleFieldAccessor minLanguageVersion = new BasicRuleFieldAccessor(){

        public Comparable<LanguageVersion> valueFor(Rule rule) {
            return rule.getMinimumLanguageVersion();
        }
    };
    public static final RuleFieldAccessor maxLanguageVersion = new BasicRuleFieldAccessor(){

        public Comparable<LanguageVersion> valueFor(Rule rule) {
            return rule.getMaximumLanguageVersion();
        }
    };
    public static final RuleFieldAccessor violationRegex = new BasicRuleFieldAccessor(){

        public Comparable<String> valueFor(Rule rule) {
            return (Comparable)rule.getProperty((PropertyDescriptor)Rule.VIOLATION_SUPPRESS_REGEX_DESCRIPTOR);
        }
    };
    public static final RuleFieldAccessor violationXPath = new BasicRuleFieldAccessor(){

        public Comparable<String> valueFor(Rule rule) {
            return (Comparable)rule.getProperty((PropertyDescriptor)Rule.VIOLATION_SUPPRESS_XPATH_DESCRIPTOR);
        }
    };
    public static final RuleFieldAccessor nonDefaultProperyCount = new BasicRuleFieldAccessor(){

        public Comparable<Integer> valueFor(Rule rule) {
            return RuleUtil.modifiedPropertiesIn(rule).size();
        }
    };

    public Comparable<?> valueFor(Rule var1);

    public Comparable<?> valueFor(RuleCollection var1);

    public Set<Comparable<?>> uniqueValuesFor(RuleCollection var1);

    public String labelFor(Rule var1);
}

