/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.br;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.PropertySource;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.preferences.impl.PreferenceUIStore;
import net.sourceforge.pmd.eclipse.ui.ModifyListener;
import net.sourceforge.pmd.eclipse.ui.preferences.br.AbstractPMDPreferencePage;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleColumnDescriptor;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleSelection;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleSelectionListener;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleTableColumns;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleTableManager;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueResetHandler;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.SWTUtil;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.DescriptionPanelManager;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.EditorUsageMode;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.ExamplePanelManager;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.ExclusionPanelManager;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.PerRulePropertyPanelManager;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.RulePanelManager;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.RulePropertyManager;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.SummaryPanelManager;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.XPathPanelManager;
import net.sourceforge.pmd.eclipse.util.Util;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Tree;

public class PMDPreferencePage2
extends AbstractPMDPreferencePage
implements RuleSelectionListener,
ModifyListener,
ValueChangeListener,
ValueResetHandler {
    private TabFolder tabFolder;
    private RulePropertyManager[] rulePropertyManagers;
    private RuleTableManager tableManager;
    private Button globalRuleManagementCheckButton;
    public static final RuleColumnDescriptor[] availableColumns = new RuleColumnDescriptor[]{RuleTableColumns.name, RuleTableColumns.imgPriority, RuleTableColumns.since, RuleTableColumns.ruleSetName, RuleTableColumns.ruleType, RuleTableColumns.minLangVers, RuleTableColumns.maxLangVers, RuleTableColumns.language, RuleTableColumns.filterViolationRegex, RuleTableColumns.filterViolationXPath, RuleTableColumns.modCount, RuleTableColumns.imgProperties};
    public static final Object[][] groupingChoices;

    static {
        Object[][] objectArrayArray = new Object[7][];
        objectArrayArray[0] = new Object[]{RuleTableColumns.ruleSetName, "preference.ruleset.column.ruleset"};
        objectArrayArray[1] = new Object[]{RuleTableColumns.since, "preference.ruleset.grouping.pmd_version"};
        objectArrayArray[2] = new Object[]{RuleTableColumns.priorityName, "preference.ruleset.column.priority"};
        objectArrayArray[3] = new Object[]{RuleTableColumns.ruleType, "preference.ruleset.column.rule_type"};
        objectArrayArray[4] = new Object[]{RuleTableColumns.language, "preference.ruleset.column.language"};
        objectArrayArray[5] = new Object[]{RuleTableColumns.filterViolationRegex, "preference.ruleset.grouping.regex"};
        Object[] objectArray = new Object[2];
        objectArray[1] = "preference.ruleset.grouping.none";
        objectArrayArray[6] = objectArray;
        groupingChoices = objectArrayArray;
    }

    public static RulePropertyManager[] buildPropertyManagersOn(TabFolder folder, ValueChangeListener listener) {
        return new RulePropertyManager[]{PMDPreferencePage2.buildFullViewTab(folder, 0, SWTUtil.stringFor("preference.ruleedit.tab.fullview"), listener), PMDPreferencePage2.buildRuleTab(folder, 1, SWTUtil.stringFor("preference.ruleedit.tab.rule"), listener), PMDPreferencePage2.buildPropertyTab(folder, 2, SWTUtil.stringFor("preference.ruleedit.tab.properties"), listener), PMDPreferencePage2.buildExclusionTab(folder, 3, SWTUtil.stringFor("preference.ruleedit.tab.exclusions"), listener), PMDPreferencePage2.buildXPathTab(folder, 4, SWTUtil.stringFor("preference.ruleedit.tab.xpath"), listener)};
    }

    @Override
    protected String descriptionId() {
        return "preference.ruleset.title";
    }

    protected Control createContents(Composite parent) {
        this.tableManager = new RuleTableManager("rules", availableColumns, PMDPlugin.getDefault().loadPreferences(), this);
        this.tableManager.modifyListener(this);
        this.tableManager.selectionListener(this);
        this.populateRuleset();
        Composite composite = new Composite(parent, 0);
        this.layoutControls(composite);
        this.tableManager.populateRuleTable();
        int i = PreferenceUIStore.instance.selectedPropertyTab();
        this.tabFolder.setSelection(i);
        return composite;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setModified(false);
    }

    public static Composite buildRulePropertiesTableButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.wrap = false;
        rowLayout.pack = false;
        composite.setLayout((Layout)rowLayout);
        return composite;
    }

    private Composite createRuleSection(Composite parent) {
        Composite ruleSection = new Composite(parent, 0);
        Composite groupCombo = this.tableManager.buildGroupCombo(ruleSection, "preference.ruleset.label.rules_grouped_by", groupingChoices);
        Tree ruleTree = this.tableManager.buildRuleTreeViewer(ruleSection);
        this.tableManager.groupBy(null);
        Composite ruleTableButtons = this.tableManager.buildRuleTableButtons(ruleSection);
        Composite rulePropertiesTableButtons = PMDPreferencePage2.buildRulePropertiesTableButtons(ruleSection);
        GridLayout gridLayout = new GridLayout(3, false);
        ruleSection.setLayout((Layout)gridLayout);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        groupCombo.setLayoutData((Object)data);
        data = new GridData();
        data.heightHint = 200;
        data.widthHint = 350;
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        ruleTree.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        ruleTableButtons.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        rulePropertiesTableButtons.setLayoutData((Object)data);
        return ruleSection;
    }

    private TabFolder buildTabFolder(Composite parent) {
        this.tabFolder = new TabFolder(parent, 128);
        this.rulePropertyManagers = PMDPreferencePage2.buildPropertyManagersOn(this.tabFolder, this);
        this.tabFolder.pack();
        return this.tabFolder;
    }

    private static RulePropertyManager buildRuleTab(TabFolder parent, int index, String title, ValueChangeListener listener) {
        TabItem tab = new TabItem(parent, 0, index);
        tab.setText(title);
        RulePanelManager manager = new RulePanelManager(title, EditorUsageMode.Editing, listener, null);
        tab.setControl(manager.setupOn((Composite)parent));
        manager.tab(tab);
        return manager;
    }

    private static RulePropertyManager buildPropertyTab(TabFolder parent, int index, String title, ValueChangeListener listener) {
        TabItem tab = new TabItem(parent, 0, index);
        tab.setText(title);
        PerRulePropertyPanelManager manager = new PerRulePropertyPanelManager(title, EditorUsageMode.Editing, listener);
        tab.setControl(manager.setupOn((Composite)parent));
        manager.tab(tab);
        return manager;
    }

    private static RulePropertyManager buildDescriptionTab(TabFolder parent, int index, String title, ValueChangeListener listener) {
        TabItem tab = new TabItem(parent, 0, index);
        tab.setText(title);
        DescriptionPanelManager manager = new DescriptionPanelManager(title, EditorUsageMode.Editing, listener);
        tab.setControl(manager.setupOn((Composite)parent));
        manager.tab(tab);
        return manager;
    }

    private static RulePropertyManager buildXPathTab(TabFolder parent, int index, String title, ValueChangeListener listener) {
        TabItem tab = new TabItem(parent, 0, index);
        tab.setText(title);
        XPathPanelManager manager = new XPathPanelManager(title, EditorUsageMode.Editing, listener);
        tab.setControl(manager.setupOn((Composite)parent));
        manager.tab(tab);
        return manager;
    }

    private static RulePropertyManager buildFullViewTab(TabFolder parent, int index, String title, ValueChangeListener listener) {
        TabItem tab = new TabItem(parent, 0, index);
        tab.setText(title);
        SummaryPanelManager manager = new SummaryPanelManager("asdf", title, EditorUsageMode.Editing, listener);
        tab.setControl(manager.setupOn((Composite)parent));
        manager.tab(tab);
        return manager;
    }

    private static RulePropertyManager buildExampleTab(TabFolder parent, int index, String title, ValueChangeListener listener) {
        TabItem tab = new TabItem(parent, 0, index);
        tab.setText(title);
        ExamplePanelManager manager = new ExamplePanelManager(title, EditorUsageMode.Editing, listener);
        tab.setControl(manager.setupOn((Composite)parent));
        manager.tab(tab);
        return manager;
    }

    private static RulePropertyManager buildExclusionTab(TabFolder parent, int index, String title, ValueChangeListener listener) {
        TabItem tab = new TabItem(parent, 0, index);
        tab.setText(title);
        ExclusionPanelManager manager = new ExclusionPanelManager(title, EditorUsageMode.Editing, listener, true);
        tab.setControl(manager.setupOn((Composite)parent));
        manager.tab(tab);
        return manager;
    }

    @Override
    public void changed(PropertySource source, PropertyDescriptor<?> desc, Object newValue) {
        this.setModified();
        this.tableManager.updated(source);
    }

    @Override
    public void changed(RuleSelection selection, PropertyDescriptor<?> desc, Object newValue) {
        for (Rule rule : selection.allRules()) {
            if (newValue != null) {
                this.tableManager.changed(selection, desc, newValue);
                continue;
            }
            this.tableManager.changed((PropertySource)rule, desc, newValue);
        }
        RulePropertyManager[] rulePropertyManagerArray = this.rulePropertyManagers;
        int n = this.rulePropertyManagers.length;
        int n2 = 0;
        while (n2 < n) {
            RulePropertyManager manager = rulePropertyManagerArray[n2];
            manager.validate();
            ++n2;
        }
        this.setModified();
    }

    private void layoutControls(Composite parent) {
        Button checkButton;
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 10;
        parent.setLayout((Layout)layout);
        Composite checkboxPanel = new Composite(parent, 0);
        RowLayout checkboxPanelLayout = new RowLayout(512);
        checkboxPanelLayout.fill = true;
        checkboxPanelLayout.pack = false;
        checkboxPanel.setLayout((Layout)checkboxPanelLayout);
        checkboxPanel.setLayoutData((Object)new GridData(768));
        this.globalRuleManagementCheckButton = checkButton = new Button(checkboxPanel, 32);
        final Composite contentPanel = new Composite(parent, 0);
        contentPanel.setLayout((Layout)new FormLayout());
        contentPanel.setLayoutData((Object)new GridData(1808));
        checkButton.setText(SWTUtil.stringFor("preference.ruleset.button.globalrulemanagement"));
        checkButton.setSelection(this.preferences.getGlobalRuleManagement());
        checkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean sel = checkButton.getSelection();
                SWTUtil.setEnabledRecursive(contentPanel.getChildren(), sel);
                PMDPreferencePage2.this.setModified();
            }
        });
        Label explanation = new Label(checkboxPanel, 64);
        RowData rowData = new RowData();
        rowData.width = 450;
        explanation.setLayoutData((Object)rowData);
        explanation.setText(SWTUtil.stringFor("preference.ruleset.button.globalrulemanagement.explanation"));
        int ruleTableFraction = 55;
        final Sash sash = new Sash(contentPanel, 256);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(ruleTableFraction, 0);
        sash.setLayoutData((Object)data);
        sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ((FormData)sash.getLayoutData()).top = new FormAttachment(0, event.y);
                contentPanel.layout();
            }
        });
        Composite ruleSection = this.createRuleSection(contentPanel);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment((Control)sash, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        ruleSection.setLayoutData((Object)data);
        TabFolder propertySection = this.buildTabFolder(contentPanel);
        data = new FormData();
        data.top = new FormAttachment((Control)sash, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        propertySection.setLayoutData((Object)data);
        SWTUtil.setEnabledRecursive(contentPanel.getChildren(), checkButton.getSelection());
    }

    @Override
    public boolean performOk() {
        this.saveUIState();
        if (this.isModified()) {
            this.updateRuleSet();
            this.rebuildProjects();
            this.storeActiveRules();
        }
        return super.performOk();
    }

    public boolean performCancel() {
        this.saveUIState();
        return super.performCancel();
    }

    protected void performDefaults() {
        this.tableManager.populateRuleTable();
        super.performDefaults();
    }

    private void populateRuleset() {
        RuleSet defaultRuleSet = plugin.getPreferencesManager().getRuleSet();
        RuleSet ruleSet = new RuleSet();
        ruleSet.addRuleSet(defaultRuleSet);
        ruleSet.setName(defaultRuleSet.getName());
        ruleSet.setDescription(Util.asCleanString(defaultRuleSet.getDescription()));
        ruleSet.addExcludePatterns((Collection)defaultRuleSet.getExcludePatterns());
        ruleSet.addIncludePatterns((Collection)defaultRuleSet.getIncludePatterns());
        this.tableManager.useRuleSet(ruleSet);
    }

    @Override
    public void selection(RuleSelection selection) {
        if (this.rulePropertyManagers == null) {
            return;
        }
        RulePropertyManager[] rulePropertyManagerArray = this.rulePropertyManagers;
        int n = this.rulePropertyManagers.length;
        int n2 = 0;
        while (n2 < n) {
            RulePropertyManager manager = rulePropertyManagerArray[n2];
            manager.manage(selection);
            manager.validate();
            ++n2;
        }
    }

    private void saveUIState() {
        this.tableManager.saveUIState();
        int i = this.tabFolder.getSelectionIndex();
        PreferenceUIStore.instance.selectedPropertyTab(i);
        PreferenceUIStore.instance.globalRuleManagement(this.globalRuleManagementCheckButton.getSelection());
        this.preferences.setGlobalRuleManagement(this.globalRuleManagementCheckButton.getSelection());
        PreferenceUIStore.instance.save();
    }

    private void storeActiveRules() {
        List<Rule> chosenRules = this.tableManager.activeRules();
        for (Rule rule : chosenRules) {
            this.preferences.isActive(rule.getName(), true);
        }
    }

    private void updateRuleSet() {
        try {
            ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(this.getShell());
            monitorDialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    plugin.getPreferencesManager().setRuleSet(PMDPreferencePage2.this.tableManager.ruleSet());
                }
            });
        }
        catch (Exception e) {
            plugin.logError("Exception updating all projects after a preference change", e);
        }
    }

    @Override
    public void resetValuesIn(RuleSelection rules) {
        rules.useDefaultValues();
        this.tableManager.refresh();
        RulePropertyManager[] rulePropertyManagerArray = this.rulePropertyManagers;
        int n = this.rulePropertyManagers.length;
        int n2 = 0;
        while (n2 < n) {
            RulePropertyManager rpm = rulePropertyManagerArray[n2];
            rpm.loadValues();
            ++n2;
        }
    }
}

