/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.search;

import java.util.List;
import net.sourceforge.pmd.lang.Language;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RuleSearchPage
extends DialogPage
implements ISearchPage {
    private Text idText;
    private Button caseSensitive;
    private String selected;
    private Button name;
    private Button description;
    private Button example;
    private Button xpath;
    private Combo language;

    public RuleSearchPage() {
    }

    public RuleSearchPage(String title) {
        super(title);
    }

    public RuleSearchPage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public boolean performAction() {
        return false;
    }

    public void setContainer(ISearchPageContainer container) {
        if (container.getSelection() instanceof TextSelection) {
            this.selected = ((TextSelection)container.getSelection()).getText();
        }
    }

    public void buildLanguageCombo(Composite parent) {
        List languages = Language.findWithRuleSupport();
        this.language = new Combo(parent, 8);
        Language deflt = Language.getDefaultLanguage();
        int selectionIndex = -1;
        int i = 0;
        while (i < languages.size()) {
            if (languages.get(i) == deflt) {
                selectionIndex = i;
            }
            this.language.add(((Language)languages.get(i)).getName());
            ++i;
        }
        this.language.select(selectionIndex);
    }

    private void addButtons(Composite parent, int horizSpan) {
        Group group = new Group(parent, 2048);
        group.setLayoutData((Object)new GridData(1, 1, true, true, horizSpan, 1));
        group.setLayout((Layout)new GridLayout(2, false));
        group.setText("Scope");
        this.name = new Button((Composite)group, 32);
        this.name.setText("Names");
        this.description = new Button((Composite)group, 32);
        this.description.setText("Descriptions");
        this.example = new Button((Composite)group, 32);
        this.example.setText("Examples");
        this.xpath = new Button((Composite)group, 32);
        this.xpath.setText("XPaths");
    }

    public void createControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayoutData((Object)new GridData(768, 1040, true, true, 2, 1));
        panel.setLayout((Layout)new GridLayout(3, false));
        Composite textPanel = new Composite(panel, 0);
        textPanel.setLayoutData((Object)new GridData(768, 1, true, true, 3, 1));
        textPanel.setLayout((Layout)new GridLayout(4, false));
        Label label = new Label(textPanel, 2048);
        label.setText("Containing text:");
        label.setLayoutData((Object)new GridData(1, 1, false, false, 4, 1));
        this.idText = new Text(textPanel, 2048);
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 3;
        this.idText.setLayoutData((Object)gridData2);
        if (this.selected != null) {
            this.idText.setText(this.selected);
            this.idText.setSelection(0, this.selected.length());
        }
        this.caseSensitive = new Button(textPanel, 32);
        this.caseSensitive.setText("Case sensitive");
        this.caseSensitive.setLayoutData((Object)new GridData(3, 1, false, false, 1, 1));
        this.setControl((Control)panel);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.idText.setFocus();
    }
}

