/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.cmd;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import name.herlin.command.CommandException;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.builder.MarkerUtil;
import net.sourceforge.pmd.eclipse.runtime.cmd.AbstractProjectCommand;
import net.sourceforge.pmd.eclipse.runtime.cmd.FakeRuleViolation;
import net.sourceforge.pmd.eclipse.util.IOUtil;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.util.StringUtil;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class RenderReportsCmd
extends AbstractProjectCommand {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(RenderReportsCmd.class);
    private Map<String, Renderer> renderers = new HashMap<String, Renderer>();

    public RenderReportsCmd() {
        super("RenderReport", "Produce reports for a project");
        this.setOutputProperties(false);
        this.setReadOnly(false);
        this.setTerminated(false);
    }

    public void registerRenderer(Renderer renderer, String reportFile) {
        if (reportFile != null && renderer != null) {
            this.renderers.put(reportFile, renderer);
        }
    }

    private void render(Report report, IFolder folder, String reportName, Renderer renderer) throws IOException, CoreException {
        StringWriter writer = new StringWriter();
        String reportString = null;
        try {
            renderer.setWriter((Writer)writer);
            renderer.start();
            renderer.renderFileReport(report);
            renderer.end();
            reportString = writer.toString();
        }
        finally {
            IOUtil.closeQuietly(writer);
        }
        if (StringUtil.isEmpty((String)reportString)) {
            log.debug((Object)("Missing content for report: " + reportName));
            return;
        }
        log.debug((Object)"   Creating the report file");
        IFile reportFile = folder.getFile(reportName);
        ByteArrayInputStream contentsStream = new ByteArrayInputStream(reportString.getBytes());
        if (reportFile.exists()) {
            reportFile.setContents((InputStream)contentsStream, true, false, this.getMonitor());
        } else {
            reportFile.create((InputStream)contentsStream, true, this.getMonitor());
        }
        reportFile.refreshLocal(2, this.getMonitor());
        ((InputStream)contentsStream).close();
    }

    @Override
    public void execute() throws CommandException {
        try {
            try {
                log.debug((Object)"Starting RenderReport command");
                log.debug((Object)"   Create a report object");
                Report report = this.createReport(this.project());
                log.debug((Object)"   Getting the report folder");
                IFolder folder = this.getProjectFolder("reports");
                if (!folder.exists()) {
                    folder.create(true, true, this.getMonitor());
                }
                for (Map.Entry<String, Renderer> entry : this.renderers.entrySet()) {
                    String reportName = entry.getKey();
                    Renderer renderer = entry.getValue();
                    log.debug((Object)"   Render the report");
                    this.render(report, folder, reportName, renderer);
                }
            }
            catch (CoreException e) {
                log.debug((Object)("Core Exception: " + e.getMessage()), (Throwable)e);
                throw new CommandException(e);
            }
            catch (IOException e) {
                log.debug((Object)("Core Exception: " + e.getMessage()), (Throwable)e);
                throw new CommandException(e);
            }
        }
        finally {
            log.debug((Object)"End of RenderReport command");
            this.setTerminated(true);
        }
    }

    @Override
    public void reset() {
        this.setProject(null);
        this.renderers = new HashMap<String, Renderer>();
        this.setTerminated(false);
    }

    @Override
    public boolean isReadyToExecute() {
        return super.isReadyToExecute() && !this.renderers.isEmpty();
    }

    private static void classAndPackageFrom(IMarker marker, FakeRuleViolation violation) throws JavaModelException {
        ICompilationUnit unit = JavaCore.createCompilationUnitFrom((IFile)((IFile)marker.getResource()));
        IPackageDeclaration[] packages = unit.getPackageDeclarations();
        violation.setPackageName(packages.length > 0 ? packages[0].getElementName() : "(default)");
        IType[] types = unit.getAllTypes();
        violation.setClassName(types.length > 0 ? types[0].getElementName() : marker.getResource().getName());
    }

    private Report createReport(IProject project) throws CoreException {
        Report report = new Report();
        IMarker[] markers = MarkerUtil.findAllMarkers((IResource)project);
        RuleSet ruleSet = PMDPlugin.getDefault().getPreferencesManager().getRuleSet();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            String ruleName = marker.getAttribute("rulename", "");
            Rule rule = ruleSet.getRuleByName(ruleName);
            FakeRuleViolation ruleViolation = RenderReportsCmd.createViolation(marker, rule);
            if (marker.getResource() instanceof IFile) {
                RenderReportsCmd.classAndPackageFrom(marker, ruleViolation);
            }
            report.addRuleViolation((RuleViolation)ruleViolation);
            ++n2;
        }
        return report;
    }

    private static FakeRuleViolation createViolation(IMarker marker, Rule rule) {
        FakeRuleViolation ruleViolation = new FakeRuleViolation(rule);
        ruleViolation.setBeginLine(marker.getAttribute("lineNumber", 0));
        ruleViolation.setEndLine(marker.getAttribute("line2", 0));
        ruleViolation.setVariableName(marker.getAttribute("line2", ""));
        ruleViolation.setFilename(marker.getResource().getProjectRelativePath().toString());
        ruleViolation.setDescription(marker.getAttribute("message", rule.getMessage()));
        return ruleViolation;
    }
}

