/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.cmd;

import java.io.File;
import java.util.List;
import net.sourceforge.pmd.cpd.Language;
import net.sourceforge.pmd.eclipse.runtime.properties.PropertiesException;
import net.sourceforge.pmd.util.StringUtil;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.ResourceWorkingSetFilter;

public class CPDVisitor
implements IResourceVisitor {
    private static final Logger log = Logger.getLogger(CPDVisitor.class);
    private boolean includeDerivedFiles;
    private ResourceWorkingSetFilter workingSetFilter;
    private Language language;
    private List<File> files;

    public void setIncludeDerivedFiles(boolean includeDerivedFiles) {
        this.includeDerivedFiles = includeDerivedFiles;
    }

    public void setWorkingSet(IWorkingSet workingSet) {
        this.workingSetFilter = new ResourceWorkingSetFilter();
        this.workingSetFilter.setWorkingSet(workingSet);
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public List<File> getFiles() {
        return this.files;
    }

    public void setFiles(List<File> files) {
        this.files = files;
    }

    public boolean visit(IResource resource) throws CoreException {
        log.debug((Object)("CPD Visiting " + resource.getName()));
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            File ioFile = file.getLocation().toFile();
            try {
                if (StringUtil.isNotEmpty((String)file.getFileExtension()) && this.language.getFileFilter().accept(ioFile, file.getName()) && this.isFileInWorkingSet(file) && (this.includeDerivedFiles || !file.isDerived())) {
                    log.debug((Object)("Add file " + resource.getName()));
                    this.files.add(ioFile);
                    return false;
                }
            }
            catch (PropertiesException e) {
                log.warn((Object)("ModelException when adding file " + resource.getName() + " to CPD. Continuing."), (Throwable)e);
            }
        }
        return true;
    }

    private boolean isFileInWorkingSet(IFile file) throws PropertiesException {
        boolean fileInWorkingSet = true;
        if (this.workingSetFilter != null) {
            fileInWorkingSet = this.workingSetFilter.select(null, null, (Object)file);
        }
        return fileInWorkingSet;
    }
}

