/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.core.ext;

import net.sourceforge.pmd.eclipse.core.IRuleSetManager;
import net.sourceforge.pmd.eclipse.core.IRuleSetsExtension;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class RuleSetsExtensionProcessor {
    private static final String EXTENTION_POINT = "net.sourceforge.pmd.eclipse.plugin.rulesets";
    private static final String CLASS_ATTRIBUTE = "class";
    private final IRuleSetManager ruleSetManager;

    public RuleSetsExtensionProcessor(IRuleSetManager ruleSetManager) {
        this.ruleSetManager = ruleSetManager;
    }

    public void process() throws CoreException {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENTION_POINT);
        IConfigurationElement[] iConfigurationElementArray = extensionPoint.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            this.processExecutableExtension(element);
            ++n2;
        }
    }

    private void processExecutableExtension(IConfigurationElement element) throws CoreException {
        Object object = element.createExecutableExtension(CLASS_ATTRIBUTE);
        if (object instanceof IRuleSetsExtension) {
            IRuleSetsExtension extension = (IRuleSetsExtension)object;
            extension.registerRuleSets(this.ruleSetManager.getRegisteredRuleSets());
            extension.registerDefaultRuleSets(this.ruleSetManager.getDefaultRuleSets());
        } else {
            PMDPlugin.getDefault().log(4, "Extension " + element.getName() + " is not an instance of IRuleSetsExtension", null);
        }
    }
}

