/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.simpleImpl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.contribution.visualiser.interfaces.IGroup;
import org.eclipse.contribution.visualiser.interfaces.IMember;
import org.eclipse.contribution.visualiser.text.VisualiserMessages;

public class SimpleGroup
implements IGroup {
    protected String name;
    protected String tooltip;
    protected List kids = new ArrayList();

    public SimpleGroup(String n) {
        this.name = n;
    }

    @Override
    public String getFullname() {
        return this.name;
    }

    @Override
    public void add(IMember m) {
        this.kids.add(m);
        m.setContainingGroup(this);
    }

    @Override
    public List getMembers() {
        return this.kids;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setTooltip(String string) {
        this.tooltip = string;
    }

    @Override
    public String getToolTip() {
        if (this.tooltip != null) {
            return this.tooltip;
        }
        return this.name;
    }

    @Override
    public void setSize(int size) {
    }

    @Override
    public Integer getSize() {
        int s = 0;
        for (IMember im : this.kids) {
            s += im.getSize().intValue();
        }
        return new Integer(s);
    }

    @Override
    public IGroup getContainingGroup() {
        return null;
    }

    @Override
    public void setContainingGroup(IGroup grp) {
    }

    public String toString() {
        return String.valueOf(VisualiserMessages.SimpleGroup) + ":[" + this.name + "] " + VisualiserMessages.Size + ":[" + this.getSize() + "]  " + VisualiserMessages.Children + ":[" + this.kids.size() + "]";
    }
}

