/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.aspectj.ajdt.internal.compiler.AbstractCompilerAdapter;
import org.aspectj.ajdt.internal.compiler.CommonPrinter;
import org.aspectj.ajdt.internal.compiler.IBinarySourceProvider;
import org.aspectj.ajdt.internal.compiler.IIntermediateResultsRequestor;
import org.aspectj.ajdt.internal.compiler.IOutputClassFileNameProvider;
import org.aspectj.ajdt.internal.compiler.ITDConstructorPrinter;
import org.aspectj.ajdt.internal.compiler.ITDFieldPrinter;
import org.aspectj.ajdt.internal.compiler.ITDMethodPrinter;
import org.aspectj.ajdt.internal.compiler.InterimCompilationResult;
import org.aspectj.ajdt.internal.compiler.WeaverAdapter;
import org.aspectj.ajdt.internal.compiler.WeaverMessageHandler;
import org.aspectj.ajdt.internal.compiler.ast.AddAtAspectJAnnotationsVisitor;
import org.aspectj.ajdt.internal.compiler.ast.AspectDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.InterTypeConstructorDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.InterTypeFieldDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.InterTypeMethodDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.ValidateAtAspectJAnnotationsVisitor;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.core.builder.AjState;
import org.aspectj.asm.internal.CharOperation;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.IProgressListener;
import org.aspectj.bridge.context.CompilationAndWeavingContext;
import org.aspectj.bridge.context.ContextToken;
import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.Compiler;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.aspectj.weaver.IClassFileProvider;
import org.aspectj.weaver.bcel.BcelWeaver;
import org.aspectj.weaver.bcel.BcelWorld;
import org.aspectj.weaver.bcel.UnwovenClassFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjPipeliningCompilerAdapter
extends AbstractCompilerAdapter {
    private Compiler compiler;
    private BcelWeaver weaver;
    private EclipseFactory eWorld;
    private boolean isBatchCompile;
    private boolean reportedErrors;
    private boolean isXTerminateAfterCompilation;
    private boolean proceedOnError;
    private boolean inJava5Mode;
    private boolean makeReflectable;
    private boolean noAtAspectJAnnotationProcessing;
    private IIntermediateResultsRequestor intermediateResultsRequestor;
    private IProgressListener progressListener;
    private IOutputClassFileNameProvider outputFileNameProvider;
    private IBinarySourceProvider binarySourceProvider;
    private WeaverMessageHandler weaverMessageHandler;
    private Map<String, List<UnwovenClassFile>> binarySourceSetForFullWeave = new HashMap<String, List<UnwovenClassFile>>();
    private ContextToken processingToken = null;
    private ContextToken resolvingToken = null;
    private ContextToken analysingToken = null;
    private ContextToken generatingToken = null;
    private AjState incrementalCompilationState;
    List<InterimCompilationResult> resultsPendingWeave = new ArrayList<InterimCompilationResult>();
    private boolean pipelineStalled = true;
    private boolean weaverInitialized = false;
    private int toWaitFor;
    private boolean droppingBackToFullBuild;
    private static final char[] aspectSig = "Lorg/aspectj/lang/annotation/Aspect;".toCharArray();
    public static boolean pipelineTesting = false;
    public static Hashtable<String, String> pipelineOutput = null;
    private static final boolean debugPipeline = false;

    public AjPipeliningCompilerAdapter(Compiler compiler, boolean isBatchCompile, BcelWorld world, BcelWeaver weaver, EclipseFactory eFactory, IIntermediateResultsRequestor intRequestor, IProgressListener progressListener, IOutputClassFileNameProvider outputFileNameProvider, IBinarySourceProvider binarySourceProvider, Map fullBinarySourceEntries, boolean isXterminateAfterCompilation, boolean proceedOnError, boolean noAtAspectJProcessing, boolean makeReflectable, AjState incrementalCompilationState) {
        IMessageHandler msgHandler;
        this.compiler = compiler;
        this.isBatchCompile = isBatchCompile;
        this.weaver = weaver;
        this.intermediateResultsRequestor = intRequestor;
        this.progressListener = progressListener;
        this.outputFileNameProvider = outputFileNameProvider;
        this.binarySourceProvider = binarySourceProvider;
        this.isXTerminateAfterCompilation = isXterminateAfterCompilation;
        this.proceedOnError = proceedOnError;
        this.binarySourceSetForFullWeave = fullBinarySourceEntries;
        this.eWorld = eFactory;
        this.inJava5Mode = false;
        this.makeReflectable = makeReflectable;
        this.noAtAspectJAnnotationProcessing = noAtAspectJProcessing;
        this.incrementalCompilationState = incrementalCompilationState;
        if (compiler.options.complianceLevel >= 0x310000L) {
            this.inJava5Mode = true;
        }
        if ((msgHandler = world.getMessageHandler()) instanceof WeaverMessageHandler) {
            ((WeaverMessageHandler)msgHandler).resetCompiler(compiler);
            this.weaverMessageHandler = (WeaverMessageHandler)msgHandler;
        } else {
            this.weaverMessageHandler = new WeaverMessageHandler(msgHandler, compiler);
            world.setMessageHandler((IMessageHandler)this.weaverMessageHandler);
        }
    }

    @Override
    public void afterDietParsing(CompilationUnitDeclaration[] units) {
        if (!this.reportedErrors && units != null) {
            for (int i = 0; i < units.length; ++i) {
                if (units[i] == null || units[i].compilationResult == null || !units[i].compilationResult.hasErrors()) continue;
                this.reportedErrors = true;
                break;
            }
        }
        ArrayList<CompilationUnitDeclaration> aspects = new ArrayList<CompilationUnitDeclaration>();
        ArrayList<CompilationUnitDeclaration> nonaspects = new ArrayList<CompilationUnitDeclaration>();
        for (int i = 0; i < units.length; ++i) {
            if (this.containsAnAspect(units[i])) {
                aspects.add(units[i]);
                continue;
            }
            nonaspects.add(units[i]);
        }
        int posn = 0;
        for (CompilationUnitDeclaration aspect : aspects) {
            units[posn++] = aspect;
        }
        for (CompilationUnitDeclaration nonaspect : nonaspects) {
            units[posn++] = nonaspect;
        }
        this.toWaitFor = aspects.size();
        if (pipelineTesting) {
            if (pipelineOutput == null) {
                pipelineOutput = new Hashtable();
            }
            pipelineOutput.put("filesContainingAspects", new Integer(this.toWaitFor).toString());
            StringBuffer order = new StringBuffer();
            order.append("[");
            for (int i = 0; i < units.length; ++i) {
                CompilationUnitDeclaration declaration;
                String filename;
                int idx;
                if (i != 0) {
                    order.append(",");
                }
                if ((idx = (filename = new String((declaration = units[i]).getFileName())).lastIndexOf(47)) > 0) {
                    filename = filename.substring(idx + 1);
                }
                if ((idx = filename.lastIndexOf(92)) > 0) {
                    filename = filename.substring(idx + 1);
                }
                order.append(filename);
            }
            order.append("]");
            pipelineOutput.put("weaveOrder", order.toString());
        }
    }

    @Override
    public void beforeCompiling(ICompilationUnit[] sourceUnits) {
        this.resultsPendingWeave = new ArrayList<InterimCompilationResult>();
        this.reportedErrors = false;
        this.droppingBackToFullBuild = false;
    }

    @Override
    public void beforeProcessing(CompilationUnitDeclaration unit) {
        this.eWorld.showMessage(IMessage.INFO, "compiling " + new String(unit.getFileName()), null, null);
        this.processingToken = CompilationAndWeavingContext.enteringPhase((int)2, (Object)unit.getFileName());
        if (this.inJava5Mode && !this.noAtAspectJAnnotationProcessing) {
            ContextToken tok = CompilationAndWeavingContext.enteringPhase((int)18, (Object)unit.getFileName());
            AddAtAspectJAnnotationsVisitor atAspectJVisitor = new AddAtAspectJAnnotationsVisitor(unit, this.makeReflectable);
            unit.traverse((ASTVisitor)atAspectJVisitor, unit.scope);
            CompilationAndWeavingContext.leavingPhase((ContextToken)tok);
        }
    }

    @Override
    public void beforeResolving(CompilationUnitDeclaration unit) {
        this.resolvingToken = CompilationAndWeavingContext.enteringPhase((int)3, (Object)unit.getFileName());
    }

    @Override
    public void afterResolving(CompilationUnitDeclaration unit) {
        if (this.resolvingToken != null) {
            CompilationAndWeavingContext.leavingPhase((ContextToken)this.resolvingToken);
        }
    }

    @Override
    public void beforeAnalysing(CompilationUnitDeclaration unit) {
        this.analysingToken = CompilationAndWeavingContext.enteringPhase((int)4, (Object)unit.getFileName());
        if (this.inJava5Mode && !this.noAtAspectJAnnotationProcessing) {
            ValidateAtAspectJAnnotationsVisitor atAspectJVisitor = new ValidateAtAspectJAnnotationsVisitor(unit);
            unit.traverse((ASTVisitor)atAspectJVisitor, unit.scope);
        }
    }

    @Override
    public void afterAnalysing(CompilationUnitDeclaration unit) {
        if (this.analysingToken != null) {
            CompilationAndWeavingContext.leavingPhase((ContextToken)this.analysingToken);
        }
    }

    @Override
    public void beforeGenerating(CompilationUnitDeclaration unit) {
        this.generatingToken = CompilationAndWeavingContext.enteringPhase((int)5, (Object)unit.getFileName());
        if (this.eWorld.pushinCollector != null) {
            if (unit.types != null && unit.types.length > 0) {
                for (int t = 0; t < unit.types.length; ++t) {
                    TypeDeclaration type = unit.types[t];
                    if (type.methods == null) continue;
                    for (int m = 0; m < type.methods.length; ++m) {
                        String s;
                        CommonPrinter printer;
                        AbstractMethodDeclaration md = type.methods[m];
                        if (md instanceof InterTypeMethodDeclaration) {
                            InterTypeMethodDeclaration itmd = (InterTypeMethodDeclaration)md;
                            ITDMethodPrinter printer2 = new ITDMethodPrinter(itmd, md.scope);
                            String s2 = printer2.print();
                            this.eWorld.pushinCollector.recordInterTypeMethodDeclarationCode(md, s2, this.getDeclarationLineNumber(md));
                            continue;
                        }
                        if (md instanceof InterTypeFieldDeclaration) {
                            printer = new ITDFieldPrinter((InterTypeFieldDeclaration)md, md.scope);
                            s = ((ITDFieldPrinter)printer).print();
                            this.eWorld.pushinCollector.recordInterTypeFieldDeclarationCode(md, s, this.getDeclarationLineNumber(md));
                            continue;
                        }
                        if (!(md instanceof InterTypeConstructorDeclaration)) continue;
                        printer = new ITDConstructorPrinter((InterTypeConstructorDeclaration)md, md.scope);
                        s = ((ITDConstructorPrinter)printer).print();
                        this.eWorld.pushinCollector.recordInterTypeConstructorDeclarationCode(md, s, this.getDeclarationLineNumber(md));
                    }
                }
            }
            this.eWorld.pushinCollector.setOutputFileNameProvider(this.outputFileNameProvider);
        }
    }

    private int getDeclarationLineNumber(AbstractMethodDeclaration md) {
        int sourceStart = md.sourceStart;
        int[] separators = md.compilationResult.lineSeparatorPositions;
        int declarationStartLine = 1;
        for (int i = 0; i < separators.length && sourceStart >= separators[i]; ++i) {
            ++declarationStartLine;
        }
        return declarationStartLine;
    }

    @Override
    public void afterGenerating(CompilationUnitDeclaration unit) {
        if (this.generatingToken != null) {
            CompilationAndWeavingContext.leavingPhase((ContextToken)this.generatingToken);
        }
        if (this.eWorld.pushinCollector != null) {
            this.eWorld.pushinCollector.dump(unit);
        }
    }

    @Override
    public void afterCompiling(CompilationUnitDeclaration[] units) {
        this.eWorld.cleanup();
        if (!(this.weaverInitialized || this.isXTerminateAfterCompilation || this.reportedErrors && !this.proceedOnError)) {
            try {
                if (this.weaveQueuedEntries()) {
                    this.droppingBackToFullBuild = true;
                }
            }
            catch (IOException ex) {
                AbortCompilation ac = new AbortCompilation(null, (Throwable)ex);
                throw ac;
            }
        }
        this.postWeave();
        try {
            if (!this.reportedErrors && units != null) {
                for (int i = 0; i < units.length; ++i) {
                    if (units[i] == null || units[i].compilationResult == null || !units[i].compilationResult.hasErrors()) continue;
                    this.reportedErrors = true;
                    break;
                }
            }
            if (this.isXTerminateAfterCompilation || this.reportedErrors && !this.proceedOnError) {
                this.notifyRequestor();
            }
        }
        catch (RuntimeException rEx) {
            if (rEx instanceof AbortCompilation) {
                throw rEx;
            }
            throw new AbortCompilation(true, rEx);
        }
    }

    @Override
    public void afterProcessing(CompilationUnitDeclaration unit, int unitIndex) {
        CompilationAndWeavingContext.leavingPhase((ContextToken)this.processingToken);
        this.eWorld.finishedCompilationUnit(unit);
        InterimCompilationResult intRes = new InterimCompilationResult(unit.compilationResult, this.outputFileNameProvider);
        if (unit.compilationResult.hasErrors()) {
            this.reportedErrors = true;
        }
        if (this.intermediateResultsRequestor != null) {
            this.intermediateResultsRequestor.acceptResult(intRes);
        }
        if (unit.compilationResult.hasErrors() || this.isXTerminateAfterCompilation || this.reportedErrors && !this.proceedOnError) {
            this.acceptResult(unit.compilationResult);
        } else {
            this.queueForWeaving(intRes);
        }
    }

    private void queueForWeaving(InterimCompilationResult intRes) {
        this.resultsPendingWeave.add(intRes);
        if (this.pipelineStalled && this.resultsPendingWeave.size() >= this.toWaitFor) {
            this.pipelineStalled = false;
        }
        if (this.pipelineStalled) {
            return;
        }
        try {
            if (this.weaveQueuedEntries()) {
                this.droppingBackToFullBuild = true;
            }
        }
        catch (IOException ex) {
            AbortCompilation ac = new AbortCompilation(null, (Throwable)ex);
            throw ac;
        }
    }

    @Override
    public void acceptResult(CompilationResult result) {
        this.compiler.requestor.acceptResult(result.tagAsAccepted());
        if (this.compiler.unitsToProcess != null) {
            for (int i = 0; i < this.compiler.unitsToProcess.length; ++i) {
                if (this.compiler.unitsToProcess[i] == null || this.compiler.unitsToProcess[i].compilationResult != result) continue;
                this.compiler.unitsToProcess[i].cleanUp();
                this.compiler.unitsToProcess[i] = null;
            }
        }
    }

    private List<InterimCompilationResult> getBinarySourcesFrom(Map<String, List<UnwovenClassFile>> binarySourceEntries) {
        ArrayList<InterimCompilationResult> ret = new ArrayList<InterimCompilationResult>();
        for (String sourceFileName : binarySourceEntries.keySet()) {
            List<UnwovenClassFile> unwovenClassFiles = binarySourceEntries.get(sourceFileName);
            CompilationResult result = new CompilationResult(sourceFileName.toCharArray(), 0, 0, Integer.MAX_VALUE);
            result.noSourceAvailable();
            InterimCompilationResult binarySource = new InterimCompilationResult(result, unwovenClassFiles);
            ret.add(binarySource);
        }
        return ret;
    }

    private void notifyRequestor() {
        for (InterimCompilationResult iresult : this.resultsPendingWeave) {
            this.compiler.requestor.acceptResult(iresult.result().tagAsAccepted());
        }
    }

    private boolean weaveQueuedEntries() throws IOException {
        for (InterimCompilationResult iresult : this.resultsPendingWeave) {
            for (int i = 0; i < iresult.unwovenClassFiles().length; ++i) {
                this.weaver.addClassFile(iresult.unwovenClassFiles()[i], false);
            }
        }
        this.ensureWeaverInitialized();
        if (this.weaver.needToReweaveWorld() && !this.isBatchCompile) {
            return true;
        }
        this.weaver.weave((IClassFileProvider)new WeaverAdapter(this, this.weaverMessageHandler, this.progressListener));
        this.resultsPendingWeave.clear();
        this.eWorld.minicleanup();
        return false;
    }

    private void ensureWeaverInitialized() {
        if (this.weaverInitialized) {
            return;
        }
        this.weaverInitialized = true;
        this.weaver.setIsBatchWeave(this.isBatchCompile);
        this.weaver.prepareForWeave();
        if (this.weaver.needToReweaveWorld()) {
            if (!this.isBatchCompile) {
                this.incrementalCompilationState.forceBatchBuildNextTimeAround();
                return;
            }
            this.resultsPendingWeave.addAll(this.getBinarySourcesFrom(this.binarySourceSetForFullWeave));
        } else {
            Map binarySourcesToAdd = this.binarySourceProvider.getBinarySourcesForThisWeave();
            this.resultsPendingWeave.addAll(this.getBinarySourcesFrom(binarySourcesToAdd));
        }
    }

    private void postWeave() {
        IMessageHandler imh = this.weaver.getWorld().getMessageHandler();
        if (imh instanceof WeaverMessageHandler) {
            ((WeaverMessageHandler)imh).setCurrentResult(null);
        }
        if (!this.droppingBackToFullBuild) {
            this.weaver.allWeavingComplete();
        }
        this.weaver.tidyUp();
        if (imh instanceof WeaverMessageHandler) {
            ((WeaverMessageHandler)imh).resetCompiler(null);
        }
    }

    private boolean containsAnAspect(CompilationUnitDeclaration cud) {
        TypeDeclaration[] typeDecls = cud.types;
        if (typeDecls != null) {
            for (int i = 0; i < typeDecls.length; ++i) {
                TypeDeclaration declaration = typeDecls[i];
                if (this.isAspect(declaration)) {
                    return true;
                }
                if (declaration.memberTypes == null) continue;
                TypeDeclaration[] memberTypes = declaration.memberTypes;
                for (int j = 0; j < memberTypes.length; ++j) {
                    if (!this.containsAnAspect(memberTypes[j])) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean containsAnAspect(TypeDeclaration tDecl) {
        if (this.isAspect(tDecl)) {
            return true;
        }
        if (tDecl.memberTypes != null) {
            TypeDeclaration[] memberTypes = tDecl.memberTypes;
            for (int j = 0; j < memberTypes.length; ++j) {
                if (!this.containsAnAspect(memberTypes[j])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAspect(TypeDeclaration declaration) {
        if (declaration.staticInitializerScope == null) {
            return false;
        }
        if (declaration instanceof AspectDeclaration) {
            return true;
        }
        if (declaration.annotations != null) {
            for (int index = 0; index < declaration.annotations.length; ++index) {
                TypeDeclaration.resolveAnnotations((BlockScope)declaration.staticInitializerScope, declaration.annotations, (Binding)declaration.binding);
                Annotation a = declaration.annotations[index];
                if (a.resolvedType == null || !CharOperation.equals((char[])a.resolvedType.signature(), (char[])aspectSig)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getPipelineDebugOutput(String key) {
        if (pipelineOutput == null) {
            return "";
        }
        return pipelineOutput.get(key);
    }

    @Override
    public List<InterimCompilationResult> getResultsPendingWeave() {
        return this.resultsPendingWeave;
    }
}

