/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.parts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.springframework.ide.eclipse.webflow.core.model.IActionElement;
import org.springframework.ide.eclipse.webflow.core.model.IDecisionState;
import org.springframework.ide.eclipse.webflow.core.model.IExceptionHandler;
import org.springframework.ide.eclipse.webflow.core.model.IIf;
import org.springframework.ide.eclipse.webflow.core.model.IState;
import org.springframework.ide.eclipse.webflow.ui.graph.figures.CompoundStateFigure;
import org.springframework.ide.eclipse.webflow.ui.graph.parts.AbstractStatePart;
import org.springframework.ide.eclipse.webflow.ui.graph.parts.ChildrenStatePart;
import org.springframework.ide.eclipse.webflow.ui.graph.parts.StateTransitionPart;

public class DecisionStatePart
extends ChildrenStatePart {
    protected void applyChildrenResults(CompoundDirectedGraph graph, Map map) {
        AbstractStatePart part;
        CompoundStateFigure figure = (CompoundStateFigure)this.getFigure();
        int headerY = figure.getHeader().getBounds().getBottom().y + 9;
        int y = 0;
        int x = -1;
        int i = 0;
        while (i < this.getChildren().size()) {
            part = (AbstractStatePart)this.getChildren().get(i);
            if (part.getModel() instanceof IActionElement || part.getModel() instanceof IExceptionHandler) {
                part.applyGraphResults(graph, map);
                Point p = part.getFigure().getBounds().getLocation();
                if (x == -1) {
                    x = p.x;
                }
                p.y = y = headerY + i * 23;
                p.x = x;
                part.getFigure().setLocation(p);
            }
            ++i;
        }
        i = 0;
        while (i < this.getChildren().size()) {
            part = (AbstractStatePart)this.getChildren().get(i);
            if (!(part.getModel() instanceof IActionElement) || part.getModel() instanceof IExceptionHandler) {
                Node n = (Node)map.get(part);
                Dimension dim = part.getFigure().getPreferredSize();
                part.getFigure().setBounds(new Rectangle(n.x, n.y + 5, n.width, dim.height));
            }
            ++i;
        }
        this.applyMaxWidths();
    }

    public void contributeEdgesToGraph(CompoundDirectedGraph graph, Map map) {
        List outgoing = this.getSourceConnections();
        int i = 0;
        while (i < outgoing.size()) {
            StateTransitionPart part = (StateTransitionPart)this.getSourceConnections().get(i);
            part.contributeToGraph(graph, map);
            ++i;
        }
        Iterator iter = ((IDecisionState)this.getModel()).getIfs().iterator();
        int j = 0;
        while (iter.hasNext()) {
            IIf theIf = (IIf)iter.next();
            if (theIf.getThenTransition() != null && theIf.getThenTransition().getToState() != null) {
                Edge e1 = new Edge((Node)map.get(this), this.getNode(theIf.getThenTransition().getToState(), map));
                graph.edges.add((Object)e1);
                map.put(String.valueOf(this.toString()) + j++, e1);
            }
            if (theIf.getElseTransition() == null || theIf.getElseTransition().getToState() == null) continue;
            Edge e2 = new Edge((Node)map.get(this), this.getNode(theIf.getElseTransition().getToState(), map));
            graph.edges.add((Object)e2);
            map.put(String.valueOf(this.toString()) + j++, e2);
        }
        int i2 = 0;
        while (i2 < this.getChildren().size()) {
            AbstractStatePart child = (AbstractStatePart)this.children.get(i2);
            if (child.getModel() instanceof IActionElement || child.getModel() instanceof IExceptionHandler) {
                if (i2 + 1 < this.children.size()) {
                    Edge e = new Edge((Node)map.get(child), (Node)map.get(this.getChildren().get(i2 + 1)));
                    e.weight = 1;
                    graph.edges.add((Object)e);
                    map.put(String.valueOf(this.toString()) + i2, e);
                }
            } else {
                child.contributeEdgesToGraph(graph, map);
            }
            ++i2;
        }
    }

    protected void onGetModelChildren(List children) {
        if (this.getModel() instanceof IDecisionState) {
            children.addAll(((IDecisionState)this.getState()).getIfs());
        }
    }

    private Node getNode(Object model, Map map) {
        Node node = null;
        for (Object obj : map.values()) {
            if (!(obj instanceof Node)) continue;
            Node tempNode = (Node)obj;
            if (!model.equals(((AbstractStatePart)tempNode.data).getModel())) continue;
            node = tempNode;
            break;
        }
        return node;
    }

    protected List getModelChildren() {
        ArrayList children = new ArrayList();
        if (this.getModel() instanceof IState) {
            if (this.getState().getEntryActions() != null) {
                children.addAll(this.getState().getEntryActions().getEntryActions());
            }
            if (this.getState().getExitActions() != null) {
                children.addAll(this.getState().getExitActions().getExitActions());
            }
            if (this.getState().getExceptionHandlers() != null) {
                children.addAll(this.getState().getExceptionHandlers());
            }
            this.onGetModelChildren(children);
        }
        return children;
    }
}

