/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.parts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.Subgraph;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertySource;
import org.springframework.ide.eclipse.webflow.core.model.IState;
import org.springframework.ide.eclipse.webflow.core.model.ITransition;
import org.springframework.ide.eclipse.webflow.core.model.ITransitionableFrom;
import org.springframework.ide.eclipse.webflow.core.model.ITransitionableTo;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.ui.graph.parts.StateTransitionPart;
import org.springframework.ide.eclipse.webflow.ui.graph.policies.StateEditPolicy;
import org.springframework.ide.eclipse.webflow.ui.graph.policies.StateNodeEditPolicy;

public abstract class AbstractStatePart
extends AbstractGraphicalEditPart
implements PropertyChangeListener,
NodeEditPart {
    private ConnectionAnchor connectionAnchor;
    protected DirectEditManager manager;

    public void activate() {
        super.activate();
        ((IWebflowModelElement)this.getModel()).addPropertyChangeListener((PropertyChangeListener)this);
    }

    protected void applyGraphResults(CompoundDirectedGraph graph, Map map) {
        Node n = (Node)map.get(this);
        this.getFigure().setBounds(new Rectangle(n.x, n.y, this.getFigure().getPreferredSize().width, this.getFigure().getPreferredSize().height));
        int i = 0;
        while (i < this.getSourceConnections().size()) {
            StateTransitionPart trans = (StateTransitionPart)this.getSourceConnections().get(i);
            trans.applyGraphResults(graph, map);
            ++i;
        }
    }

    public void contributeEdgesToGraph(CompoundDirectedGraph graph, Map map) {
        List outgoing = this.getSourceConnections();
        int i = 0;
        while (i < outgoing.size()) {
            StateTransitionPart part = (StateTransitionPart)this.getSourceConnections().get(i);
            part.contributeToGraph(graph, map);
            ++i;
        }
        i = 0;
        while (i < this.getChildren().size()) {
            AbstractStatePart child = (AbstractStatePart)this.children.get(i);
            child.contributeEdgesToGraph(graph, map);
            ++i;
        }
    }

    public abstract void contributeNodesToGraph(CompoundDirectedGraph var1, Subgraph var2, Map var3);

    protected void createEditPolicies() {
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new StateNodeEditPolicy());
        this.installEditPolicy("ContainerEditPolicy", null);
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new StateEditPolicy());
        this.installEditPolicy("DirectEditPolicy", null);
    }

    public void deactivate() {
        super.deactivate();
        ((IWebflowModelElement)this.getModel()).removePropertyChangeListener((PropertyChangeListener)this);
    }

    public Object getAdapter(Class key) {
        if (IPropertySource.class == key && this.getModel() instanceof IAdaptable) {
            return ((IAdaptable)this.getModel()).getAdapter(key);
        }
        return super.getAdapter(key);
    }

    protected List getModelSourceConnections() {
        if (this.getModel() instanceof ITransitionableFrom) {
            List modelTransitions = ((ITransitionableFrom)this.getModel()).getOutputTransitions();
            ArrayList<ITransition> transitions = new ArrayList<ITransition>();
            for (ITransition transition : modelTransitions) {
                if (transition.getToState() == null) continue;
                transitions.add(transition);
            }
            return transitions;
        }
        return Collections.EMPTY_LIST;
    }

    protected List getModelTargetConnections() {
        if (this.getModel() instanceof ITransitionableTo) {
            return ((ITransitionableTo)this.getModel()).getInputTransitions();
        }
        return Collections.EMPTY_LIST;
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        if (this.connectionAnchor == null) {
            this.connectionAnchor = new TopOrBottomAnchor(this.getFigure(), 0);
        }
        return this.connectionAnchor;
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        if (this.connectionAnchor == null) {
            this.connectionAnchor = new TopOrBottomAnchor(this.getFigure(), 0);
        }
        return this.connectionAnchor;
    }

    public IState getState() {
        return (IState)this.getModel();
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        if (this.connectionAnchor == null) {
            this.connectionAnchor = new TopOrBottomAnchor(this.getFigure(), 0);
        }
        return this.connectionAnchor;
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        if (this.connectionAnchor == null) {
            this.connectionAnchor = new TopOrBottomAnchor(this.getFigure(), 0);
        }
        return this.connectionAnchor;
    }

    protected void performDirectEdit() {
    }

    public void performRequest(Request request) {
        IEditorPart editor;
        ActionRegistry actionRegistry;
        IAction action;
        if (request.getType() == "direct edit") {
            this.performDirectEdit();
        } else if (request.getType().equals("open") && (action = (actionRegistry = (ActionRegistry)(editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()).getAdapter(ActionRegistry.class)).getAction((Object)"Edit_propeties")) != null && action.isEnabled()) {
            action.run();
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("add_children".equals(prop) || "remove_children".equals(prop)) {
            this.refreshChildren();
        } else if ("move_children".equals(prop)) {
            this.refreshChildren();
        } else if ("inputs".equals(prop)) {
            this.refreshTargetConnections();
        } else if ("outputs".equals(prop)) {
            this.refreshSourceConnections();
        } else if ("properties".equals(prop)) {
            this.refreshVisuals();
        }
        ((GraphicalEditPart)this.getViewer().getContents()).getFigure().revalidate();
    }

    protected void setFigure(IFigure figure) {
        figure.getBounds().setSize(0, 0);
        super.setFigure(figure);
    }

    protected List getModelChildren() {
        ArrayList children = new ArrayList();
        if (this.getModel() instanceof IState) {
            if (this.getState().getEntryActions() != null) {
                children.addAll(this.getState().getEntryActions().getEntryActions());
            }
            this.onGetModelChildren(children);
            if (this.getState().getExitActions() != null) {
                children.addAll(this.getState().getExitActions().getExitActions());
            }
            if (this.getState().getExceptionHandlers() != null) {
                children.addAll(this.getState().getExceptionHandlers());
            }
        }
        return children;
    }

    protected void onGetModelChildren(List children) {
    }

    protected static class TopOrBottomAnchor
    extends AbstractConnectionAnchor {
        public static final int SOURCE_ANCHOR = 0;
        public static final int TARGET_ANCHOR = 1;
        private int offset;

        TopOrBottomAnchor(IFigure source, int offset) {
            super(source);
            this.offset = offset;
        }

        public Point getLocation(Point reference) {
            Rectangle r = this.getOwner().getBounds().getCopy();
            this.getOwner().translateToAbsolute((Translatable)r);
            int off = this.offset;
            if (off == -1) {
                off = r.width / 2;
            }
            if (r.contains(reference) || r.y < reference.y) {
                return r.getBottom().translate(off, -1);
            }
            return r.getTop().translate(off, 0);
        }
    }
}

