/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.springframework.ide.eclipse.webflow.core.internal.model.EntryActions;
import org.springframework.ide.eclipse.webflow.core.internal.model.ExitActions;
import org.springframework.ide.eclipse.webflow.core.internal.model.RenderActions;
import org.springframework.ide.eclipse.webflow.core.internal.model.ViewState;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.model.IActionElement;
import org.springframework.ide.eclipse.webflow.core.model.IAttributeEnabled;
import org.springframework.ide.eclipse.webflow.core.model.ICloneableModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IEntryActions;
import org.springframework.ide.eclipse.webflow.core.model.IExceptionHandler;
import org.springframework.ide.eclipse.webflow.core.model.IExitActions;
import org.springframework.ide.eclipse.webflow.core.model.IRenderActions;
import org.springframework.ide.eclipse.webflow.core.model.IViewState;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.ui.editor.outline.webflow.WebflowUIImages;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.ActionComposite;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.ExceptionHandlerComposite;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.IDialogValidator;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.PropertiesComposite;

public class ViewStatePropertiesDialog
extends TitleAreaDialog
implements IDialogValidator {
    private IViewState viewState;
    private IViewState viewStateClone;
    private Label nameLabel;
    private Text nameText;
    private Label viewLabel;
    private Text viewText;
    private Button okButton;
    private IWebflowModelElement parentElement;
    private PropertiesComposite properties;
    private ActionComposite renderActionsComposite;
    private ActionComposite entryActionsComposite;
    private ActionComposite exitActionsComposite;
    private ExceptionHandlerComposite exceptionHandlerComposite;
    private List<IActionElement> entryActions;
    private List<IActionElement> exitActions;
    private List<IActionElement> renderActions;
    private List<IExceptionHandler> exceptionHandler;
    private Label parentLabel;
    private Text parentText;
    private Label redirectLabel;
    private Button redirectText;
    private Label popupLabel;
    private Button popupText;
    private Label modelLabel;
    private Text modelText;

    public ViewStatePropertiesDialog(Shell parentShell, IWebflowModelElement parent, IViewState state) {
        super(parentShell);
        EntryActions entry;
        this.viewState = state;
        this.parentElement = parent;
        this.viewStateClone = ((ViewState)state).cloneModelElement();
        if (this.viewStateClone.getEntryActions() != null) {
            this.entryActions = new ArrayList<IActionElement>();
            this.entryActions.addAll(this.viewStateClone.getEntryActions().getEntryActions());
        } else {
            this.entryActions = new ArrayList<IActionElement>();
            entry = new EntryActions();
            entry.createNew((IWebflowModelElement)this.viewStateClone);
            this.viewStateClone.setEntryActions((IEntryActions)entry);
        }
        if (this.viewStateClone.getExitActions() != null) {
            this.exitActions = new ArrayList<IActionElement>();
            this.exitActions.addAll(this.viewStateClone.getExitActions().getExitActions());
        } else {
            this.exitActions = new ArrayList<IActionElement>();
            ExitActions exit = new ExitActions();
            exit.createNew((IWebflowModelElement)this.viewStateClone);
            this.viewStateClone.setExitActions((IExitActions)exit);
        }
        if (this.viewStateClone.getRenderActions() != null) {
            this.renderActions = new ArrayList<IActionElement>();
            this.renderActions.addAll(this.viewStateClone.getRenderActions().getRenderActions());
        } else {
            this.renderActions = new ArrayList<IActionElement>();
            entry = new RenderActions();
            entry.createNew((IWebflowModelElement)this.viewStateClone);
            this.viewStateClone.setRenderActions((IRenderActions)entry);
        }
        this.exceptionHandler = new ArrayList<IExceptionHandler>();
        if (this.viewStateClone.getExceptionHandlers() != null) {
            this.exceptionHandler.addAll(this.viewStateClone.getExceptionHandlers());
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.viewStateClone.setId(this.trimString(this.nameText.getText()));
            this.viewStateClone.setView(this.trimString(this.viewText.getText()));
            if (!WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.viewState)) {
                this.viewStateClone.setParent(this.trimString(this.parentText.getText()));
                this.viewStateClone.setRedirect(Boolean.toString(this.redirectText.getSelection()));
                this.viewStateClone.setPopup(Boolean.toString(this.popupText.getSelection()));
                this.viewStateClone.setModel(this.trimString(this.modelText.getText()));
            }
            if (this.viewState.getEntryActions() == null && this.entryActions.size() > 0) {
                EntryActions entryActions = new EntryActions();
                entryActions.createNew((IWebflowModelElement)this.viewStateClone);
                for (IActionElement iActionElement : this.entryActions) {
                    entryActions.addEntryAction(iActionElement);
                }
                this.viewStateClone.setEntryActions((IEntryActions)entryActions);
            } else if (this.entryActions.size() == 0) {
                this.viewStateClone.setEntryActions(null);
            } else {
                this.viewStateClone.getEntryActions().removeAll();
                for (IActionElement iActionElement : this.entryActions) {
                    this.viewStateClone.getEntryActions().addEntryAction(iActionElement);
                }
            }
            if (this.viewState.getExitActions() == null && this.exitActions.size() > 0) {
                ExitActions exitActions = new ExitActions();
                exitActions.createNew((IWebflowModelElement)this.viewStateClone);
                for (IActionElement iActionElement : this.exitActions) {
                    exitActions.addExitAction(iActionElement);
                }
                this.viewStateClone.setExitActions((IExitActions)exitActions);
            } else if (this.exitActions.size() == 0) {
                this.viewStateClone.setExitActions(null);
            } else {
                this.viewStateClone.getExitActions().removeAll();
                for (IActionElement iActionElement : this.exitActions) {
                    this.viewStateClone.getExitActions().addExitAction(iActionElement);
                }
            }
            if (this.viewState.getRenderActions() == null && this.renderActions.size() > 0) {
                RenderActions renderActions = new RenderActions();
                renderActions.createNew((IWebflowModelElement)this.viewStateClone);
                for (IActionElement iActionElement : this.renderActions) {
                    renderActions.addRenderAction(iActionElement);
                }
                this.viewStateClone.setRenderActions((IRenderActions)renderActions);
            } else if (this.renderActions.size() == 0) {
                this.viewStateClone.setRenderActions(null);
            } else {
                this.viewStateClone.getRenderActions().removeAll();
                for (IActionElement iActionElement : this.renderActions) {
                    this.viewStateClone.getRenderActions().addRenderAction(iActionElement);
                }
            }
            if (this.exceptionHandler != null && this.exceptionHandler.size() > 0) {
                this.viewStateClone.removeAllExceptionHandler();
                for (IExceptionHandler iExceptionHandler : this.exceptionHandler) {
                    this.viewStateClone.addExceptionHandler(iExceptionHandler);
                }
            } else {
                this.viewStateClone.removeAllExceptionHandler();
            }
            ((ICloneableModelElement)this.viewState).applyCloneValues((IWebflowModelElement)this.viewStateClone);
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getShellTitle());
        shell.setImage(this.getImage());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.nameText.setFocus();
        if (this.viewState != null && this.viewState.getId() != null) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(this.getTitle());
        this.setMessage(this.getMessage());
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        TabFolder folder = new TabFolder(composite, 0);
        TabItem item1 = new TabItem(folder, 0);
        item1.setText("General");
        item1.setImage(this.getImage());
        TabItem item2 = new TabItem(folder, 0);
        TabItem item3 = new TabItem(folder, 0);
        TabItem item4 = new TabItem(folder, 0);
        TabItem item5 = new TabItem(folder, 0);
        TabItem item6 = new TabItem(folder, 0);
        Group groupActionType = new Group((Composite)folder, 0);
        GridLayout layoutAttMap = new GridLayout();
        layoutAttMap.marginWidth = 3;
        layoutAttMap.marginHeight = 3;
        groupActionType.setLayout((Layout)layoutAttMap);
        groupActionType.setText(" View State ");
        GridData grid = new GridData();
        groupActionType.setLayoutData((Object)grid);
        Composite nameGroup = new Composite((Composite)groupActionType, 0);
        nameGroup.setLayoutData((Object)new GridData(768));
        GridLayout layout1 = new GridLayout();
        layout1.numColumns = 2;
        layout1.marginWidth = 5;
        nameGroup.setLayout((Layout)layout1);
        this.nameLabel = new Label(nameGroup, 0);
        this.nameLabel.setText("State id");
        this.nameText = new Text(nameGroup, 2052);
        if (this.viewState != null && this.viewState.getId() != null) {
            this.nameText.setText(this.viewState.getId());
        }
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ViewStatePropertiesDialog.this.validateInput();
            }
        });
        this.viewLabel = new Label(nameGroup, 0);
        this.viewLabel.setText("View");
        this.viewText = new Text(nameGroup, 2052);
        if (this.viewState != null && this.viewState.getView() != null) {
            this.viewText.setText(this.viewState.getView());
        }
        this.viewText.setLayoutData((Object)new GridData(768));
        this.viewText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ViewStatePropertiesDialog.this.validateInput();
            }
        });
        if (!WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.viewState)) {
            this.parentLabel = new Label(nameGroup, 0);
            this.parentLabel.setText("Parent state id");
            this.parentText = new Text(nameGroup, 2052);
            if (this.viewState != null && this.viewState.getParent() != null) {
                this.parentText.setText(this.viewState.getParent());
            }
            this.parentText.setLayoutData((Object)new GridData(768));
            this.parentText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ViewStatePropertiesDialog.this.validateInput();
                }
            });
            this.redirectLabel = new Label(nameGroup, 0);
            this.redirectLabel.setText("Redirect");
            this.redirectText = new Button(nameGroup, 2080);
            if (this.viewState != null && this.viewState.getRedirect() != null && this.viewState.getRedirect().equalsIgnoreCase("true")) {
                this.redirectText.setSelection(true);
            }
            this.redirectText.setLayoutData((Object)new GridData(768));
            this.popupLabel = new Label(nameGroup, 0);
            this.popupLabel.setText("Popup");
            this.popupText = new Button(nameGroup, 2080);
            if (this.viewState != null && this.viewState.getPopup() != null && this.viewState.getPopup().equalsIgnoreCase("true")) {
                this.popupText.setSelection(true);
            }
            this.popupText.setLayoutData((Object)new GridData(768));
            this.modelLabel = new Label(nameGroup, 0);
            this.modelLabel.setText("Model");
            this.modelText = new Text(nameGroup, 2052);
            if (this.viewState != null && this.viewState.getModel() != null) {
                this.modelText.setText(this.viewState.getModel());
            }
            this.modelText.setLayoutData((Object)new GridData(768));
        }
        item1.setControl((Control)groupActionType);
        this.renderActionsComposite = new ActionComposite(this, item2, this.getShell(), this.renderActions, (IWebflowModelElement)this.viewStateClone, IActionElement.ACTION_TYPE.RENDER_ACTION);
        item2.setControl(this.renderActionsComposite.createDialogArea((Composite)folder));
        this.entryActionsComposite = new ActionComposite(this, item3, this.getShell(), this.entryActions, (IWebflowModelElement)this.viewStateClone.getEntryActions(), IActionElement.ACTION_TYPE.ENTRY_ACTION);
        item3.setControl(this.entryActionsComposite.createDialogArea((Composite)folder));
        this.exitActionsComposite = new ActionComposite(this, item4, this.getShell(), this.exitActions, (IWebflowModelElement)this.viewStateClone.getExitActions(), IActionElement.ACTION_TYPE.EXIT_ACTION);
        item4.setControl(this.exitActionsComposite.createDialogArea((Composite)folder));
        this.exceptionHandlerComposite = new ExceptionHandlerComposite(this, item5, this.getShell(), this.exceptionHandler, (IWebflowModelElement)this.viewStateClone);
        item5.setControl(this.exceptionHandlerComposite.createDialogArea((Composite)folder));
        this.properties = new PropertiesComposite(this, item6, this.getShell(), (IAttributeEnabled)this.viewStateClone);
        item6.setControl(this.properties.createDialogArea((Composite)folder));
        ViewStatePropertiesDialog.applyDialogFont((Control)parentComposite);
        return parentComposite;
    }

    public String getId() {
        return this.nameText.getText();
    }

    protected Image getImage() {
        return WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.view_state_obj.gif");
    }

    public String getMessage() {
        return "Enter the details for the view state";
    }

    public IWebflowModelElement getModelElementParent() {
        return this.parentElement;
    }

    protected String getShellTitle() {
        return "View State";
    }

    protected String getTitle() {
        return "View State properties";
    }

    protected void showError(String error) {
        super.setErrorMessage(error);
    }

    public String trimString(String string) {
        if (string != null && string == "") {
            string = null;
        }
        return string;
    }

    public void validateInput() {
        String id = this.nameText.getText();
        boolean error = false;
        StringBuffer errorMessage = new StringBuffer();
        if (id == null || "".equals(id)) {
            errorMessage.append("A valid id attribute is required. ");
            error = true;
        }
        if (error) {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(errorMessage.toString());
        } else {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
        }
    }
}

