/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.springframework.ide.eclipse.webflow.core.internal.model.Set;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.model.IAttributeEnabled;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.ui.editor.outline.webflow.WebflowUIImages;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.IDialogValidator;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.PropertiesComposite;

public class SetActionPropertiesDialog
extends TitleAreaDialog
implements IDialogValidator {
    private Set action;
    private Set actionClone;
    private Label nameLabel;
    private Text nameText;
    private Label valueLabel;
    private Text valueText;
    private Button okButton;
    private PropertiesComposite properties;
    private Combo scopeText;
    private Label scopeLabel;
    private Label attributeLabel;
    private Text attributeText;
    private Label typeLabel;
    private Text typeText;

    public SetActionPropertiesDialog(Shell parentShell, IWebflowModelElement parent, Set state) {
        super(parentShell);
        this.action = state;
        this.actionClone = this.action.cloneModelElement();
    }

    private String trimString(String string) {
        if (string != null && string == "") {
            string = null;
        }
        return string;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            if (WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.action)) {
                this.actionClone.setName(this.trimString(this.nameText.getText()));
                this.actionClone.setScope(this.trimString(this.scopeText.getText()));
            } else {
                this.actionClone.setSetType(this.trimString(this.typeText.getText()));
            }
            this.actionClone.setAttribute(this.trimString(this.attributeText.getText()));
            this.actionClone.setValue(this.trimString(this.valueText.getText()));
            this.action.applyCloneValues(this.actionClone);
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getShellTitle());
        shell.setImage(this.getImage());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        if (this.nameText != null) {
            this.nameText.setFocus();
        }
        if (this.action != null && this.action.getName() != null) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
        this.validateInput();
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(this.getTitle());
        this.setMessage(this.getMessage());
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        TabFolder folder = new TabFolder(composite, 0);
        folder.setLayoutData((Object)new GridData(1808));
        TabItem item1 = new TabItem(folder, 0);
        item1.setText("General");
        item1.setImage(this.getImage());
        TabItem item2 = new TabItem(folder, 0);
        Group groupActionType = new Group((Composite)folder, 0);
        GridLayout layoutAttMap = new GridLayout();
        layoutAttMap.marginWidth = 3;
        layoutAttMap.marginHeight = 3;
        groupActionType.setLayout((Layout)layoutAttMap);
        groupActionType.setText(" Set ");
        GridData grid = new GridData();
        groupActionType.setLayoutData((Object)grid);
        Composite nameGroup = new Composite((Composite)groupActionType, 0);
        nameGroup.setLayoutData((Object)new GridData(768));
        GridLayout layout1 = new GridLayout();
        layout1.numColumns = 2;
        layout1.marginWidth = 5;
        nameGroup.setLayout((Layout)layout1);
        if (WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.action)) {
            this.nameLabel = new Label(nameGroup, 0);
            this.nameLabel.setText("Name");
            this.nameText = new Text(nameGroup, 2052);
            if (this.action != null && this.action.getName() != null) {
                this.nameText.setText(this.action.getName());
            }
            this.nameText.setLayoutData((Object)new GridData(768));
            this.nameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SetActionPropertiesDialog.this.validateInput();
                }
            });
        }
        this.attributeLabel = new Label(nameGroup, 0);
        if (WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.action)) {
            this.attributeLabel.setText("Attribute");
        } else {
            this.attributeLabel.setText("Name");
        }
        this.attributeText = new Text(nameGroup, 2052);
        if (this.action != null && this.action.getAttribute() != null) {
            this.attributeText.setText(this.action.getAttribute());
        }
        this.attributeText.setLayoutData((Object)new GridData(768));
        this.attributeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SetActionPropertiesDialog.this.validateInput();
            }
        });
        this.valueLabel = new Label(nameGroup, 0);
        this.valueLabel.setText("Value");
        this.valueText = new Text(nameGroup, 2052);
        if (this.action != null && this.action.getValue() != null) {
            this.valueText.setText(this.action.getValue());
        }
        this.valueText.setLayoutData((Object)new GridData(768));
        this.valueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SetActionPropertiesDialog.this.validateInput();
            }
        });
        if (WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.action)) {
            this.scopeLabel = new Label(nameGroup, 0);
            this.scopeLabel.setText("Scope");
            this.scopeText = new Combo(nameGroup, 2060);
            this.scopeText.setItems(new String[]{"", "request", "flash", "flow", "conversation", "default"});
            if (this.action != null && this.action.getScope() != null) {
                this.scopeText.setText(this.action.getScope());
            }
            this.scopeText.setLayoutData((Object)new GridData(768));
            this.scopeText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SetActionPropertiesDialog.this.validateInput();
                }
            });
        } else {
            this.typeLabel = new Label(nameGroup, 0);
            this.typeLabel.setText("Type");
            this.typeText = new Text(nameGroup, 2052);
            if (this.action != null && this.action.getSetType() != null) {
                this.typeText.setText(this.action.getSetType());
            }
            this.typeText.setLayoutData((Object)new GridData(768));
            this.typeText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SetActionPropertiesDialog.this.validateInput();
                }
            });
        }
        item1.setControl((Control)groupActionType);
        this.properties = new PropertiesComposite(this, item2, this.getShell(), (IAttributeEnabled)this.actionClone);
        item2.setControl(this.properties.createDialogArea((Composite)folder));
        SetActionPropertiesDialog.applyDialogFont((Control)parentComposite);
        return parentComposite;
    }

    protected Image getImage() {
        return WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.action_obj.gif");
    }

    public String getMessage() {
        return "Enter the details for the Set element";
    }

    public String getName() {
        return this.nameText.getText();
    }

    protected String getShellTitle() {
        return "Set";
    }

    protected String getTitle() {
        return "Set properties";
    }

    protected void showError(String error) {
        super.setErrorMessage(error);
    }

    public void validateInput() {
        boolean error = false;
        StringBuffer errorMessage = new StringBuffer();
        if (error) {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(errorMessage.toString());
        } else {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
        }
    }
}

