/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.springframework.ide.eclipse.webflow.core.model.IImport;
import org.springframework.ide.eclipse.webflow.ui.editor.outline.webflow.WebflowUIImages;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.IDialogValidator;

public class ImportEditorDialog
extends TitleAreaDialog
implements IDialogValidator {
    private IImport property;
    private Label resourceLabel;
    private Text resouceText;
    private Button okButton;

    public ImportEditorDialog(Shell parentShell, IImport state) {
        super(parentShell);
        this.property = state;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.property.setResource(this.trimString(this.resouceText.getText()));
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getShellTitle());
        shell.setImage(this.getImage());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.resouceText.setFocus();
        if (this.property != null && this.property.getResource() != null) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
        this.validateInput();
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(this.getTitle());
        this.setMessage(this.getMessage());
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Composite nameGroup = new Composite(composite, 0);
        nameGroup.setLayoutData((Object)new GridData(768));
        GridLayout layout1 = new GridLayout();
        layout1.numColumns = 3;
        layout1.marginWidth = 5;
        nameGroup.setLayout((Layout)layout1);
        this.resourceLabel = new Label(nameGroup, 0);
        this.resourceLabel.setText("Name");
        this.resouceText = new Text(nameGroup, 2052);
        if (this.property != null && this.property.getResource() != null) {
            this.resouceText.setText(this.property.getResource());
        }
        this.resouceText.setLayoutData((Object)new GridData(768));
        this.resouceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportEditorDialog.this.validateInput();
            }
        });
        new Label(nameGroup, 0);
        ImportEditorDialog.applyDialogFont((Control)parentComposite);
        return parentComposite;
    }

    public String getId() {
        return this.resouceText.getText();
    }

    protected Image getImage() {
        return WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.import_obj.gif");
    }

    public String getMessage() {
        return "Enter the details for the import";
    }

    protected String getShellTitle() {
        return "Import";
    }

    protected String getTitle() {
        return "Import properties";
    }

    protected void showError(String error) {
        super.setErrorMessage(error);
    }

    public String trimString(String string) {
        if (string != null && string == "") {
            string = null;
        }
        return string;
    }

    public void validateInput() {
        String id = this.resouceText.getText();
        boolean error = false;
        StringBuffer errorMessage = new StringBuffer();
        if (id == null || "".equals(id)) {
            errorMessage.append("A valid resource name is required. ");
            error = true;
        }
        if (error) {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(errorMessage.toString());
        } else {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
        }
    }
}

