/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.springframework.ide.eclipse.webflow.core.internal.model.EvaluateAction;
import org.springframework.ide.eclipse.webflow.core.internal.model.EvaluationResult;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.model.IAttributeEnabled;
import org.springframework.ide.eclipse.webflow.core.model.IEvaluationResult;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.ui.editor.outline.webflow.WebflowUIImages;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.IDialogValidator;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.PropertiesComposite;

public class EvaluateActionPropertiesDialog
extends TitleAreaDialog
implements IDialogValidator {
    private EvaluateAction action;
    private EvaluateAction actionClone;
    private Label nameLabel;
    private Text nameText;
    private Label expressionLabel;
    private Text expressionText;
    private Button okButton;
    private int LABEL_WIDTH = 70;
    private IDialogValidator validator;
    private PropertiesComposite properties;
    private Combo scopeText;
    private Label scopeLabel;
    private Label resultNameLabel;
    private Text resultNameText;
    private Label resultLabel;
    private Text resultText;
    private Label resultTypeLabel;
    private Text resultTypeText;

    public EvaluateActionPropertiesDialog(Shell parentShell, IWebflowModelElement parent, EvaluateAction state) {
        super(parentShell);
        this.action = state;
        this.actionClone = this.action.cloneModelElement();
    }

    private String trimString(String string) {
        if (string != null && string == "") {
            string = null;
        }
        return string;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.actionClone.setExpression(this.trimString(this.expressionText.getText()));
            if (WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.action)) {
                this.actionClone.setName(this.trimString(this.nameText.getText()));
                if (this.trimString(this.scopeText.getText()) == null && this.trimString(this.resultNameText.getText()) == null) {
                    this.actionClone.setEvaluationResult(null);
                } else if (this.action.getEvaluationResult() != null) {
                    this.actionClone.getEvaluationResult().setName(this.resultNameText.getText());
                    this.actionClone.getEvaluationResult().setScope(this.scopeText.getText());
                } else if (this.action.getEvaluationResult() == null) {
                    EvaluationResult result = new EvaluationResult();
                    result.createNew((IWebflowModelElement)this.actionClone);
                    this.actionClone.setEvaluationResult((IEvaluationResult)result);
                    this.actionClone.getEvaluationResult().setName(this.resultNameText.getText());
                    this.actionClone.getEvaluationResult().setScope(this.scopeText.getText());
                }
            } else {
                this.actionClone.setResult(this.trimString(this.resultText.getText()));
                this.actionClone.setResultType(this.trimString(this.resultTypeText.getText()));
            }
            this.action.applyCloneValues(this.actionClone);
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getShellTitle());
        shell.setImage(this.getImage());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        if (this.nameText != null) {
            this.nameText.setFocus();
        }
        if (this.action != null && this.action.getName() != null) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
        this.validateInput();
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(this.getTitle());
        this.setMessage(this.getMessage());
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        TabFolder folder = new TabFolder(composite, 0);
        folder.setLayoutData((Object)new GridData(1808));
        TabItem item1 = new TabItem(folder, 0);
        item1.setText("General");
        item1.setImage(this.getImage());
        TabItem item2 = new TabItem(folder, 0);
        Group groupActionType = new Group((Composite)folder, 0);
        GridLayout layoutAttMap = new GridLayout();
        layoutAttMap.marginWidth = 3;
        layoutAttMap.marginHeight = 3;
        groupActionType.setLayout((Layout)layoutAttMap);
        groupActionType.setText(" Evaluate Action ");
        GridData grid = new GridData();
        groupActionType.setLayoutData((Object)grid);
        Composite nameGroup = new Composite((Composite)groupActionType, 0);
        nameGroup.setLayoutData((Object)new GridData(768));
        GridLayout layout1 = new GridLayout();
        layout1.numColumns = 2;
        layout1.marginWidth = 5;
        nameGroup.setLayout((Layout)layout1);
        if (WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.action)) {
            this.nameLabel = new Label(nameGroup, 0);
            this.nameLabel.setText("Name");
            this.nameText = new Text(nameGroup, 2052);
            if (this.action != null && this.action.getName() != null) {
                this.nameText.setText(this.action.getName());
            }
            this.nameText.setLayoutData((Object)new GridData(768));
            this.nameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    EvaluateActionPropertiesDialog.this.validateInput();
                }
            });
        }
        this.expressionLabel = new Label(nameGroup, 0);
        this.expressionLabel.setText("Expression");
        this.expressionText = new Text(nameGroup, 2052);
        if (this.action != null && this.action.getExpression() != null) {
            this.expressionText.setText(this.action.getExpression());
        }
        this.expressionText.setLayoutData((Object)new GridData(768));
        this.expressionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EvaluateActionPropertiesDialog.this.validateInput();
            }
        });
        if (!WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.action)) {
            this.resultLabel = new Label(nameGroup, 0);
            this.resultLabel.setText("Result");
            this.resultText = new Text(nameGroup, 2052);
            if (this.action != null && this.action.getResult() != null) {
                this.resultText.setText(this.action.getResult());
            }
            this.resultText.setLayoutData((Object)new GridData(768));
            this.resultText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    EvaluateActionPropertiesDialog.this.validateInput();
                }
            });
            this.resultTypeLabel = new Label(nameGroup, 0);
            this.resultTypeLabel.setText("Result type");
            this.resultTypeText = new Text(nameGroup, 2052);
            if (this.action != null && this.action.getResultType() != null) {
                this.resultTypeText.setText(this.action.getResultType());
            }
            this.resultTypeText.setLayoutData((Object)new GridData(768));
            this.resultTypeText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    EvaluateActionPropertiesDialog.this.validateInput();
                }
            });
        }
        if (WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.action)) {
            Group groupMethodResult = new Group((Composite)groupActionType, 0);
            layoutAttMap = new GridLayout();
            layoutAttMap.marginWidth = 3;
            layoutAttMap.marginHeight = 3;
            layoutAttMap.numColumns = 3;
            layoutAttMap.marginWidth = 5;
            groupMethodResult.setLayout((Layout)layoutAttMap);
            groupMethodResult.setText(" Evaluation Result ");
            groupMethodResult.setLayoutData((Object)new GridData(768));
            this.resultNameLabel = new Label((Composite)groupMethodResult, 0);
            this.resultNameLabel.setText("Name");
            this.resultNameText = new Text((Composite)groupMethodResult, 2052);
            if (this.action != null && this.action.getEvaluationResult() != null) {
                this.resultNameText.setText(this.action.getEvaluationResult().getName());
            }
            this.resultNameText.setLayoutData((Object)new GridData(768));
            this.resultNameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    EvaluateActionPropertiesDialog.this.validateInput();
                }
            });
            new Label((Composite)groupMethodResult, 0);
            this.scopeLabel = new Label((Composite)groupMethodResult, 0);
            this.scopeLabel.setText("Scope");
            GridData gridData = new GridData(32);
            gridData.widthHint = this.LABEL_WIDTH;
            this.scopeLabel.setLayoutData((Object)gridData);
            this.scopeText = new Combo((Composite)groupMethodResult, 2060);
            this.scopeText.setItems(new String[]{"", "request", "flash", "flow", "conversation", "default"});
            if (this.action != null && this.action.getEvaluationResult() != null) {
                this.scopeText.setText(this.action.getEvaluationResult().getScope());
            }
            this.scopeText.setLayoutData((Object)new GridData(768));
            this.scopeText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    EvaluateActionPropertiesDialog.this.validator.validateInput();
                }
            });
            new Label((Composite)groupMethodResult, 0);
        }
        item1.setControl((Control)groupActionType);
        this.properties = new PropertiesComposite(this, item2, this.getShell(), (IAttributeEnabled)this.actionClone);
        item2.setControl(this.properties.createDialogArea((Composite)folder));
        EvaluateActionPropertiesDialog.applyDialogFont((Control)parentComposite);
        return parentComposite;
    }

    protected Image getImage() {
        return WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.action_obj.gif");
    }

    public String getMessage() {
        return "Enter the details for the Evaluate action";
    }

    public String getName() {
        return this.nameText.getText();
    }

    protected String getShellTitle() {
        return "Evaluate Action";
    }

    protected String getTitle() {
        return "Evaluate Action properties";
    }

    protected void showError(String error) {
        super.setErrorMessage(error);
    }

    public void validateInput() {
        boolean error = false;
        StringBuffer errorMessage = new StringBuffer();
        if (error) {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(errorMessage.toString());
        } else {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
        }
    }
}

