/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.dialogs;

import org.eclipse.jdt.core.IMethod;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.fieldassist.DecoratedField;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IControlCreator;
import org.eclipse.jface.fieldassist.TextControlCreator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.webflow.core.internal.model.Action;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.model.IAttributeEnabled;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.ui.editor.outline.webflow.WebflowUIImages;
import org.springframework.ide.eclipse.webflow.ui.graph.WebflowUtils;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.DialogUtils;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.IDialogValidator;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.PropertiesComposite;

public class ActionPropertiesDialog
extends TitleAreaDialog
implements IDialogValidator {
    private Action action;
    private Action actionClone;
    private Label nameLabel;
    private Text nameText;
    private Label beanLabel;
    private Text beanText;
    private Label methodLabel;
    private Text methodText;
    private Button okButton;
    private int LABEL_WIDTH = 70;
    private IDialogValidator validator;
    private PropertiesComposite properties;
    private Button browseBeanButton;
    private Button browseMethodButton;
    private SelectionListener buttonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            ActionPropertiesDialog.this.handleButtonPressed((Button)e.widget);
        }
    };

    public ActionPropertiesDialog(Shell parentShell, IWebflowModelElement parent, Action state) {
        super(parentShell);
        this.action = state;
        this.actionClone = this.action.cloneModelElement();
    }

    private String trimString(String string) {
        if (string != null && string == "") {
            string = null;
        }
        return string;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.actionClone.setName(this.trimString(this.nameText.getText()));
            if (WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.action)) {
                this.actionClone.setMethod(this.trimString(this.methodText.getText()));
                this.actionClone.setBean(this.trimString(this.beanText.getText()));
            }
            this.action.applyCloneValues(this.actionClone);
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getShellTitle());
        shell.setImage(this.getImage());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.nameText.setFocus();
        if (this.action != null && this.action.getName() != null) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
        this.validateInput();
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(this.getTitle());
        this.setMessage(this.getMessage());
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        TabFolder folder = new TabFolder(composite, 0);
        folder.setLayoutData((Object)new GridData(1808));
        TabItem item1 = new TabItem(folder, 0);
        item1.setText("General");
        item1.setImage(this.getImage());
        TabItem item2 = new TabItem(folder, 0);
        Group groupActionType = new Group((Composite)folder, 0);
        GridLayout layoutAttMap = new GridLayout();
        layoutAttMap.marginWidth = 3;
        layoutAttMap.marginHeight = 3;
        groupActionType.setLayout((Layout)layoutAttMap);
        if (WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.action)) {
            groupActionType.setText(" Action ");
        } else {
            groupActionType.setText(" Render ");
        }
        GridData grid = new GridData();
        groupActionType.setLayoutData((Object)grid);
        Composite nameGroup = new Composite((Composite)groupActionType, 0);
        nameGroup.setLayoutData((Object)new GridData(768));
        GridLayout layout1 = new GridLayout();
        layout1.numColumns = 3;
        layout1.marginWidth = 5;
        nameGroup.setLayout((Layout)layout1);
        this.nameLabel = new Label(nameGroup, 0);
        if (WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.action)) {
            this.nameLabel.setText("Name");
        } else {
            this.nameLabel.setText("Fragments");
        }
        this.nameText = new Text(nameGroup, 2052);
        if (this.action != null && this.action.getName() != null) {
            this.nameText.setText(this.action.getName());
        }
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ActionPropertiesDialog.this.validateInput();
            }
        });
        new Label(nameGroup, 0);
        if (WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.action)) {
            this.beanLabel = new Label(nameGroup, 0);
            this.beanLabel.setText("Bean");
            GridData gridData = new GridData(32);
            gridData.widthHint = this.LABEL_WIDTH;
            this.beanLabel.setLayoutData((Object)gridData);
            DecoratedField beanField = new DecoratedField(nameGroup, 2052, (IControlCreator)new TextControlCreator());
            FieldDecoration requiredFieldIndicator = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
            beanField.addFieldDecoration(requiredFieldIndicator, 16512, true);
            this.beanText = (Text)beanField.getControl();
            GridData data = new GridData(256);
            beanField.getLayoutControl().setLayoutData((Object)data);
            if (this.action != null && this.action.getBean() != null) {
                this.beanText.setText(this.action.getBean());
            }
            this.beanText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (ActionPropertiesDialog.this.validator != null) {
                        ActionPropertiesDialog.this.validator.validateInput();
                    }
                }
            });
            DialogUtils.attachContentAssist(this.beanText, WebflowUtils.getBeansFromEditorInput().toArray());
            this.browseBeanButton = new Button(nameGroup, 8);
            this.browseBeanButton.setText("...");
            this.browseBeanButton.setLayoutData((Object)new GridData(128));
            this.browseBeanButton.addSelectionListener(this.buttonListener);
            this.methodLabel = new Label(nameGroup, 0);
            this.methodLabel.setText("Method");
            DecoratedField methodField = new DecoratedField(nameGroup, 2052, (IControlCreator)new TextControlCreator());
            FieldDecoration requiredFieldIndicator1 = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
            methodField.addFieldDecoration(requiredFieldIndicator1, 16512, true);
            this.methodText = (Text)methodField.getControl();
            data = new GridData(256);
            methodField.getLayoutControl().setLayoutData((Object)data);
            if (this.action != null && this.action.getMethod() != null) {
                this.methodText.setText(this.action.getMethod());
            }
            this.methodText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ActionPropertiesDialog.this.validateInput();
                }
            });
            DialogUtils.attachContentAssist(this.methodText, WebflowUtils.getActionMethods(this.actionClone.getNode()).toArray());
            this.browseMethodButton = new Button(nameGroup, 8);
            this.browseMethodButton.setText("...");
            this.browseMethodButton.setLayoutData((Object)new GridData(128));
            this.browseMethodButton.addSelectionListener(this.buttonListener);
        }
        GridData data = new GridData(768);
        data.horizontalIndent = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
        this.nameText.setLayoutData((Object)data);
        item1.setControl((Control)groupActionType);
        this.properties = new PropertiesComposite(this, item2, this.getShell(), (IAttributeEnabled)this.actionClone);
        item2.setControl(this.properties.createDialogArea((Composite)folder));
        ActionPropertiesDialog.applyDialogFont((Control)parentComposite);
        return parentComposite;
    }

    protected Image getImage() {
        return WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.action_obj.gif");
    }

    public String getMessage() {
        if (WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.action)) {
            return "Enter the details for the action";
        }
        return "Enter the details for the render action";
    }

    public String getName() {
        return this.nameText.getText();
    }

    protected String getShellTitle() {
        if (WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.action)) {
            return "Action";
        }
        return "Render";
    }

    protected String getTitle() {
        if (WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.action)) {
            return "Action properties";
        }
        return "Render properties";
    }

    protected void showError(String error) {
        super.setErrorMessage(error);
    }

    public void validateInput() {
        boolean error = false;
        StringBuffer errorMessage = new StringBuffer();
        if (error) {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(errorMessage.toString());
        } else {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
        }
    }

    private void handleButtonPressed(Button button) {
        ElementListSelectionDialog dialog;
        if (button.equals(this.browseBeanButton)) {
            ElementListSelectionDialog dialog2 = DialogUtils.openBeanReferenceDialog(this.beanText.getText(), false);
            if (dialog2.open() == 0) {
                this.beanText.setText(((IBean)dialog2.getFirstResult()).getElementName());
            }
        } else if (button.equals(this.browseMethodButton) && (dialog = DialogUtils.openActionMethodReferenceDialog(this.actionClone.getNode())).open() == 0) {
            this.methodText.setText(((IMethod)dialog.getFirstResult()).getElementName());
        }
    }
}

