/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.commands;

import org.eclipse.gef.commands.Command;
import org.springframework.ide.eclipse.webflow.core.model.IIf;
import org.springframework.ide.eclipse.webflow.core.model.IIfTransition;
import org.springframework.ide.eclipse.webflow.core.model.ITransition;
import org.springframework.ide.eclipse.webflow.core.model.ITransitionableTo;

public class ReconnectIfTransitionSourceCommand
extends Command {
    protected IIf oldSource;
    protected IIf source;
    protected ITransitionableTo target;
    protected IIfTransition transition;

    public boolean canExecute() {
        return !this.transition.getToState().equals(this.source) && this.source instanceof IIf;
    }

    public void execute() {
        if (this.source != null) {
            if (this.transition.isThen()) {
                this.oldSource.removeThenTransition();
            } else {
                this.oldSource.removeElseTransition();
            }
            this.transition.setFromIf(this.source);
            if (this.transition.isThen()) {
                this.source.setThenTransition(this.transition);
            } else {
                this.source.setElseTransition(this.transition);
            }
        }
    }

    public IIf getSource() {
        return this.source;
    }

    public ITransitionableTo getTarget() {
        return this.target;
    }

    public ITransition getTransition() {
        return this.transition;
    }

    public void setSource(IIf activity) {
        this.source = activity;
    }

    public void setTarget(ITransitionableTo activity) {
        this.target = activity;
    }

    public void setTransition(IIfTransition trans) {
        this.transition = trans;
        this.target = trans.getToState();
        this.oldSource = trans.getFromIf();
    }

    public void undo() {
        if (this.source != null) {
            if (this.transition.isThen()) {
                this.source.removeThenTransition();
            } else {
                this.source.removeElseTransition();
            }
            this.transition.setFromIf(this.oldSource);
            if (this.transition.isThen()) {
                this.oldSource.setThenTransition(this.transition);
            } else {
                this.oldSource.setElseTransition(this.transition);
            }
        }
    }
}

