/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.commands;

import org.eclipse.gef.commands.Command;
import org.springframework.ide.eclipse.webflow.core.model.IState;
import org.springframework.ide.eclipse.webflow.core.model.ITransition;
import org.springframework.ide.eclipse.webflow.core.model.ITransitionableFrom;
import org.springframework.ide.eclipse.webflow.core.model.ITransitionableTo;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;

public class AddAndAssignSourceCommand
extends Command {
    private IWebflowState parent;
    private ITransitionableTo child;
    private ITransitionableFrom source;
    private ITransition transition;

    public boolean canExecute() {
        int i = 0;
        while (i < this.source.getOutputTransitions().size()) {
            ITransitionableTo target = ((ITransition)this.source.getOutputTransitions().get(i)).getToState();
            if (target.equals(this.child)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void execute() {
        this.parent.addState((IState)this.child);
    }

    public void redo() {
        this.source.addOutputTransition(this.transition);
        this.child.addInputTransition(this.transition);
        this.parent.addState((IState)this.child);
    }

    public void setParent(IWebflowState sa) {
        this.parent = sa;
    }

    public void setChild(ITransitionableTo activity) {
        this.child = activity;
    }

    public void setSource(ITransitionableFrom activity) {
        this.source = activity;
    }

    public void undo() {
        this.source.removeOutputTransition(this.transition);
        this.child.removeInputTransition(this.transition);
        this.parent.removeState((IState)this.child);
    }
}

