/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.core.preferences;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.springsource.ide.eclipse.commons.core.HttpUtil;
import org.springsource.ide.eclipse.commons.internal.core.CorePlugin;
import org.springsource.ide.eclipse.commons.internal.core.net.HttpClientTransportService;

public class StsProperties {
    private static final String EXTENSION_ID = "org.springsource.ide.commons.core.properties";
    private static final String PROPERTIES_URL_PROPERTY = "sts.properties.url";
    private static StsProperties instance = null;
    private final Properties props = this.createProperties();
    private static Boolean isHangingBug = null;

    private FromUrl[] readExtensionPoints() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        ArrayList<FromUrl> sources = new ArrayList<FromUrl>();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                String name = element.getName();
                if ("fromUrl".equals(name)) {
                    sources.add(new FromUrl(element));
                }
                ++n4;
            }
            ++n2;
        }
        FromUrl[] sourcesArray = sources.toArray(new FromUrl[sources.size()]);
        Arrays.sort(sourcesArray, new AscendingPriority());
        return sourcesArray;
    }

    public static StsProperties getInstance(IProgressMonitor mon) {
        if (instance == null) {
            StsProperties newInstance;
            instance = newInstance = new StsProperties(mon);
        }
        return instance;
    }

    private StsProperties(IProgressMonitor mon) {
        FromUrl[] sources = this.readExtensionPoints();
        mon.beginTask("Read Sts Properties", sources.length + 1);
        try {
            FromUrl[] fromUrlArray = sources;
            int n = sources.length;
            int n2 = 0;
            while (n2 < n) {
                FromUrl source = fromUrlArray[n2];
                this.readProperties(source.url, (IProgressMonitor)new SubProgressMonitor(mon, 1));
                ++n2;
            }
            String url = System.getProperty(PROPERTIES_URL_PROPERTY);
            if (url != null) {
                this.readProperties(url, (IProgressMonitor)new SubProgressMonitor(mon, 1));
            }
        }
        finally {
            mon.done();
        }
    }

    private boolean isHangingBug() {
        block6: {
            if (isHangingBug == null) {
                boolean affected = false;
                try {
                    try {
                        Bundle platformBundle = Platform.getBundle((String)"org.eclipse.platform");
                        Version version = platformBundle.getVersion();
                        affected = version.getMajor() == 3;
                    }
                    catch (Throwable e) {
                        CorePlugin.log(e);
                        isHangingBug = affected;
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    isHangingBug = affected;
                    throw throwable;
                }
                isHangingBug = affected;
            }
        }
        return isHangingBug;
    }

    private void readProperties(String url, IProgressMonitor mon) {
        block6: {
            if (url != null) {
                try {
                    InputStream content = this.uriStream(new URI(url), mon);
                    if (content == null) break block6;
                    try {
                        this.props.load(content);
                    }
                    finally {
                        content.close();
                    }
                }
                catch (Throwable e) {
                    CorePlugin.log(e);
                    CorePlugin.warn("Couldn't read sts properties from '" + url + "' internal default values will be used");
                }
            }
        }
    }

    private InputStream uriStream(URI uri, IProgressMonitor mon) throws CoreException, MalformedURLException, IOException {
        if (this.isHangingBug()) {
            return new HttpClientTransportService().stream(uri, mon);
        }
        return HttpUtil.stream(uri, mon);
    }

    protected Properties createProperties() {
        Properties props = new Properties();
        props.put("spring.site.url", "http://spring.io");
        props.put("spring.initializr.form.url", "http://start.spring.io/");
        props.put("spring.initializr.download.url", "http://start.spring.io/starter.zip");
        props.put("sts.new.dashboard.enabled", "true");
        props.put("sts.forum.url", "http://forum.springsource.org/forumdisplay.php?32-SpringSource-Tool-Suite");
        props.put("sts.forum.url.label", "Forum");
        props.put("sts.forum.url.external", "true");
        props.put("sts.tracker.url", "https://issuetracker.springsource.com/browse/STS");
        props.put("sts.tracker.url.label", "Issues");
        props.put("sts.tracker.url.external", "true");
        props.put("spring.docs.url", "https://spring.io/docs");
        props.put("spring.docs.url.label", "Spring Docs");
        props.put("spring.docs.url.external", "true");
        props.put("spring.blog.url", "https://spring.io/blog");
        props.put("spring.blog.url.label", "Blog");
        props.put("spring.blog.url.external", "true");
        props.put("spring.guides.url", "https://spring.io/guides");
        props.put("spring.guides.url.label", "Guides");
        props.put("spring.guides.url.external", "true");
        props.put("sts.nan.url", "http://docs.spring.io/sts/nan/latest/NewAndNoteworthy.html");
        props.put("spring.boot.install.url", "http://repo.spring.io/release/org/springframework/boot/spring-boot-cli/1.0.0.RELEASE/spring-boot-cli-1.0.0.RELEASE-bin.zip");
        props.put("spring.reference.app.discovery.url", "https://raw.github.com/kdvolder/spring-reference-apps-meta/master/reference-apps.json");
        props.put("spring.boot.typegraph.url", "http://aetherial.cfapps.io/boot/typegraph");
        props.put("spring.boot.default.version", "1.0.0.RELEASE");
        return props;
    }

    public Collection<String> getExplicitProperties() {
        ArrayList<String> keys = new ArrayList<String>();
        for (Object string : this.props.keySet()) {
            if (!(string instanceof String)) continue;
            keys.add((String)string);
        }
        return keys;
    }

    public String get(String key) {
        String value = System.getProperty(key);
        if (value == null) {
            value = this.props.getProperty(key);
        }
        return value;
    }

    public boolean get(String key, boolean deflt) {
        String value = this.get(key);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return deflt;
    }

    public static StsProperties getInstance() {
        return StsProperties.getInstance((IProgressMonitor)new NullProgressMonitor());
    }

    public static class AscendingPriority
    implements Comparator<FromUrl> {
        @Override
        public int compare(FromUrl o1, FromUrl o2) {
            return o1.priority - o2.priority;
        }
    }

    private static class FromUrl {
        public final String url;
        public final int priority;

        public FromUrl(IConfigurationElement element) {
            this.url = element.getAttribute("url");
            this.priority = Integer.parseInt(element.getAttribute("priority"));
        }

        public String toString() {
            return "(" + this.priority + ", " + this.url + ")";
        }
    }
}

