/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.util;

import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.corext.util.TypeFilter;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaTypeCompletionProposal;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.text.java.CompletionProposalComparator;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.ILabelProvider;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistContext;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistProposalRecorder;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansJavaCompletionProposalCollector;
import org.springframework.ide.eclipse.beans.ui.editor.util.CompilationUnitHelper;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.java.JdtUtils;

public class BeansJavaCompletionUtils {
    public static final int FLAG_INTERFACE = 4;
    public static final int FLAG_CLASS = 8;
    public static final int FLAG_PACKAGE = 16;
    private static final String CLASS_NAME = "_xxx";
    private static final String CLASS_SOURCE_END = "\n    }\n}";
    private static final String CLASS_SOURCE_START = "public class _xxx {\n    public void main(String[] args) {\n        ";
    private static CompletionProposalComparator COMPARATOR = new CompletionProposalComparator();
    private static ILabelProvider JAVA_LABEL_PROVIDER = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT | 0x800);

    public static void addClassValueProposals(IContentAssistContext context, IContentAssistProposalRecorder recorder) {
        BeansJavaCompletionUtils.addClassValueProposals(context, recorder, 24);
    }

    public static void addInterfaceValueProposals(IContentAssistContext context, IContentAssistProposalRecorder recorder) {
        BeansJavaCompletionUtils.addClassValueProposals(context, recorder, 20);
    }

    public static void addPackageValueProposals(IContentAssistContext context, IContentAssistProposalRecorder recorder) {
        BeansJavaCompletionUtils.addClassValueProposals(context, recorder, 16);
    }

    public static void addClassValueProposals(IContentAssistContext context, IContentAssistProposalRecorder recorder, int flags) {
        String prefix = context.getMatchString();
        if (prefix == null || prefix.length() == 0) {
            return;
        }
        try {
            IFile file = context.getFile();
            if (file != null && file.exists()) {
                ICompletionProposal[] proposals;
                ICompilationUnit unit = BeansJavaCompletionUtils.createSourceCompilationUnit(file, prefix);
                char enclosingChar = prefix.lastIndexOf(36) > 0 ? (char)'$' : '.';
                if ((prefix = prefix.replace('$', '.')).lastIndexOf(46) > 0) {
                    String rootClass = prefix.substring(0, prefix.lastIndexOf(46));
                    IType type = JdtUtils.getJavaType((IProject)file.getProject(), (String)rootClass);
                    if (type != null) {
                        IType[] iTypeArray = type.getTypes();
                        int n = iTypeArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IType innerType = iTypeArray[n2];
                            if (Flags.isPrivate((int)innerType.getFlags()) && innerType.getFullyQualifiedName('.').startsWith(prefix)) {
                                recorder.recordProposal(JAVA_LABEL_PROVIDER.getImage((Object)innerType), 10, JAVA_LABEL_PROVIDER.getText((Object)innerType), innerType.getFullyQualifiedName(enclosingChar), innerType);
                            }
                            ++n2;
                        }
                    }
                }
                String sourceStart = CLASS_SOURCE_START + prefix;
                String packageName = null;
                int dot = prefix.lastIndexOf(46);
                if (dot > -1) {
                    packageName = prefix.substring(0, dot);
                    sourceStart = "package " + packageName + ";\n" + sourceStart;
                }
                String source = String.valueOf(sourceStart) + CLASS_SOURCE_END;
                BeansJavaCompletionUtils.setContents(unit, source);
                BeansJavaCompletionProposalCollector collector = new BeansJavaCompletionProposalCollector(unit, flags);
                unit.codeComplete(sourceStart.length(), (CompletionRequestor)collector, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
                IJavaCompletionProposal[] props = collector.getJavaCompletionProposals();
                ICompletionProposal[] iCompletionProposalArray = proposals = BeansJavaCompletionUtils.order((ICompletionProposal[])props);
                int n = proposals.length;
                int n3 = 0;
                while (n3 < n) {
                    ICompletionProposal comProposal = iCompletionProposalArray[n3];
                    BeansJavaCompletionUtils.processJavaCompletionProposal(recorder, comProposal, packageName, enclosingChar);
                    ++n3;
                }
            }
        }
        catch (Exception exception) {}
    }

    public static void addTypeHierachyAttributeValueProposals(IContentAssistContext context, IContentAssistProposalRecorder recorder, String typeName, int flags) {
        String prefix = context.getMatchString();
        if (prefix == null || prefix.length() == 0) {
            return;
        }
        IFile file = context.getFile();
        if (file != null && file.exists()) {
            IType type = JdtUtils.getJavaType((IProject)file.getProject(), (String)typeName);
            try {
                if (type != null && file.getProject().hasNature("org.eclipse.jdt.core.javanature") && !TypeFilter.isFiltered((IType)type)) {
                    ITypeHierarchy hierachy = type.newTypeHierarchy(JavaCore.create((IProject)file.getProject()), (IProgressMonitor)new NullProgressMonitor());
                    IType[] types = hierachy.getAllSubtypes(type);
                    HashMap<String, IType> sortMap = new HashMap<String, IType>();
                    IType[] iTypeArray = types;
                    int n = types.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IType foundType = iTypeArray[n2];
                        if ((foundType.getFullyQualifiedName().startsWith(prefix) || foundType.getElementName().startsWith(prefix)) && !sortMap.containsKey(foundType.getFullyQualifiedName()) && !Flags.isAbstract((int)foundType.getFlags())) {
                            boolean accepted = false;
                            if ((flags & 8) != 0 && !Flags.isInterface((int)foundType.getFlags())) {
                                accepted = true;
                            } else if ((flags & 4) != 0 && Flags.isInterface((int)foundType.getFlags())) {
                                accepted = true;
                            }
                            if (accepted) {
                                recorder.recordProposal(JavaPluginImages.get((String)"org.eclipse.jdt.ui.class_obj.gif"), 10, String.valueOf(foundType.getElementName()) + " - " + foundType.getPackageFragment().getElementName(), foundType.getFullyQualifiedName(), foundType);
                                sortMap.put(foundType.getFullyQualifiedName(), foundType);
                            }
                        }
                        ++n2;
                    }
                }
            }
            catch (JavaModelException javaModelException) {
            }
            catch (CoreException coreException) {}
        }
    }

    private static ICompilationUnit createSourceCompilationUnit(IFile file, String prefix) throws JavaModelException {
        IProgressMonitor progressMonitor = BeansEditorUtils.getProgressMonitor();
        IJavaProject project = JavaCore.create((IProject)file.getProject());
        IPackageFragment root = BeansJavaCompletionUtils.getPackageFragment(project, prefix);
        ICompilationUnit unit = root.getCompilationUnit("_xxx.java").getWorkingCopy(CompilationUnitHelper.getInstance().getWorkingCopyOwner(), (IProblemRequestor)CompilationUnitHelper.getInstance().getProblemRequestor(), progressMonitor);
        progressMonitor.done();
        return unit;
    }

    private static IPackageFragment getPackageFragment(IJavaProject project, String prefix) throws JavaModelException {
        int dot = prefix.lastIndexOf(46);
        if (dot > -1) {
            IPackageFragment[] packages;
            String packageName = prefix.substring(0, dot);
            IPackageFragmentRoot[] iPackageFragmentRootArray = project.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                IPackageFragment p = root.getPackageFragment(packageName);
                if (p != null && p.exists()) {
                    return p;
                }
                ++n2;
            }
            IPackageFragment[] iPackageFragmentArray = packages = project.getPackageFragments();
            int n3 = packages.length;
            n = 0;
            while (n < n3) {
                IPackageFragment p = iPackageFragmentArray[n];
                if (p.getElementName().equals(packageName)) {
                    return p;
                }
                ++n;
            }
        } else {
            IPackageFragmentRoot[] iPackageFragmentRootArray = project.getAllPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n4 = 0;
            while (n4 < n) {
                IPackageFragmentRoot p = iPackageFragmentRootArray[n4];
                if (p.getKind() == 1) {
                    return p.getPackageFragment("");
                }
                ++n4;
            }
        }
        return project.getPackageFragments()[0];
    }

    private static ICompletionProposal[] order(ICompletionProposal[] proposals) {
        Arrays.sort(proposals, COMPARATOR);
        return proposals;
    }

    private static void processJavaCompletionProposal(IContentAssistProposalRecorder recorder, ICompletionProposal comProposal, String packageName, char enclosingChar) {
        if (comProposal instanceof JavaCompletionProposal) {
            JavaCompletionProposal prop = (JavaCompletionProposal)comProposal;
            recorder.recordProposal(prop.getImage(), prop.getRelevance(), prop.getDisplayString(), prop.getReplacementString(), prop.getJavaElement());
        } else if (comProposal instanceof LazyJavaTypeCompletionProposal) {
            LazyJavaTypeCompletionProposal prop = (LazyJavaTypeCompletionProposal)comProposal;
            if (prop.getQualifiedTypeName().equals(String.valueOf(packageName) + "." + CLASS_NAME) || prop.getQualifiedTypeName().equals(CLASS_NAME)) {
                return;
            }
            if (prop.getJavaElement() instanceof IType) {
                if (TypeFilter.isFiltered((IType)((IType)prop.getJavaElement()))) {
                    return;
                }
                String replacementString = ((IType)prop.getJavaElement()).getFullyQualifiedName(enclosingChar);
                recorder.recordProposal(prop.getImage(), prop.getRelevance(), prop.getDisplayString(), replacementString, prop.getJavaElement());
            }
        } else if (comProposal instanceof LazyJavaCompletionProposal) {
            LazyJavaCompletionProposal prop = (LazyJavaCompletionProposal)comProposal;
            recorder.recordProposal(prop.getImage(), prop.getRelevance(), prop.getDisplayString(), prop.getReplacementString(), prop.getJavaElement());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setContents(ICompilationUnit cu, String source) {
        if (cu == null) {
            return;
        }
        ICompilationUnit iCompilationUnit = cu;
        synchronized (iCompilationUnit) {
            IBuffer buffer;
            try {
                buffer = cu.getBuffer();
            }
            catch (JavaModelException e) {
                SpringCore.log((Throwable)e);
                buffer = null;
            }
            if (buffer != null) {
                buffer.setContents(source);
            }
        }
    }
}

