/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.hyperlink.bean;

import java.util.LinkedHashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansImport;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.IMultiHyperlinkCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springsource.ide.eclipse.commons.ui.SpringUIUtils;
import org.w3c.dom.Node;

public class ImportHyperlinkCalculator
implements IMultiHyperlinkCalculator {
    public IHyperlink[] createHyperlinks(String name, String target, Node node, Node parentNode, IDocument document, ITextViewer textViewer, IRegion hyperlinkRegion, IRegion cursor) {
        LinkedHashSet<WorkspaceFileHyperlink> hyperlinks = new LinkedHashSet<WorkspaceFileHyperlink>();
        try {
            int startOffset = ((IDOMNode)node).getStartOffset();
            int endOffset = ((IDOMNode)node).getEndOffset();
            int start = document.getLineOfOffset(startOffset) + 1;
            int end = document.getLineOfOffset(endOffset) + 1;
            IFile file = BeansEditorUtils.getFile(document);
            IModelElement element = BeansModelUtils.getMostSpecificModelElement((int)start, (int)end, (IFile)file, null);
            if (element instanceof IBeansImport) {
                for (IBeansConfig config : ((IBeansImport)element).getImportedBeansConfigs()) {
                    hyperlinks.add(new WorkspaceFileHyperlink(hyperlinkRegion, (IFile)config.getElementResource()));
                }
            }
        }
        catch (BadLocationException badLocationException) {}
        return hyperlinks.toArray(new IHyperlink[hyperlinks.size()]);
    }

    public IHyperlink createHyperlink(String name, String target, Node node, Node parentNode, IDocument document, ITextViewer textViewer, IRegion hyperlinkRegion, IRegion cursor) {
        IHyperlink[] hyperlinks = this.createHyperlinks(name, target, node, parentNode, document, textViewer, hyperlinkRegion, cursor);
        if (hyperlinks != null && hyperlinks.length > 0) {
            return hyperlinks[0];
        }
        return null;
    }

    class WorkspaceFileHyperlink
    implements IHyperlink {
        private IRegion region;
        private IFile file;

        public WorkspaceFileHyperlink(IRegion region, IFile file) {
            this.region = region;
            this.file = file;
        }

        public IRegion getHyperlinkRegion() {
            return this.region;
        }

        public String getTypeLabel() {
            return null;
        }

        public String getHyperlinkText() {
            String path = this.file.getFullPath().toString();
            if (path.length() > 60) {
                path = String.valueOf(path.substring(0, 25)) + "..." + path.substring(path.length() - 25, path.length());
            }
            return "Open '" + path + "'";
        }

        public void open() {
            if (this.file != null && this.file.exists()) {
                SpringUIUtils.openInEditor((IFile)this.file, (int)1);
            }
        }
    }
}

