/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.contentassist.bean;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.BeanReferenceContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.ClassContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.DefaultContentAssistContext;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.DefaultContentAssistProposalRecorder;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistContext;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistProposalRecorder;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.NamespaceContentAssistProcessorSupport;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.PropertyBeanReferenceContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.bean.BeanIdContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.bean.ConstructorArgNameContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.bean.ConstructorArgNameSearchRequestor;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.bean.ConstructorArgValueContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.bean.FactoryMethodContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.bean.InitDestroyMethodContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.bean.LookupMethodContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.bean.PropertyNameContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.bean.PropertyNameSearchRequestor;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.bean.PropertyValueContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.bean.ReplaceMethodContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.bean.ScopeContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansCompletionUtils;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.core.java.Introspector;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class BeansContentAssistProcessor
extends NamespaceContentAssistProcessorSupport {
    private void addPropertyNameAttributeNameProposals(ContentAssistRequest request, String prefix, String oldPrefix, Node node, List classNames, boolean attrAtLocationHasValue, String nameSpacePrefix) {
        PropertyNameSearchRequestor requestor = new PropertyNameSearchRequestor(request, oldPrefix, attrAtLocationHasValue, nameSpacePrefix);
        if (prefix.lastIndexOf(".") >= 0) {
            int firstIndex = prefix.indexOf(".");
            String firstPrefix = prefix.substring(0, firstIndex);
            String lastPrefix = prefix.substring(firstIndex);
            if (".".equals(lastPrefix)) {
                lastPrefix = "";
            } else if (lastPrefix.startsWith(".")) {
                lastPrefix = lastPrefix.substring(1);
            }
            int i = 0;
            while (i < classNames.size()) {
                IType type = (IType)classNames.get(i);
                try {
                    Iterator iterator;
                    Set methods = Introspector.findReadableProperties((IType)type, (String)firstPrefix);
                    if (methods != null && methods.size() == 1 && (iterator = methods.iterator()).hasNext()) {
                        IMethod method = (IMethod)iterator.next();
                        IType returnType = JdtUtils.getJavaTypeForMethodReturnType((IMethod)method, (IType)type);
                        if (returnType != null) {
                            ArrayList<IType> typesTemp = new ArrayList<IType>();
                            typesTemp.add(returnType);
                            String newPrefix = String.valueOf(oldPrefix) + firstPrefix + ".";
                            this.addPropertyNameAttributeNameProposals(request, lastPrefix, newPrefix, node, typesTemp, attrAtLocationHasValue, nameSpacePrefix);
                        }
                        return;
                    }
                }
                catch (JavaModelException javaModelException) {}
                ++i;
            }
        } else {
            int i = 0;
            while (i < classNames.size()) {
                IType type = (IType)classNames.get(i);
                try {
                    Set methods = Introspector.findWritableProperties((IType)type, (String)prefix);
                    if (methods != null && methods.size() > 0) {
                        Iterator iterator = methods.iterator();
                        while (iterator.hasNext()) {
                            requestor.acceptSearchMatch((IMethod)iterator.next(), false);
                        }
                    }
                }
                catch (JavaModelException javaModelException) {
                }
                catch (CoreException coreException) {}
                ++i;
            }
        }
    }

    private void addConstructorNameAttributeNameProposals(ContentAssistRequest request, String prefix, String oldPrefix, Node node, List classNames, boolean attrAtLocationHasValue, String nameSpacePrefix) {
        ConstructorArgNameSearchRequestor requestor = new ConstructorArgNameSearchRequestor(request, oldPrefix, attrAtLocationHasValue, nameSpacePrefix);
        int i = 0;
        while (i < classNames.size()) {
            IType type = (IType)classNames.get(i);
            try {
                Set constructors = Introspector.findAllConstructors((IType)type);
                if (constructors != null && constructors.size() > 0) {
                    Iterator iterator = constructors.iterator();
                    while (iterator.hasNext()) {
                        requestor.acceptSearchMatch((IMethod)iterator.next());
                    }
                }
            }
            catch (JavaModelException javaModelException) {
            }
            catch (CoreException coreException) {}
            ++i;
        }
    }

    protected void computeAttributeNameProposals(ContentAssistRequest request, String prefix, String namespace, String namespacePrefix, Node attributeNode) {
        if ("http://www.springframework.org/schema/p".equals(namespace)) {
            IStructuredDocumentRegion sdRegion = request.getDocumentRegion();
            boolean attrAtLocationHasValue = false;
            NamedNodeMap attrs = attributeNode.getAttributes();
            int i = 0;
            while (i < attrs.getLength()) {
                AttrImpl existingAttr = (AttrImpl)attrs.item(i);
                ITextRegion name = existingAttr.getNameRegion();
                if (sdRegion.getStartOffset(name) <= request.getReplacementBeginPosition() && sdRegion.getStartOffset(name) + name.getLength() >= request.getReplacementBeginPosition() + request.getReplacementLength() && existingAttr.getValueRegion() != null) {
                    attrAtLocationHasValue = true;
                    break;
                }
                ++i;
            }
            if (prefix != null) {
                prefix = BeansEditorUtils.attributeNameToPropertyName(prefix);
            }
            List<IType> classNames = BeansEditorUtils.getClassNamesOfBean(BeansEditorUtils.getFile(request), attributeNode);
            this.addPropertyNameAttributeNameProposals(request, prefix, "", attributeNode, classNames, attrAtLocationHasValue, namespacePrefix);
        } else if ("http://www.springframework.org/schema/c".equals(namespace)) {
            IStructuredDocumentRegion sdRegion = request.getDocumentRegion();
            boolean attrAtLocationHasValue = false;
            NamedNodeMap attrs = attributeNode.getAttributes();
            int i = 0;
            while (i < attrs.getLength()) {
                AttrImpl existingAttr = (AttrImpl)attrs.item(i);
                ITextRegion name = existingAttr.getNameRegion();
                if (sdRegion.getStartOffset(name) <= request.getReplacementBeginPosition() && sdRegion.getStartOffset(name) + name.getLength() >= request.getReplacementBeginPosition() + request.getReplacementLength() && existingAttr.getValueRegion() != null) {
                    attrAtLocationHasValue = true;
                    break;
                }
                ++i;
            }
            if (prefix != null) {
                prefix = BeansEditorUtils.attributeNameToPropertyName(prefix);
            }
            List<IType> classNames = BeansEditorUtils.getClassNamesOfBean(BeansEditorUtils.getFile(request), attributeNode);
            this.addConstructorNameAttributeNameProposals(request, prefix, "", attributeNode, classNames, attrAtLocationHasValue, namespacePrefix);
        }
    }

    protected void computeTagInsertionProposals(ContentAssistRequest request, IDOMNode node) {
        if (node != null && node.getParentNode() != null) {
            Node parentNode = node.getParentNode();
            if ("bean".equals(parentNode.getNodeName())) {
                this.addTemplates(request, "org.springframework.ide.eclipse.beans.ui.editor.templates.contextType.bean");
            } else if ("beans".equals(parentNode.getNodeName())) {
                this.addTemplates(request, "org.springframework.ide.eclipse.beans.ui.editor.templates.contextType.all");
            } else if ("property".equals(parentNode.getNodeName())) {
                this.addTemplates(request, "org.springframework.ide.eclipse.beans.ui.editor.templates.contextType.property");
                this.addTemplates(request, "org.springframework.ide.eclipse.beans.ui.editor.templates.contextType.all");
            }
        }
    }

    public void init() {
        ClassContentAssistCalculator clazzOnly = new ClassContentAssistCalculator(false);
        ClassContentAssistCalculator clazzAndInterface = new ClassContentAssistCalculator();
        this.registerContentAssistCalculator("bean", "class", clazzOnly);
        this.registerContentAssistCalculator("constructor-arg", "type", clazzAndInterface);
        this.registerContentAssistCalculator("arg-type", "match", clazzAndInterface);
        this.registerContentAssistCalculator("value", "type", clazzAndInterface);
        this.registerContentAssistCalculator("value-type", clazzAndInterface);
        this.registerContentAssistCalculator("key-type", clazzAndInterface);
        PropertyBeanReferenceContentAssistCalculator propertyBean = new PropertyBeanReferenceContentAssistCalculator();
        this.registerContentAssistCalculator("http://www.springframework.org/schema/beans", "bean", "property", "ref", propertyBean);
        BeanReferenceContentAssistCalculator globalBean = new BeanReferenceContentAssistCalculator();
        this.registerContentAssistCalculator("bean", "parent", globalBean);
        this.registerContentAssistCalculator("bean", "depends-on", globalBean);
        this.registerContentAssistCalculator("bean", "factory-bean", globalBean);
        this.registerContentAssistCalculator("ref", "bean", globalBean);
        this.registerContentAssistCalculator("idref", "bean", globalBean);
        this.registerContentAssistCalculator("constructor-arg", "ref", globalBean);
        this.registerContentAssistCalculator("alias", "name", globalBean);
        this.registerContentAssistCalculator("replaced-method", "replacer", globalBean);
        this.registerContentAssistCalculator("entry", "value-ref", globalBean);
        this.registerContentAssistCalculator("entry", "key-ref", globalBean);
        this.registerContentAssistCalculator("lookup-method", "bean", globalBean);
        BeanReferenceContentAssistCalculator localBean = new BeanReferenceContentAssistCalculator(false);
        this.registerContentAssistCalculator("ref", "local", localBean);
        this.registerContentAssistCalculator("idref", "local", localBean);
        InitDestroyMethodContentAssistCalculator initDestroy = new InitDestroyMethodContentAssistCalculator();
        this.registerContentAssistCalculator("bean", "init-method", initDestroy);
        this.registerContentAssistCalculator("bean", "destroy-method", initDestroy);
        this.registerContentAssistCalculator("bean", "id", new BeanIdContentAssistCalculator());
        this.registerContentAssistCalculator("replaced-method", "name", new ReplaceMethodContentAssistCalculator());
        this.registerContentAssistCalculator("lookup-method", "name", new LookupMethodContentAssistCalculator());
        this.registerContentAssistCalculator("http://www.springframework.org/schema/beans", "bean", "property", "name", new PropertyNameContentAssistCalculator());
        this.registerContentAssistCalculator("http://www.springframework.org/schema/beans", "bean", "property", "value", new PropertyValueContentAssistCalculator());
        this.registerContentAssistCalculator("bean", "factory-method", new FactoryMethodContentAssistCalculator());
        this.registerContentAssistCalculator("bean", "scope", new ScopeContentAssistCalculator());
        this.registerContentAssistCalculator("http://www.springframework.org/schema/beans", "bean", "constructor-arg", "name", new ConstructorArgNameContentAssistCalculator());
        this.registerContentAssistCalculator("http://www.springframework.org/schema/beans", "bean", "constructor-arg", "value", new ConstructorArgValueContentAssistCalculator());
    }

    protected void postComputeAttributeValueProposals(ContentAssistRequest request, IDOMNode node, String matchString, String attributeName, String namespace, String prefix) {
        if ("bean".equals(node.getNodeName()) && ("http://www.springframework.org/schema/p".equals(namespace) || "http://www.springframework.org/schema/c".equals(namespace)) && attributeName.endsWith("-ref")) {
            DefaultContentAssistContext context = new DefaultContentAssistContext(request, attributeName, matchString);
            DefaultContentAssistProposalRecorder recorder = new DefaultContentAssistProposalRecorder(request);
            this.addBeanReferenceProposals(context, recorder);
        }
    }

    private void addBeanReferenceProposals(IContentAssistContext context, IContentAssistProposalRecorder recorder) {
        BeansCompletionUtils.addBeanReferenceProposals(context, recorder, true);
    }
}

