/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.refactoring.actions;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.xml.core.internal.document.TextImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.springframework.ide.eclipse.beans.ui.actions.AbstractBeansConfigEditorHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RefactorPropertyElementAction
extends AbstractBeansConfigEditorHandler {
    void processAction(IDocument document, ITextSelection textSelection) {
        IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForEdit(document);
        if (model != null) {
            IndexedRegion region = model.getIndexedRegion(textSelection.getOffset());
            Element elem = null;
            if (region instanceof Element) {
                elem = (Element)region;
            } else if (region instanceof Attr) {
                elem = ((Attr)region).getOwnerElement();
            }
            if (elem != null && elem.getOwnerDocument() instanceof IDOMDocument) {
                if ("property".equals(elem.getTagName()) || "constructor-arg".equals(elem.getTagName())) {
                    this.processNode(model, elem);
                } else if ("ref".equals(elem.getTagName()) || "value".equals(elem.getTagName())) {
                    this.processNode(model, (Element)elem.getParentNode());
                }
            }
        }
    }

    private void processNode(IStructuredModel model, Element elem) {
        model.beginRecording((Object)this);
        model.aboutToChangeModel();
        try {
            NodeList children = elem.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node valueElement = children.item(i);
                if (valueElement != null) {
                    String value;
                    if ("ref".equals(valueElement.getNodeName())) {
                        String beanRef = null;
                        NamedNodeMap attributes = valueElement.getAttributes();
                        if (attributes != null) {
                            if (attributes.getNamedItem("bean") != null) {
                                beanRef = attributes.getNamedItem("bean").getNodeValue();
                            }
                            if (attributes.getNamedItem("parent") != null) {
                                beanRef = attributes.getNamedItem("parent").getNodeValue();
                            }
                            if (attributes.getNamedItem("local") != null) {
                                beanRef = attributes.getNamedItem("local").getNodeValue();
                            }
                            if (beanRef != null) {
                                elem.setAttribute("ref", beanRef);
                                elem.removeChild(valueElement);
                                this.removeTextChildren(elem);
                                this.formatElement(elem);
                            }
                        }
                    } else if ("value".equals(valueElement.getNodeName()) && valueElement.getFirstChild() != null && (value = valueElement.getFirstChild().getNodeValue()) != null) {
                        elem.setAttribute("value", value);
                        elem.removeChild(valueElement);
                        this.removeTextChildren(elem);
                        this.formatElement(elem);
                    }
                }
                ++i;
            }
            if (!model.isDirty()) {
                if (elem.hasAttribute("ref")) {
                    String beanRef = elem.getAttribute("ref");
                    if (beanRef != null) {
                        Element refElem = elem.getOwnerDocument().createElement("ref");
                        refElem.setAttribute("bean", beanRef);
                        elem.appendChild(refElem);
                        elem.removeAttribute("ref");
                        this.removeTextChildren(elem);
                        this.formatElement(elem);
                    }
                } else {
                    elem.hasAttribute("value");
                }
            }
        }
        finally {
            model.changedModel();
            model.endRecording((Object)this);
            model.releaseFromEdit();
        }
    }

    private void removeTextChildren(Element elem) {
        NodeList children = elem.getChildNodes();
        ArrayList<Node> textElements = new ArrayList<Node>();
        int j = 0;
        while (j < children.getLength()) {
            Node nodetest = children.item(j);
            if (nodetest instanceof TextImpl) {
                textElements.add(nodetest);
            }
            ++j;
        }
        int k = 0;
        while (k < textElements.size()) {
            elem.removeChild((Node)textElements.get(k));
            ++k;
        }
        elem.normalize();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IDocument document = this.getTextEditor(event).getDocumentProvider().getDocument((Object)this.getTextEditor(event).getEditorInput());
        if (document != null) {
            ITextSelection textSelection = this.getCurrentSelection(event);
            if (textSelection.isEmpty()) {
                return null;
            }
            this.processAction(document, textSelection);
        }
        return null;
    }

    private void formatElement(Element element) {
        FormatProcessorXML formatProcessor = new FormatProcessorXML();
        formatProcessor.getFormatPreferences().setClearAllBlankLines(true);
        formatProcessor.formatNode((Node)element);
    }
}

