/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.core.internal.model.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.springframework.ide.eclipse.aop.core.Activator;
import org.springframework.ide.eclipse.aop.core.model.IAspectDefinition;
import org.springframework.ide.eclipse.aop.core.model.builder.IAspectDefinitionBuilder;
import org.springframework.ide.eclipse.aop.core.model.builder.IDocumentFactory;
import org.springframework.ide.eclipse.core.io.ExternalFile;
import org.springframework.ide.eclipse.core.java.IProjectClassLoaderSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AspectDefinitionBuilderHelper {
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String ASPECT_DEFINITION_BUILDER_ELEMENT = "aspectDefinitionBuilder";
    private static final String ASPECT_DEFINITION_BUILDER_EXTENSION_POINT = "org.springframework.ide.eclipse.aop.core.aspectdefinitionbuilder";
    private Set<IAspectDefinitionBuilder> builders = this.loadAspectDefinitionBuilder();
    private DefaultDocumentFactory documentFactory = new DefaultDocumentFactory();

    private Set<IAspectDefinitionBuilder> loadAspectDefinitionBuilder() {
        HashSet<IAspectDefinitionBuilder> builders = new HashSet<IAspectDefinitionBuilder>();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(ASPECT_DEFINITION_BUILDER_EXTENSION_POINT);
        if (point != null) {
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement config = iConfigurationElementArray[n4];
                    if (ASPECT_DEFINITION_BUILDER_ELEMENT.equals(config.getName()) && config.getAttribute(CLASS_ATTRIBUTE) != null) {
                        try {
                            Object handler = config.createExecutableExtension(CLASS_ATTRIBUTE);
                            if (handler instanceof IAspectDefinitionBuilder) {
                                builders.add((IAspectDefinitionBuilder)handler);
                            }
                        }
                        catch (CoreException e) {
                            Activator.log(e);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return builders;
    }

    public List<IAspectDefinition> buildAspectDefinitions(IFile file, IProjectClassLoaderSupport classLoaderSupport) {
        ArrayList<IAspectDefinition> aspectInfos = new ArrayList<IAspectDefinition>();
        for (IAspectDefinitionBuilder builder : this.builders) {
            builder.buildAspectDefinitions(aspectInfos, file, classLoaderSupport, this.documentFactory);
        }
        return aspectInfos;
    }

    public void close() {
        this.documentFactory.releaseModels();
    }

    private class DefaultDocumentFactory
    implements IDocumentFactory {
        private Map<IFile, IDOMModel> cache = new ConcurrentHashMap<IFile, IDOMModel>();

        private DefaultDocumentFactory() {
        }

        public IDOMDocument createDocument(IFile file) {
            block15: {
                if (this.cache.containsKey(file)) {
                    return this.cache.get(file).getDocument();
                }
                IStructuredModel model = null;
                try {
                    if (file instanceof ExternalFile) {
                        try {
                            model = StructuredModelManager.getModelManager().getModelForRead(file.getName(), file.getContents(), null);
                        }
                        catch (RuntimeException runtimeException) {}
                    } else {
                        try {
                            model = StructuredModelManager.getModelManager().getExistingModelForRead(file);
                        }
                        catch (RuntimeException runtimeException) {}
                        if (model == null) {
                            model = StructuredModelManager.getModelManager().getModelForRead(file);
                        }
                    }
                    if (model == null) break block15;
                    try {
                        IDOMDocument document = ((IDOMModel)model).getDocument();
                        if (document != null && document.getDocumentElement() != null) {
                            this.cache.put(file, (IDOMModel)model);
                            return document;
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        if (model != null) {
                            model.releaseFromRead();
                        }
                        return null;
                    }
                }
                catch (IOException e) {
                    Activator.log(e);
                }
                catch (CoreException e) {
                    Activator.log(e);
                }
            }
            return null;
        }

        protected void releaseModels() {
            for (IDOMModel document : this.cache.values()) {
                try {
                    document.releaseFromRead();
                }
                catch (Exception exception) {}
            }
        }
    }
}

