/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.core.internal.model;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.XMLMemento;
import org.springframework.ide.eclipse.aop.core.Activator;
import org.springframework.ide.eclipse.aop.core.internal.model.AnnotationAspectDefinitionElementFactory;
import org.springframework.ide.eclipse.aop.core.internal.model.AnnotationIntroductionDefinitionElementFactory;
import org.springframework.ide.eclipse.aop.core.internal.model.AopReferenceElementFactory;
import org.springframework.ide.eclipse.aop.core.internal.model.BeanAspectDefinitionElementFactory;
import org.springframework.ide.eclipse.aop.core.internal.model.BeanIntroductionDefinitionElementFactory;
import org.springframework.ide.eclipse.aop.core.internal.model.JavaAdvisorDefinitionElementFactory;
import org.springframework.ide.eclipse.aop.core.model.IAopProject;
import org.springframework.ide.eclipse.aop.core.model.IAopReference;
import org.springframework.ide.eclipse.aop.core.model.IAopReferenceModel;
import org.springframework.ide.eclipse.aop.core.model.IAspectDefinition;
import org.springframework.ide.eclipse.aop.core.util.AopReferenceModelMarkerUtils;

public class AopReferenceModelPeristence {
    private static final Map<String, IElementFactory> ELEMENT_FACTORIES = new HashMap<String, IElementFactory>();
    private static final String AOP_PROJECT_ELEMENT = "aop-project";
    private static final String AOP_REFERENCE_ELEMENT = "aop-reference";
    private static final String AOP_REFERENCE_MODEL_ELEMENT = "aop-reference-model";
    private static final String ASPECT_DEFINITION_ELEMENT = "aspect-definition";
    private static final String FACTORY_ID = "factory-id";
    private static final String NAME_ATTRIBUTE = "name";
    private IPath defaultFile = Activator.getDefault().getStateLocation().append(".state");

    static {
        ELEMENT_FACTORIES.put(AnnotationAspectDefinitionElementFactory.FACTORY_ID, new AnnotationAspectDefinitionElementFactory());
        ELEMENT_FACTORIES.put(AnnotationIntroductionDefinitionElementFactory.FACTORY_ID, new AnnotationIntroductionDefinitionElementFactory());
        ELEMENT_FACTORIES.put(BeanAspectDefinitionElementFactory.FACTORY_ID, new BeanAspectDefinitionElementFactory());
        ELEMENT_FACTORIES.put(BeanIntroductionDefinitionElementFactory.FACTORY_ID, new BeanIntroductionDefinitionElementFactory());
        ELEMENT_FACTORIES.put(JavaAdvisorDefinitionElementFactory.FACTORY_ID, new JavaAdvisorDefinitionElementFactory());
        ELEMENT_FACTORIES.put(AopReferenceElementFactory.FACTORY_ID, new AopReferenceElementFactory());
    }

    private IMemento appendNewChild(IMemento memento, String type) {
        memento.createChild(type);
        IMemento[] ms = memento.getChildren(type);
        if (ms != null && ms.length > 0) {
            return ms[ms.length - 1];
        }
        return memento;
    }

    private void createAopProjects(IAopReferenceModel model, XMLMemento memento) {
        IMemento[] projects = memento.getChildren(AOP_PROJECT_ELEMENT);
        if (projects != null && projects.length > 0) {
            IMemento[] iMementoArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento project = iMementoArray[n2];
                String projectName = project.getString(NAME_ATTRIBUTE);
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IResource member = root.findMember(projectName);
                if (member instanceof IProject) {
                    IJavaProject javaProject = JavaCore.create((IProject)((IProject)member));
                    IAopProject aopProject = model.getProject(javaProject);
                    this.createAspectDefinitions(projects, project, aopProject);
                    Set<IAopReference> references = aopProject.getAllReferences();
                    for (IAopReference reference : references) {
                        AopReferenceModelMarkerUtils.createMarker(reference, reference.getResource());
                    }
                }
                ++n2;
            }
        }
    }

    private void createAopReferences(IAopProject aopProject, IMemento aspectDefinitionM, IAspectDefinition aspectDefinition) {
        IMemento[] aopReferences = aspectDefinitionM.getChildren(AOP_REFERENCE_ELEMENT);
        if (aopReferences != null && aopReferences.length > 0) {
            IMemento[] iMementoArray = aopReferences;
            int n = aopReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento aopReferenceM = iMementoArray[n2];
                String factoryId = aopReferenceM.getString(FACTORY_ID);
                IAopReference aopReference = (IAopReference)ELEMENT_FACTORIES.get(factoryId).createElement(aopReferenceM);
                if (aopReference != null) {
                    aopReference.setDefinition(aspectDefinition);
                    aopProject.addAopReference(aopReference);
                }
                ++n2;
            }
        }
    }

    private void createAspectDefinitions(IMemento[] projects, IMemento project, IAopProject aopProject) {
        IMemento[] aspectDefinitions = project.getChildren(ASPECT_DEFINITION_ELEMENT);
        if (projects != null && projects.length > 0) {
            IMemento[] iMementoArray = aspectDefinitions;
            int n = aspectDefinitions.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento aspectDefinitionM = iMementoArray[n2];
                String factoryId = aspectDefinitionM.getString(FACTORY_ID);
                IAspectDefinition aspectDefinition = (IAspectDefinition)ELEMENT_FACTORIES.get(factoryId).createElement(aspectDefinitionM);
                this.createAopReferences(aopProject, aspectDefinitionM, aspectDefinition);
                ++n2;
            }
        }
    }

    protected boolean isPersisted() {
        return this.defaultFile.toFile().exists();
    }

    protected synchronized void loadReferenceModel() {
        block15: {
            if (!this.shouldModelByPersisted() || !this.isPersisted()) {
                return;
            }
            IAopReferenceModel model = Activator.getModel();
            Reader reader = null;
            try {
                try {
                    reader = new FileReader(this.defaultFile.toFile());
                    XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
                    this.createAopProjects(model, memento);
                }
                catch (Exception e) {
                    Activator.log("Cannot load .state model file", e);
                    Activator.getModel().clearProjects();
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean shouldModelByPersisted() {
        InstanceScope context = new InstanceScope();
        IEclipsePreferences node = context.getNode("org.springframework.ide.eclipse.aop.core");
        return node.getBoolean("org.springframework.ide.eclipse.aop.core.persistModel", true);
    }

    protected synchronized void saveReferenceModel() {
        block22: {
            if (!this.shouldModelByPersisted()) {
                if (this.isPersisted()) {
                    this.defaultFile.toFile().delete();
                }
                return;
            }
            XMLMemento memento = XMLMemento.createWriteRoot((String)AOP_REFERENCE_MODEL_ELEMENT);
            Collection<IAopProject> projects = Activator.getModel().getProjects();
            for (IAopProject project : projects) {
                IMemento projectM = this.appendNewChild((IMemento)memento, AOP_PROJECT_ELEMENT);
                projectM.putString(NAME_ATTRIBUTE, project.getProject().getElementName());
                Set<IAopReference> refs = project.getAllReferences();
                HashMap maps = new HashMap();
                for (IAopReference iAopReference : refs) {
                    if (maps.containsKey(iAopReference.getDefinition())) {
                        ((List)maps.get(iAopReference.getDefinition())).add(iAopReference);
                        continue;
                    }
                    ArrayList<IAopReference> r = new ArrayList<IAopReference>();
                    r.add(iAopReference);
                    maps.put(iAopReference.getDefinition(), r);
                }
                for (Map.Entry entry : maps.entrySet()) {
                    IMemento definitionM = this.appendNewChild(projectM, ASPECT_DEFINITION_ELEMENT);
                    if (!(entry.getKey() instanceof IAdaptable)) continue;
                    IPersistableElement pers = (IPersistableElement)((IAdaptable)entry.getKey()).getAdapter(IPersistableElement.class);
                    if (pers != null) {
                        pers.saveState(definitionM);
                        definitionM.putString(FACTORY_ID, pers.getFactoryId());
                    }
                    for (IAopReference ref : (List)entry.getValue()) {
                        IPersistableElement pers2;
                        if (!(ref instanceof IAdaptable) || (pers2 = (IPersistableElement)((IAdaptable)ref).getAdapter(IPersistableElement.class)) == null) continue;
                        IMemento refM = this.appendNewChild(definitionM, AOP_REFERENCE_ELEMENT);
                        pers2.saveState(refM);
                        refM.putString(FACTORY_ID, pers2.getFactoryId());
                    }
                }
            }
            Writer writer = null;
            try {
                try {
                    writer = new FileWriter(this.defaultFile.toFile());
                    memento.save(writer);
                }
                catch (IOException iOException) {
                    if (writer != null) {
                        try {
                            writer.flush();
                            writer.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.flush();
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.flush();
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

