/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model.validation.rules;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.ide.eclipse.beans.core.internal.model.Bean;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.validation.rules.AbstractBeanMethodValidationRule;
import org.springframework.ide.eclipse.beans.core.internal.model.validation.rules.ValidationRuleUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.validation.IBeansValidationContext;
import org.springframework.ide.eclipse.core.java.Introspector;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;

public class BeanInitDestroyMethodRule
extends AbstractBeanMethodValidationRule {
    public void validate(IBean bean, IBeansValidationContext context, IProgressMonitor monitor) {
        String mergedClassName;
        AbstractBeanDefinition bd = (AbstractBeanDefinition)((Bean)bean).getBeanDefinition();
        AbstractBeanDefinition mergedBd = (AbstractBeanDefinition)BeansModelUtils.getMergedBeanDefinition(bean, (IModelElement)context.getContextElement());
        IType type = ValidationRuleUtils.extractBeanClass((BeanDefinition)mergedBd, bean, mergedClassName = mergedBd.getBeanClassName(), context);
        if (type != null && !JdtUtils.doesImplement((IResource)context.getRootElementResource(), (IType)type, (String)FactoryBean.class.getName())) {
            if (mergedBd.isEnforceInitMethod()) {
                this.validateMethod(bean, type, AbstractBeanMethodValidationRule.MethodType.INIT, bd.getInitMethodName(), 0, Introspector.Static.DONT_CARE, context);
            }
            if (mergedBd.isEnforceDestroyMethod()) {
                this.validateMethod(bean, type, AbstractBeanMethodValidationRule.MethodType.DESTROY, bd.getDestroyMethodName(), 0, Introspector.Static.DONT_CARE, context);
            }
        }
    }
}

