/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model.validation.rules;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.ide.eclipse.beans.core.internal.model.Bean;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.validation.rules.ValidationRuleUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanProperty;
import org.springframework.ide.eclipse.beans.core.model.IBeansModelElement;
import org.springframework.ide.eclipse.beans.core.model.validation.AbstractNonInfrastructureBeanValidationRule;
import org.springframework.ide.eclipse.beans.core.model.validation.IBeansValidationContext;
import org.springframework.ide.eclipse.core.java.Introspector;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.validation.IValidationRule;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springsource.ide.eclipse.commons.core.SpringCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDeprecationRule
extends AbstractNonInfrastructureBeanValidationRule
implements IValidationRule<IBeansModelElement, IBeansValidationContext> {
    @Override
    protected boolean supportsModelElementForNonInfrastructureBean(IModelElement element, IBeansValidationContext context) {
        return element instanceof IBean || element instanceof IBeanProperty;
    }

    public void validate(IBeansModelElement element, IBeansValidationContext context, IProgressMonitor monitor) {
        if (element instanceof IBean) {
            this.validateBean((IBean)element, context, monitor);
        } else if (element instanceof IBeanProperty) {
            this.validatePropery((IBeanProperty)element, context, monitor);
        }
    }

    private void validatePropery(IBeanProperty property, IBeansValidationContext context, IProgressMonitor monitor) {
        String mergedClassName;
        IBean bean = BeansModelUtils.getParentOfClass(property, IBean.class);
        AbstractBeanDefinition mergedBd = (AbstractBeanDefinition)BeansModelUtils.getMergedBeanDefinition(bean, (IModelElement)context.getContextElement());
        IType type = ValidationRuleUtils.extractBeanClass((BeanDefinition)mergedBd, bean, mergedClassName = mergedBd.getBeanClassName(), context);
        if (type != null) {
            this.validateMethod((IResourceModelElement)property, type, property.getElementName(), true, context);
        }
    }

    private void validateBean(IBean bean, IBeansValidationContext context, IProgressMonitor monitor) {
        String mergedClassName;
        String className = ((Bean)bean).getBeanDefinition().getBeanClassName();
        if (className != null && !SpringCoreUtils.hasPlaceHolder((String)className)) {
            IType type = JdtUtils.getJavaType((IProject)BeansModelUtils.getProject(bean).getProject(), (String)className);
            try {
                if (type != null && Flags.isDeprecated((int)type.getFlags())) {
                    context.warning((IResourceModelElement)bean, "CLASS_IS_DEPRECATED", "Class '" + className + "' is marked deprecated", new ValidationProblemAttribute[]{new ValidationProblemAttribute("CLASS", (Object)className)});
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        AbstractBeanDefinition bd = (AbstractBeanDefinition)((Bean)bean).getBeanDefinition();
        AbstractBeanDefinition mergedBd = (AbstractBeanDefinition)BeansModelUtils.getMergedBeanDefinition(bean, (IModelElement)context.getContextElement());
        IType type = ValidationRuleUtils.extractBeanClass((BeanDefinition)mergedBd, bean, mergedClassName = mergedBd.getBeanClassName(), context);
        if (type != null) {
            this.validateMethod((IResourceModelElement)bean, type, bd.getInitMethodName(), false, context);
            this.validateMethod((IResourceModelElement)bean, type, bd.getDestroyMethodName(), false, context);
        }
    }

    private void validateMethod(IResourceModelElement bean, IType type, String methodName, boolean setter, IBeansValidationContext context) {
        if (methodName != null && !SpringCoreUtils.hasPlaceHolder((String)methodName)) {
            try {
                IMethod method = null;
                method = setter ? Introspector.getWritableProperty((IType)type, (String)methodName) : Introspector.findMethod((IType)type, (String)methodName, (int)0, (Introspector.Public)Introspector.Public.DONT_CARE, (Introspector.Static)Introspector.Static.DONT_CARE);
                if (method != null && Flags.isDeprecated((int)method.getFlags())) {
                    context.warning(bean, "METHOD_IS_DEPRECATED", "Method '" + method.getElementName() + "' is marked deprecated", new ValidationProblemAttribute[]{new ValidationProblemAttribute("CLASS", (Object)type.getFullyQualifiedName()), new ValidationProblemAttribute("METHOD_OBJ", (Object)method)});
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }
}

