/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model.validation.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.ide.eclipse.beans.core.internal.model.Bean;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.validation.AbstractBeanValidationRule;
import org.springframework.ide.eclipse.beans.core.model.validation.IBeansValidationContext;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.model.IModelSourceLocation;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.java.JavaModelSourceLocation;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.util.StringUtils;
import org.springsource.ide.eclipse.commons.core.SpringCoreUtils;

public class BeanClassRule
extends AbstractBeanValidationRule {
    private List<String> ignorableClasses = new ArrayList<String>();

    public void setIgnorableClasses(String classNames) {
        if (StringUtils.hasText((String)classNames)) {
            this.ignorableClasses = Arrays.asList(StringUtils.delimitedListToStringArray((String)classNames, (String)",", (String)"\r\n\f "));
        }
    }

    public void validate(IBean bean, IBeansValidationContext context, IProgressMonitor monitor) {
        String className = ((Bean)bean).getBeanDefinition().getBeanClassName();
        if (className != null && !SpringCoreUtils.hasPlaceHolder((String)className) && !this.ignorableClasses.contains(className)) {
            IType type = JdtUtils.getJavaType((IProject)BeansModelUtils.getProject(bean).getProject(), (String)className);
            try {
                IModelSourceLocation sourceLocation = bean.getElementSourceLocation();
                if (type != null) {
                    if (!bean.isAbstract() && !(sourceLocation instanceof JavaModelSourceLocation)) {
                        if (type.isInterface()) {
                            context.warning((IResourceModelElement)bean, "CLASS_NOT_CLASS", "Class '" + className + "' is an interface", new ValidationProblemAttribute[]{new ValidationProblemAttribute("CLASS", (Object)className), new ValidationProblemAttribute("BEAN_NAME", (Object)bean.getElementName())});
                        } else if (type.isClass() && Flags.isAbstract((int)type.getFlags())) {
                            context.warning((IResourceModelElement)bean, "CLASS_NOT_CONCRETE", "Class '" + className + "' is abstract ", new ValidationProblemAttribute[]{new ValidationProblemAttribute("CLASS", (Object)className), new ValidationProblemAttribute("BEAN_NAME", (Object)bean.getElementName())});
                        }
                    }
                } else {
                    context.error((IResourceModelElement)bean, "CLASS_NOT_FOUND", "Class '" + className + "' not found", new ValidationProblemAttribute[]{new ValidationProblemAttribute("CLASS", (Object)className), new ValidationProblemAttribute("BEAN_NAME", (Object)bean.getElementName())});
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }
}

