/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model.validation;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.BeansCoreUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModel;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansImport;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.core.model.IImportedBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IReloadableBeansConfig;
import org.springframework.ide.eclipse.core.internal.model.validation.ValidatorDefinition;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.java.TypeStructureState;
import org.springframework.ide.eclipse.core.model.ModelChangeEvent;
import org.springframework.ide.eclipse.core.project.IProjectContributorState;
import org.springframework.ide.eclipse.core.project.ProjectBuilderDefinition;
import org.springframework.ide.eclipse.core.project.ProjectContributionEventListenerAdapter;
import org.springsource.ide.eclipse.commons.core.SpringCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeansConfigReloadingProjectContributionEventListener
extends ProjectContributionEventListenerAdapter {
    private TypeStructureState structureState = null;
    private final Set<IBeansConfig> configs = new HashSet<IBeansConfig>();

    public void start(int kind, IResourceDelta delta, List<ProjectBuilderDefinition> builderDefinitions, List<ValidatorDefinition> validatorDefinitions, IProjectContributorState state, IProject project, IProgressMonitor monitor) {
        this.structureState = (TypeStructureState)state.get(TypeStructureState.class);
        if (this.structureState == null) {
            this.structureState = new TypeStructureState();
        }
        try {
            if (kind != 6) {
                Object visitor;
                if (delta == null) {
                    visitor = new ResourceTreeVisitor();
                    project.accept((IResourceVisitor)visitor);
                } else {
                    visitor = new ResourceDeltaVisitor();
                    delta.accept((IResourceDeltaVisitor)visitor);
                }
            } else {
                IBeansProject beansProject = BeansCorePlugin.getModel().getProject(project);
                if (beansProject != null) {
                    this.configs.addAll(beansProject.getConfigs());
                }
            }
        }
        catch (CoreException e) {
            BeansCorePlugin.log(e);
        }
        if (this.configs.size() > 0) {
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
            subMonitor.beginTask("Initializing Spring Model", this.configs.size());
            for (IBeansConfig config : this.configs) {
                subMonitor.subTask("Loading '" + config.getElementResource().getFullPath().toString().substring(1) + "'");
                if (!(config instanceof IReloadableBeansConfig)) continue;
                ((IReloadableBeansConfig)config).reload();
                config.getBeans();
                subMonitor.worked(1);
            }
            subMonitor.done();
        }
    }

    public void finish(int kind, IResourceDelta delta, List<ProjectBuilderDefinition> builderDefinitions, List<ValidatorDefinition> validatorDefinitions, IProjectContributorState state, IProject project) {
        IBeansProject beansProject;
        if (this.configs.size() > 0 && (beansProject = BeansCorePlugin.getModel().getProject(project)) != null) {
            ((BeansModel)BeansCorePlugin.getModel()).notifyListeners(beansProject, ModelChangeEvent.Type.CHANGED);
        }
        this.configs.clear();
    }

    private void checkResource(IResource resource) {
        if (resource.getName().endsWith(".java") && this.structureState.hasStructuralChanges(resource, 24)) {
            for (IBeansProject beansProject : BeansCorePlugin.getModel().getProjects()) {
                if (!JdtUtils.isJavaProject((IResource)beansProject.getProject()) || !JdtUtils.getJavaProject((IProject)beansProject.getProject()).isOnClasspath(resource)) continue;
                for (IBeansConfig config : beansProject.getConfigs()) {
                    if (!config.doesAnnotationScanning()) continue;
                    this.propagateToConfigsFromConfigSet(config, false);
                }
            }
        } else if (BeansCoreUtils.isBeansConfig(resource, true)) {
            IBeansConfig bc = BeansCorePlugin.getModel().getConfig((IFile)resource, true);
            if (bc.resourceChanged()) {
                if (bc instanceof IImportedBeansConfig) {
                    this.propagateToConfigsFromConfigSet(BeansModelUtils.getParentOfClass(bc, IBeansConfig.class), false);
                } else {
                    this.propagateToConfigsFromConfigSet(bc, false);
                }
            } else {
                this.propagateToConfigsFromConfigSet(bc, true);
            }
        }
    }

    private void propagateToConfigsFromConfigSet(IBeansConfig config, boolean onlyImportsCheck) {
        if (!onlyImportsCheck) {
            this.configs.add(config);
        }
        for (IBeansProject beansProject : BeansCorePlugin.getModel().getProjects()) {
            if (!onlyImportsCheck) {
                for (IBeansConfigSet configSet : beansProject.getConfigSets()) {
                    if (!configSet.hasConfig((IFile)config.getElementResource())) continue;
                    this.configs.addAll(configSet.getConfigs());
                }
            }
            for (IBeansConfig bc : beansProject.getConfigs()) {
                for (IBeansImport beansImport : bc.getImports()) {
                    for (IImportedBeansConfig importedBeansConfig : beansImport.getImportedBeansConfigs()) {
                        if (!config.getElementResource().equals((Object)importedBeansConfig.getElementResource())) continue;
                        this.configs.add(bc);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private Set<IResource> resources = new LinkedHashSet<IResource>();

        public Set<IResource> getResources() {
            return this.resources;
        }

        public boolean visit(IResourceDelta aDelta) throws CoreException {
            boolean visitChildren = false;
            IResource resource = aDelta.getResource();
            if (resource instanceof IProject) {
                visitChildren = SpringCoreUtils.isSpringProject((IResource)resource);
            } else if (resource instanceof IFolder) {
                visitChildren = true;
            } else if (resource instanceof IFile) {
                switch (aDelta.getKind()) {
                    case 1: 
                    case 4: {
                        BeansConfigReloadingProjectContributionEventListener.this.checkResource(resource);
                        visitChildren = true;
                        break;
                    }
                    case 2: {
                        BeansConfigReloadingProjectContributionEventListener.this.checkResource(resource);
                    }
                }
            }
            return visitChildren;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ResourceTreeVisitor
    implements IResourceVisitor {
        private Set<IResource> resources = new LinkedHashSet<IResource>();

        public Set<IResource> getResources() {
            return this.resources;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource instanceof IFile) {
                BeansConfigReloadingProjectContributionEventListener.this.checkResource(resource);
            }
            return true;
        }
    }
}

