/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model.namespaces;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IProject;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.namespaces.NamespaceDefinition;
import org.springframework.ide.eclipse.beans.core.internal.model.namespaces.TargetNamespaceScanner;
import org.springframework.ide.eclipse.beans.core.namespaces.NamespaceUtils;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectClasspathUriResolver {
    private final IProject project;
    private boolean disableCaching;
    private Map<String, String> typePublic;
    private Map<String, String> typeUri;
    private Map<String, String> schemaMappings;

    public ProjectClasspathUriResolver(IProject project) {
        this.project = project;
        this.disableCaching = NamespaceUtils.disableCachingForNamespaceLoadingFromClasspath(project);
        if (!this.disableCaching) {
            this.init();
        }
    }

    public String resolveOnClasspath(String publicId, String systemId) {
        if (this.disableCaching) {
            return this.resolveOnClasspathAndSourceFolders(publicId, systemId);
        }
        return this.resolveOnClasspathOnly(publicId, systemId);
    }

    private String resolveOnClasspathAndSourceFolders(String publicId, String systemId) {
        ClassLoader classLoader = JdtUtils.getClassLoader((IProject)this.project, null);
        Map<String, String> mappings = this.getSchemaMappings(classLoader);
        if (mappings != null && systemId != null && mappings.containsKey(systemId)) {
            String xsdPath = mappings.get(systemId);
            return this.resolveXsdPathOnClasspath(xsdPath, classLoader);
        }
        return null;
    }

    private String resolveOnClasspathOnly(String publicId, String systemId) {
        String resolved = null;
        if (systemId != null) {
            resolved = this.typeUri.get(systemId);
        }
        if (!(resolved != null || publicId == null || systemId != null && systemId.endsWith(".xsd"))) {
            resolved = this.typePublic.get(publicId);
        }
        return resolved;
    }

    private void init() {
        this.typePublic = new ConcurrentHashMap<String, String>();
        this.typeUri = new ConcurrentHashMap<String, String>();
        HashMap<String, NamespaceDefinition> namespaceDefinitionRegistry = new HashMap<String, NamespaceDefinition>();
        ClassLoader classLoader = JdtUtils.getClassLoader((IProject)this.project, null);
        this.schemaMappings = this.getSchemaMappings(classLoader);
        if (this.schemaMappings != null) {
            for (String key : this.schemaMappings.keySet()) {
                String path = this.schemaMappings.get(key);
                String resolvedPath = this.resolveXsdPathOnClasspath(path, classLoader);
                if (resolvedPath == null) continue;
                this.typeUri.put(key, resolvedPath);
                String namespaceUri = this.getTargetNamespace(resolvedPath);
                if (namespaceDefinitionRegistry.containsKey(namespaceUri)) {
                    ((NamespaceDefinition)namespaceDefinitionRegistry.get(namespaceUri)).addSchemaLocation(key);
                    ((NamespaceDefinition)namespaceDefinitionRegistry.get(namespaceUri)).addUri(path);
                    continue;
                }
                NamespaceDefinition namespaceDefinition = new NamespaceDefinition(null);
                namespaceDefinition.addSchemaLocation(key);
                namespaceDefinition.setNamespaceUri(namespaceUri);
                namespaceDefinition.addUri(path);
                namespaceDefinitionRegistry.put(namespaceUri, namespaceDefinition);
            }
            for (NamespaceDefinition definition : namespaceDefinitionRegistry.values()) {
                String namespaceKey = definition.getNamespaceUri();
                String defaultUri = definition.getDefaultUri();
                String resolvedPath = this.resolveXsdPathOnClasspath(defaultUri, classLoader);
                if (resolvedPath == null) continue;
                this.typePublic.put(namespaceKey, resolvedPath);
            }
        }
    }

    private String getTargetNamespace(String resolvedPath) {
        if (resolvedPath == null) {
            return null;
        }
        try {
            URL url = new URI(resolvedPath).toURL();
            return TargetNamespaceScanner.getTargetNamespace(url);
        }
        catch (IOException e) {
            BeansCorePlugin.log(e);
        }
        catch (URISyntaxException e) {
            BeansCorePlugin.log(e);
        }
        return null;
    }

    private Map<String, String> getSchemaMappings(ClassLoader classLoader) {
        ConcurrentHashMap<String, String> handlerMappings = new ConcurrentHashMap<String, String>();
        try {
            Properties mappings = PropertiesLoaderUtils.loadAllProperties((String)"META-INF/spring.schemas", (ClassLoader)classLoader);
            CollectionUtils.mergePropertiesIntoMap((Properties)mappings, handlerMappings);
        }
        catch (IOException iOException) {}
        return handlerMappings;
    }

    private String resolveXsdPathOnClasspath(String xsdPath, ClassLoader cls) {
        URL url = cls.getResource(xsdPath);
        if (url == null && xsdPath.startsWith("/")) {
            xsdPath = xsdPath.substring(1);
            url = cls.getResource(xsdPath);
        }
        return url != null ? url.toString() : null;
    }
}

