/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model.namespaces;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DocumentAccessor {
    private Stack<Document> documents = new Stack();
    private Stack<Node> elements = new Stack();
    private Node lastElement = null;
    private Document lastDocument = null;
    private Map<Document, SchemaLocations> schemaLocations = new HashMap<Document, SchemaLocations>();

    public void pushDocument(Document doc) {
        this.lastDocument = doc;
        this.documents.push(doc);
    }

    public void pushElement(Node element) {
        this.lastElement = element;
        this.elements.push(element);
    }

    public Document getCurrentDocument() {
        if (!this.documents.isEmpty()) {
            return this.documents.peek();
        }
        return null;
    }

    public Document getLastDocument() {
        return this.lastDocument;
    }

    public Node getCurrentElement() {
        if (!this.elements.isEmpty()) {
            return this.elements.peek();
        }
        return null;
    }

    public Node getLastElement() {
        return this.lastElement;
    }

    public synchronized SchemaLocations getCurrentSchemaLocations() {
        Document doc = this.getCurrentDocument();
        if (!this.schemaLocations.containsKey(doc) && doc != null && doc.getDocumentElement() != null) {
            SchemaLocations schemaLocations = new SchemaLocations();
            schemaLocations.initSchemaLocations(doc.getDocumentElement().getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation"));
            this.schemaLocations.put(doc, schemaLocations);
        }
        return this.schemaLocations.get(doc);
    }

    public Document popDocument() {
        if (!this.documents.isEmpty()) {
            return this.documents.pop();
        }
        return null;
    }

    public Node popElement() {
        if (!this.elements.isEmpty()) {
            return this.elements.pop();
        }
        return null;
    }

    static class SchemaLocations {
        private Map<String, String> mapping = new HashMap<String, String>();

        SchemaLocations() {
        }

        public void initSchemaLocations(String schemaLocations) {
            String[] tokens;
            if (StringUtils.hasLength((String)schemaLocations) && (tokens = StringUtils.tokenizeToStringArray((String)schemaLocations, (String)" \r\n")).length % 2 == 0) {
                int i = 0;
                while (i < tokens.length) {
                    this.mapping.put(tokens[i], tokens[i + 1]);
                    i += 2;
                }
            }
        }

        public String getSchemaLocation(String namespaceUri) {
            return this.mapping.get(namespaceUri);
        }
    }
}

