/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.springframework.beans.factory.parsing.SourceExtractor;
import org.springframework.core.io.Resource;
import org.springframework.ide.eclipse.core.java.classreading.JdtSourceExtractor;
import org.springframework.ide.eclipse.core.model.java.JavaSourceExtractor;
import org.springframework.ide.eclipse.core.model.xml.XmlSourceExtractor;

public class DelegatingSourceExtractor
implements SourceExtractor {
    private Set<SourceExtractor> sourceExtractors = new HashSet<SourceExtractor>();

    public DelegatingSourceExtractor(IProject project) {
        this.sourceExtractors.add((SourceExtractor)new XmlSourceExtractor());
        this.sourceExtractors.add((SourceExtractor)new JavaSourceExtractor(project));
        this.sourceExtractors.add((SourceExtractor)new JdtSourceExtractor());
    }

    public Object extractSource(Object sourceCandidate, Resource definingResource) {
        if (sourceCandidate != null) {
            for (SourceExtractor sourceExtractor : this.sourceExtractors) {
                Object object = sourceExtractor.extractSource(sourceCandidate, definingResource);
                if (sourceCandidate.equals(object)) continue;
                return object;
            }
        }
        return sourceCandidate;
    }
}

