/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.util.ObjectUtils;

public class BeansConnection {
    private BeanType type;
    private IModelElement source;
    private IBean target;
    private IModelElement context;
    private boolean isInner = false;

    public BeansConnection(BeanType type, IModelElement source, IBean target) {
        this(BeanType.STANDARD, source, target, target.getElementParent());
    }

    public BeansConnection(BeanType type, IModelElement source, IBean target, boolean isInner) {
        this(BeanType.STANDARD, source, target, target.getElementParent(), isInner);
    }

    public BeansConnection(BeanType type, IModelElement source, IBean target, IModelElement context) {
        this(type, source, target, target.getElementParent(), false);
    }

    public BeansConnection(BeanType type, IModelElement source, IBean target, IModelElement context, boolean isInner) {
        this.type = type;
        this.source = source;
        this.target = target;
        this.context = context;
        this.isInner = isInner;
    }

    public final BeanType getType() {
        return this.type;
    }

    public final IModelElement getSource() {
        return this.source;
    }

    public final IBean getTarget() {
        return this.target;
    }

    public IModelElement getContext() {
        return this.context;
    }

    public boolean isInner() {
        return this.isInner;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BeansConnection)) {
            return false;
        }
        BeansConnection that = (BeansConnection)other;
        if (!ObjectUtils.nullSafeEquals((Object)((Object)this.type), (Object)((Object)that.type))) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.source, (Object)that.source)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.target, (Object)that.target)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.isInner, (Object)that.isInner)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.context, (Object)that.context);
    }

    public int hashCode() {
        int hashCode = ObjectUtils.nullSafeHashCode((Object)((Object)this.type));
        hashCode = 29 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.source);
        hashCode = 29 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.target);
        hashCode = 29 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.isInner);
        return 29 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.context);
    }

    public String toString() {
        StringBuffer text = new StringBuffer(this.type.toString());
        text.append(": ").append(this.source).append(" -> ").append(this.target);
        text.append(" @ ").append(this.context);
        return text.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BeanType {
        STANDARD,
        PARENT,
        FACTORY,
        DEPENDS_ON,
        METHOD_OVERRIDE,
        INTERCEPTOR,
        INNER;

    }
}

