/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.ide.eclipse.beans.core.internal.model.AbstractBeansModelElement;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansComponent;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeansComponent
extends AbstractBeansModelElement
implements IBeansComponent {
    private Set<IBean> beans = new LinkedHashSet<IBean>();
    private Set<IBeansComponent> components = new LinkedHashSet<IBeansComponent>();

    public BeansComponent(IModelElement parent, ComponentDefinition definition) {
        super(parent, definition.getName(), (BeanMetadataElement)definition);
    }

    public int getElementType() {
        return 7;
    }

    public IModelElement[] getElementChildren() {
        LinkedHashSet<IBean> children = new LinkedHashSet<IBean>(this.beans);
        children.addAll(this.components);
        return children.toArray(new IModelElement[children.size()]);
    }

    public void addBean(IBean bean) {
        this.beans.add(bean);
    }

    @Override
    public Set<IBean> getBeans() {
        return Collections.unmodifiableSet(this.beans);
    }

    public void addComponent(IBeansComponent component) {
        this.components.add(component);
    }

    @Override
    public Set<IBeansComponent> getComponents() {
        return Collections.unmodifiableSet(this.components);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BeansComponent)) {
            return false;
        }
        return super.equals(other);
    }

    public int hashCode() {
        return this.getElementType() * super.hashCode();
    }

    public String toString() {
        StringBuffer text = new StringBuffer(super.toString());
        text.append(": beans=");
        text.append(this.beans);
        text.append(", components=");
        text.append(this.components);
        return text.toString();
    }

    public void accept(IModelElementVisitor visitor, IProgressMonitor monitor) {
        if (!monitor.isCanceled() && visitor.visit((IModelElement)this, monitor)) {
            for (IBeansComponent carg : this.getComponents()) {
                carg.accept(visitor, monitor);
                if (!monitor.isCanceled()) continue;
                return;
            }
            for (IBean bean : this.getBeans()) {
                bean.accept(visitor, monitor);
                if (!monitor.isCanceled()) continue;
                return;
            }
        }
    }
}

