/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.ide.eclipse.beans.core.internal.model.AbstractBeansValueHolder;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanConstructorArgument;
import org.springframework.util.ObjectUtils;

public class BeanConstructorArgument
extends AbstractBeansValueHolder
implements IBeanConstructorArgument {
    private int index;
    private String name;
    private String type;

    protected static final String createName(int index, ConstructorArgumentValues.ValueHolder vHolder) {
        StringBuffer buf = new StringBuffer();
        if (index >= 0) {
            buf.append(index);
        }
        if (vHolder.getType() != null) {
            if (buf.length() > 0) {
                buf.append(" - ");
            }
            buf.append(vHolder.getType());
        }
        if (buf.length() == 0) {
            buf.append(BeansModelUtils.getValueName(vHolder.getValue()));
        }
        return buf.toString();
    }

    public BeanConstructorArgument(IBean bean, int index, ConstructorArgumentValues.ValueHolder vHolder) {
        super(bean, BeanConstructorArgument.createName(index, vHolder), vHolder.getValue(), (BeanMetadataElement)vHolder);
        this.index = index;
        this.type = vHolder.getType();
        this.name = vHolder.getName();
    }

    public BeanConstructorArgument(IBean bean, ConstructorArgumentValues.ValueHolder vHolder) {
        this(bean, -1, vHolder);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BeanConstructorArgument)) {
            return false;
        }
        BeanConstructorArgument that = (BeanConstructorArgument)other;
        if (!ObjectUtils.nullSafeEquals((Object)this.index, (Object)that.index)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.type, (Object)that.type)) {
            return false;
        }
        return super.equals(other);
    }

    public int getElementType() {
        return 10;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public int hashCode() {
        int hashCode = ObjectUtils.nullSafeHashCode((Object)this.index);
        hashCode = this.getElementType() * hashCode + ObjectUtils.nullSafeHashCode((Object)this.type);
        return this.getElementType() * hashCode + super.hashCode();
    }

    public String toString() {
        StringBuffer text = new StringBuffer(super.toString());
        text.append(", index=");
        text.append(this.index);
        text.append(", type=");
        text.append(this.type);
        return text.toString();
    }
}

