/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.xml.DocumentDefaultsDefinition;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanAlias;
import org.springframework.ide.eclipse.beans.core.model.IBeansComponent;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigEventListener;
import org.springframework.ide.eclipse.beans.core.model.IBeansImport;
import org.springframework.ide.eclipse.beans.core.model.IBeansModelElement;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.core.model.IImportedBeansConfig;
import org.springframework.ide.eclipse.core.io.ExternalFile;
import org.springframework.ide.eclipse.core.model.AbstractResourceModelElement;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.ide.eclipse.core.model.IModelSourceLocation;
import org.springframework.ide.eclipse.core.model.ModelUtils;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblem;
import org.springframework.ide.eclipse.core.model.xml.XmlSourceLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBeansConfig
extends AbstractResourceModelElement
implements IBeansConfig {
    private static final String ANNOTATION_CONFIG_ELEMENT_NAME = "annotation-config";
    private static final String COMPONENT_SCAN_ELEMENT_NAME = "component-scan";
    private static final String CONTEXT_NAMESPACE_URI = "http://www.springframework.org/schema/context";
    protected volatile Map<String, IBeanAlias> aliases = new LinkedHashMap<String, IBeanAlias>();
    protected volatile Map<String, Set<IBean>> beanClassesMap = new HashMap<String, Set<IBean>>();
    protected volatile Map<String, IBean> beans = new LinkedHashMap<String, IBean>();
    protected volatile Set<IBeansComponent> components = new LinkedHashSet<IBeansComponent>();
    protected volatile DocumentDefaultsDefinition defaults;
    protected volatile IFile file;
    protected volatile Set<IBeansImport> imports = new CopyOnWriteArraySet<IBeansImport>();
    protected volatile boolean isArchived;
    protected volatile boolean isBeanClassesMapPopulated = false;
    protected volatile boolean isModelPopulated = false;
    protected volatile long modificationTimestamp;
    protected Set<ValidationProblem> problems = new CopyOnWriteArraySet<ValidationProblem>();
    protected final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    protected final Lock r = this.rwl.readLock();
    protected volatile IBeansConfig.Type type;
    protected final Lock w = this.rwl.writeLock();
    protected volatile Set<IBeansConfigEventListener> eventListeners = new LinkedHashSet<IBeansConfigEventListener>();

    public AbstractBeansConfig(IBeansModelElement project, String name, IBeansConfig.Type type) {
        super((IModelElement)project, name);
        this.type = type;
    }

    public void accept(IModelElementVisitor visitor, IProgressMonitor monitor) {
        if (!monitor.isCanceled() && visitor.visit((IModelElement)this, monitor)) {
            for (IBeansImport imp : this.getImports()) {
                imp.accept(visitor, monitor);
                if (!monitor.isCanceled()) continue;
                return;
            }
            for (IBeanAlias alias : this.getAliases()) {
                alias.accept(visitor, monitor);
                if (!monitor.isCanceled()) continue;
                return;
            }
            for (IBeansComponent component : this.getComponents()) {
                component.accept(visitor, monitor);
                if (!monitor.isCanceled()) continue;
                return;
            }
            for (IBean bean : this.getBeans()) {
                bean.accept(visitor, monitor);
                if (!monitor.isCanceled()) continue;
                return;
            }
        }
    }

    @Override
    public IBeanAlias getAlias(String name) {
        if (name != null) {
            try {
                this.r.lock();
                IBeanAlias alias = this.aliases.get(name);
                if (alias != null) {
                    IBeanAlias iBeanAlias = alias;
                    return iBeanAlias;
                }
                for (IBeansImport beansImport : this.imports) {
                    for (IBeansConfig iBeansConfig : beansImport.getImportedBeansConfigs()) {
                        alias = iBeansConfig.getAlias(name);
                        if (alias == null) continue;
                        IBeanAlias iBeanAlias = alias;
                        return iBeanAlias;
                    }
                }
            }
            finally {
                this.r.unlock();
            }
        }
        return null;
    }

    @Override
    public Set<IBeanAlias> getAliases() {
        this.readConfig();
        try {
            this.r.lock();
            LinkedHashSet<IBeanAlias> allAliases = new LinkedHashSet<IBeanAlias>(this.aliases.values());
            for (IBeansImport beansImport : this.imports) {
                for (IBeansConfig iBeansConfig : beansImport.getImportedBeansConfigs()) {
                    allAliases.addAll(iBeansConfig.getAliases());
                }
            }
            Set<IBeanAlias> set = Collections.unmodifiableSet(new LinkedHashSet<IBeanAlias>(allAliases));
            return set;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public IBean getBean(String name) {
        if (name != null) {
            this.readConfig();
            try {
                this.r.lock();
                IBean bean = this.beans.get(name);
                if (bean != null) {
                    IBean iBean = bean;
                    return iBean;
                }
                for (IBeansImport beansImport : this.imports) {
                    for (IBeansConfig iBeansConfig : beansImport.getImportedBeansConfigs()) {
                        bean = iBeansConfig.getBean(name);
                        if (bean == null) continue;
                        IBean iBean = bean;
                        return iBean;
                    }
                }
            }
            finally {
                this.r.unlock();
            }
        }
        return null;
    }

    @Override
    public Set<String> getBeanClasses() {
        return Collections.unmodifiableSet(new LinkedHashSet<String>(this.getBeanClassesMap().keySet()));
    }

    @Override
    public Set<IBean> getBeans() {
        this.readConfig();
        try {
            this.r.lock();
            LinkedHashSet<IBean> allBeans = new LinkedHashSet<IBean>(this.beans.values());
            for (IBeansImport beansImport : this.imports) {
                for (IBeansConfig iBeansConfig : beansImport.getImportedBeansConfigs()) {
                    allBeans.addAll(iBeansConfig.getBeans());
                }
            }
            Set<IBean> set = Collections.unmodifiableSet(allBeans);
            return set;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public Set<IBean> getBeans(String className) {
        if (this.isBeanClass(className)) {
            return Collections.unmodifiableSet(this.getBeanClassesMap().get(className));
        }
        return Collections.emptySet();
    }

    @Override
    public Set<IBeansComponent> getComponents() {
        this.readConfig();
        try {
            this.r.lock();
            LinkedHashSet<IBeansComponent> allComponents = new LinkedHashSet<IBeansComponent>(this.components);
            for (IBeansImport beansImport : this.imports) {
                for (IBeansConfig iBeansConfig : beansImport.getImportedBeansConfigs()) {
                    allComponents.addAll(iBeansConfig.getComponents());
                }
            }
            Set<IBeansComponent> set = Collections.unmodifiableSet(allComponents);
            return set;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public String getDefaultAutowire() {
        this.readConfig();
        try {
            this.r.lock();
            String string = this.defaults != null ? this.defaults.getAutowire() : "no";
            return string;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public String getDefaultDependencyCheck() {
        this.readConfig();
        try {
            this.r.lock();
            String string = this.defaults != null ? this.defaults.getDependencyCheck() : "none";
            return string;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public String getDefaultDestroyMethod() {
        this.readConfig();
        try {
            this.r.lock();
            String string = this.defaults != null && this.defaults.getDestroyMethod() != null ? this.defaults.getDestroyMethod() : "";
            return string;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public String getDefaultInitMethod() {
        this.readConfig();
        try {
            this.r.lock();
            String string = this.defaults != null && this.defaults.getInitMethod() != null ? this.defaults.getInitMethod() : "";
            return string;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public String getDefaultLazyInit() {
        this.readConfig();
        try {
            this.r.lock();
            String string = this.defaults != null ? this.defaults.getLazyInit() : "false";
            return string;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public String getDefaultMerge() {
        this.readConfig();
        try {
            this.r.lock();
            String string = this.defaults != null && this.defaults.getMerge() != null && this.defaults.getMerge().length() > 0 ? this.defaults.getMerge() : "false";
            return string;
        }
        finally {
            this.r.unlock();
        }
    }

    public IResource getElementResource() {
        return this.file;
    }

    public int getElementStartLine() {
        this.readConfig();
        IModelSourceLocation location = ModelUtils.getSourceLocation((BeanMetadataElement)this.defaults);
        return location != null ? location.getStartLine() : -1;
    }

    public final int getElementType() {
        return 3;
    }

    @Override
    public Set<IBeansImport> getImports() {
        IBeansProject project = BeansModelUtils.getParentOfClass(this, IBeansProject.class);
        if (project != null && project.isImportsEnabled()) {
            this.readConfig();
            try {
                this.r.lock();
                Set<IBeansImport> set = Collections.unmodifiableSet(this.imports);
                return set;
            }
            finally {
                this.r.unlock();
            }
        }
        return Collections.emptySet();
    }

    public final Set<ValidationProblem> getProblems() {
        this.readConfig();
        try {
            this.r.lock();
            Set<ValidationProblem> set = Collections.unmodifiableSet(this.problems);
            return set;
        }
        finally {
            this.r.unlock();
        }
    }

    @Override
    public IBeansConfig.Type getType() {
        return this.type;
    }

    @Override
    public boolean hasBean(String name) {
        if (name != null) {
            this.readConfig();
            try {
                this.r.lock();
                IBean bean = this.beans.get(name);
                if (bean != null) {
                    return true;
                }
                for (IBeansImport beansImport : this.imports) {
                    for (IBeansConfig iBeansConfig : beansImport.getImportedBeansConfigs()) {
                        bean = iBeansConfig.getBean(name);
                        if (bean == null) continue;
                        return true;
                    }
                }
                return false;
            }
            finally {
                this.r.unlock();
            }
        }
        return false;
    }

    @Override
    public boolean isBeanClass(String className) {
        if (className != null) {
            return this.getBeanClassesMap().containsKey(className);
        }
        return false;
    }

    public final boolean isElementArchived() {
        return this.isArchived;
    }

    public boolean isExternal() {
        return this.file instanceof ExternalFile;
    }

    @Override
    public boolean resourceChanged() {
        return this.modificationTimestamp < this.getElementResource().getModificationStamp() || this.changedImportedBeansConfig();
    }

    public String toString() {
        return String.valueOf(this.getElementName()) + ": " + this.getBeans();
    }

    @Override
    public void registerEventListener(IBeansConfigEventListener configEventListener) {
        if (configEventListener != null) {
            try {
                this.w.lock();
                this.eventListeners.add(configEventListener);
            }
            finally {
                this.w.unlock();
            }
        }
    }

    @Override
    public void unregisterEventListener(IBeansConfigEventListener configEventListener) {
        if (configEventListener != null) {
            try {
                this.w.lock();
                this.eventListeners.remove(configEventListener);
            }
            finally {
                this.w.unlock();
            }
        }
    }

    private void addBeanClass(IBean bean, Map<String, Set<IBean>> beanClasses) {
        String className = bean.getClassName();
        if (className != null) {
            Set<IBean> beanClassBeans;
            int pos = className.indexOf(36);
            if (pos > 0) {
                className = className.substring(0, pos);
            }
            if ((beanClassBeans = beanClasses.get(className)) == null) {
                beanClassBeans = new LinkedHashSet<IBean>();
                beanClasses.put(className, beanClassBeans);
            }
            beanClassBeans.add(bean);
        }
    }

    private void addBeanClasses(IBean bean, Map<String, Set<IBean>> beanClasses) {
        this.addBeanClass(bean, beanClasses);
        for (IBean innerBean : BeansModelUtils.getInnerBeans(bean)) {
            this.addBeanClass(innerBean, beanClasses);
        }
    }

    private void addComponentBeanClasses(IBeansComponent component, Map<String, Set<IBean>> beanClasses) {
        for (IBean bean : component.getBeans()) {
            this.addBeanClasses(bean, beanClasses);
        }
        for (IBeansComponent innerComponent : component.getComponents()) {
            this.addComponentBeanClasses(innerComponent, beanClasses);
        }
    }

    private boolean changedImportedBeansConfig() {
        try {
            this.r.lock();
            for (IBeansImport beanImport : this.imports) {
                for (IImportedBeansConfig importedConfig : beanImport.getImportedBeansConfigs()) {
                    if (!importedConfig.resourceChanged()) continue;
                    return true;
                }
            }
        }
        finally {
            this.r.unlock();
        }
        return false;
    }

    protected Map<String, Set<IBean>> getBeanClassesMap() {
        if (!this.isBeanClassesMapPopulated) {
            try {
                this.w.lock();
                if (this.isBeanClassesMapPopulated) {
                    Map<String, Set<IBean>> map = this.beanClassesMap;
                    return map;
                }
                this.beanClassesMap = new LinkedHashMap<String, Set<IBean>>();
                for (IBeansComponent component : this.getComponents()) {
                    this.addComponentBeanClasses(component, this.beanClassesMap);
                }
                for (IBean bean : this.getBeans()) {
                    this.addBeanClasses(bean, this.beanClassesMap);
                }
                for (IBeansImport beansImport : this.imports) {
                    for (IBeansConfig iBeansConfig : beansImport.getImportedBeansConfigs()) {
                        for (IBeansComponent component : iBeansConfig.getComponents()) {
                            this.addComponentBeanClasses(component, this.beanClassesMap);
                        }
                        for (IBean bean : iBeansConfig.getBeans()) {
                            this.addBeanClasses(bean, this.beanClassesMap);
                        }
                    }
                }
            }
            finally {
                this.isBeanClassesMapPopulated = true;
                this.w.unlock();
            }
        }
        return this.beanClassesMap;
    }

    @Override
    public boolean doesAnnotationScanning() {
        for (IBeansComponent component : this.getComponents()) {
            boolean result = this.doesAnnotationScanning(component);
            if (!result) continue;
            return true;
        }
        return false;
    }

    private boolean doesAnnotationScanning(IBeansComponent component) {
        if (component.getElementSourceLocation() instanceof XmlSourceLocation) {
            XmlSourceLocation location = (XmlSourceLocation)component.getElementSourceLocation();
            if (COMPONENT_SCAN_ELEMENT_NAME.equals(location.getLocalName()) && CONTEXT_NAMESPACE_URI.equals(location.getNamespaceURI())) {
                return true;
            }
            if (ANNOTATION_CONFIG_ELEMENT_NAME.equals(location.getLocalName()) && CONTEXT_NAMESPACE_URI.equals(location.getNamespaceURI())) {
                return true;
            }
        }
        for (IBeansComponent childComponent : component.getComponents()) {
            boolean result = this.doesAnnotationScanning(childComponent);
            if (!result) continue;
            return true;
        }
        return false;
    }

    protected abstract void readConfig();
}

