/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template.util;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import org.eclipse.osgi.util.NLS;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameUrlPair {
    private String urlString;
    private String urlEncodedName;

    public NameUrlPair(String unencodedName, String urlString) throws URISyntaxException {
        this.setName(unencodedName);
        this.setUrlString(urlString);
    }

    public NameUrlPair(String encodedString) {
        String[] strings = encodedString.split("|");
        if (strings == null || strings.length != 2) {
            this.urlEncodedName = "";
            this.urlString = "";
        } else {
            this.urlEncodedName = strings[0];
            this.urlString = strings[1];
        }
    }

    public String asCombinedString() {
        return String.valueOf(this.urlEncodedName) + "|" + this.urlString + "\n";
    }

    public String getUrlString() {
        return this.urlString;
    }

    public void setUrlString(String url) throws URISyntaxException {
        String despacedUrl = url.replace(" ", "%20");
        URI testUri = new URI(despacedUrl);
        if (testUri.getScheme() == null) {
            throw new URISyntaxException(url, NLS.bind((String)"URL {0} has no protocol", (Object)url));
        }
        this.urlString = testUri.toASCIIString();
    }

    public String getName() {
        try {
            return URLDecoder.decode(this.urlEncodedName, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Assert.isTrue((boolean)false);
            return "";
        }
    }

    public void setName(String unencodedName) {
        try {
            this.urlEncodedName = URLEncoder.encode(unencodedName, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.urlEncodedName = "";
        }
    }

    public URL getUrl() {
        try {
            URL newUrl = new URL(this.urlString);
            return newUrl;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public void setUrl(URL url) {
        this.urlString = url.toExternalForm();
    }

    public static ArrayList<NameUrlPair> decodeMultipleNameUrlStrings(String nameUrlsString) {
        ArrayList<NameUrlPair> nameUrlPairs = new ArrayList<NameUrlPair>();
        if (nameUrlsString != null && nameUrlsString.length() != 0) {
            String[] nameUrlStrings;
            String[] stringArray = nameUrlStrings = nameUrlsString.split("[\\r\\n\\s]");
            int n = nameUrlStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String nameUrlString = stringArray[n2];
                String[] tuple = nameUrlString.split("\\|");
                if (tuple.length == 2) {
                    try {
                        String myUnencodedName = URLDecoder.decode(tuple[0], "UTF-8");
                        String myUnencodedUrl = URLDecoder.decode(tuple[1], "UTF-8");
                        nameUrlPairs.add(new NameUrlPair(myUnencodedName, myUnencodedUrl));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        Assert.isTrue((boolean)false);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        Assert.isTrue((boolean)false);
                    }
                } else if (tuple.length == 1) {
                    try {
                        nameUrlPairs.add(new NameUrlPair("", tuple[0]));
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        Assert.isTrue((boolean)false);
                    }
                } else {
                    System.err.println("INTERNAL ERROR: Now this is strange: there are either too many strings or not enough.");
                }
                ++n2;
            }
        }
        return nameUrlPairs;
    }

    public String toString() {
        return this.asCombinedString().trim();
    }
}

