/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template.util;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.springframework.ide.eclipse.wizard.WizardPlugin;
import org.springframework.ide.eclipse.wizard.template.util.NameUrlPair;
import org.springsource.ide.eclipse.commons.content.core.ContentPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNameUrlPreferenceModel {
    private final IEclipsePreferences store;
    private final IEclipsePreferences defaultStore;
    private String currentString;
    protected boolean optionalFlagValue;
    private final List<PropertyChangeListener> listeners = new CopyOnWriteArrayList<PropertyChangeListener>();

    protected abstract IEclipsePreferences getStore();

    protected abstract String getStoreKey();

    protected abstract String getDefaultFilename();

    protected abstract IEclipsePreferences getDefaultStore();

    public AbstractNameUrlPreferenceModel() {
        this.store = this.getStore();
        this.defaultStore = this.getDefaultStore();
        if (this.store == null) {
            String title = NLS.bind((String)"Serious error", null);
            String message = NLS.bind((String)"This is a serious error: we didn't think this could happen.  Please tell the STS team that there was no preferences store for the Help bundle.The issue tracker is at https://issuetracker.springsource.com/browse/STS", null);
            MessageDialog.openError(null, (String)title, (String)message);
        }
        this.setDefaults();
        this.revert();
        this.persist();
    }

    public void revert() {
        this.currentString = this.store.get(this.getStoreKey(), null);
        if (this.currentString == null) {
            this.currentString = this.defaultStore.get(this.getStoreKey(), "");
        }
    }

    protected void setDefaults() {
        try {
            InputStream defaultsStream = FileLocator.openStream((Bundle)WizardPlugin.getDefault().getBundle(), (IPath)new Path(this.getDefaultFilename()), (boolean)false);
            Properties urlProperties = new Properties();
            urlProperties.load(defaultsStream);
            String encodedString = "";
            for (Object key : urlProperties.keySet()) {
                if (!(key instanceof String) || !(urlProperties.get(key) instanceof String)) continue;
                try {
                    encodedString = String.valueOf(encodedString) + new NameUrlPair((String)key, urlProperties.getProperty((String)key)).asCombinedString();
                }
                catch (URISyntaxException uRISyntaxException) {
                    String title = NLS.bind((String)"Malformed URL", null);
                    String message = NLS.bind((String)"The {0} is not a legal URL; ignoring.", (Object)urlProperties.get(key));
                    MessageDialog.openError(null, (String)title, (String)message);
                }
            }
            this.defaultStore.put(this.getStoreKey(), encodedString);
        }
        catch (IOException iOException) {
            String title = NLS.bind((String)"Could not read defaults", null);
            String message = NLS.bind((String)"Could not read defaults from file {0}; check that the file exists and is readable", (Object)this.getDefaultFilename());
            MessageDialog.openError(null, (String)title, (String)message);
        }
    }

    public ArrayList<NameUrlPair> getElements() {
        if (this.currentString == null) {
            this.currentString = this.defaultStore.get(this.getStoreKey(), "");
        }
        return NameUrlPair.decodeMultipleNameUrlStrings(this.currentString);
    }

    public String replaceNameUrlPairInEncodedString(NameUrlPair oldNameUrl, NameUrlPair newNameUrl) {
        this.currentString = this.currentString.replaceFirst(oldNameUrl.asCombinedString(), newNameUrl.asCombinedString());
        return this.currentString;
    }

    public String removeNameUrlPairInEncodedString(NameUrlPair oldNameUrl) {
        String combinedString = oldNameUrl.asCombinedString();
        String adjustedString = Pattern.quote(combinedString);
        this.currentString = this.currentString.replaceFirst(adjustedString, "");
        return this.currentString;
    }

    public String addNameUrlPairInEncodedString(NameUrlPair newNameUrl) {
        this.currentString = String.valueOf(this.currentString) + newNameUrl.asCombinedString();
        return this.currentString;
    }

    public boolean persist() {
        boolean newValue;
        boolean oldValue;
        boolean didChangeFlag = false;
        this.normalizeCurrentStringOrder();
        if (!this.currentString.equals(this.store.get(this.getStoreKey(), null))) {
            Assert.isNotNull((Object)this.currentString, (String)("INTERNAL ERROR: current string should not be null in " + this.getClass()));
            this.store.put(this.getStoreKey(), this.currentString);
            didChangeFlag = true;
        }
        if ((oldValue = this.getStore().getBoolean(this.getStoreOptionalFlagKey(), this.optionalFlagDefault())) != (newValue = this.getOptionalFlagValue())) {
            didChangeFlag = true;
            this.getStore().putBoolean(this.getStoreOptionalFlagKey(), this.getOptionalFlagValue());
        }
        if (didChangeFlag) {
            ContentPlugin.getDefault().getManager().setDirty();
        }
        return didChangeFlag;
    }

    private void normalizeCurrentStringOrder() {
        ArrayList<NameUrlPair> sortedItems = NameUrlPair.decodeMultipleNameUrlStrings(this.currentString);
        Collections.sort(sortedItems, new Comparator<NameUrlPair>(){

            @Override
            public int compare(NameUrlPair o1, NameUrlPair o2) {
                return o1.getUrlString().compareTo(o2.getUrlString());
            }
        });
        this.currentString = "";
        for (NameUrlPair nameUrlPair : sortedItems) {
            this.currentString = String.valueOf(this.currentString) + nameUrlPair.asCombinedString();
        }
    }

    protected void clearNonDefaults() {
        this.currentString = this.defaultStore.get(this.getStoreKey(), null);
    }

    protected abstract String getStoreOptionalFlagKey();

    protected boolean optionalFlagDefault() {
        return false;
    }

    protected void setOptionalFlagValue(boolean flagValue) {
        this.optionalFlagValue = flagValue;
    }

    protected boolean getOptionalFlagValue() {
        return this.optionalFlagValue;
    }

    public void addListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }
}

