/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template.newproject;

import java.net.URL;
import java.util.Collection;
import java.util.Map;
import org.springframework.ide.eclipse.wizard.template.SpringVersion;
import org.springframework.ide.eclipse.wizard.template.infrastructure.processor.AbstractProcessingInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewProjectProcessingInfo
extends AbstractProcessingInfo {
    private final URL projectSourceLocation;
    private String[] topLevelPackageTokens;
    private final String projectName;
    private String projectNameToken;
    private final SpringVersion springVersion;

    public NewProjectProcessingInfo(URL projectSourceLocation, String projectName) {
        this(projectSourceLocation, projectName, null);
    }

    public NewProjectProcessingInfo(URL projectSourceLocation, String projectName, SpringVersion springVersion) {
        this.projectSourceLocation = projectSourceLocation;
        this.projectName = projectName;
        this.springVersion = springVersion;
    }

    @Override
    public Collection<String> getExclusionPatterns() {
        Collection<String> exclusionPatterns = super.getExclusionPatterns();
        if (Boolean.FALSE.equals(this.userInput.get("oraclePackSupport"))) {
            exclusionPatterns.add("/**/oracle*.*");
        }
        return exclusionPatterns;
    }

    @Override
    public SpringVersion getSpringVersion() {
        return this.springVersion;
    }

    @Override
    public URL getTemplateSourceDirectory() {
        return this.projectSourceLocation;
    }

    @Override
    public void setProjectNameToken(String projectNameToken) {
        this.projectNameToken = projectNameToken;
    }

    @Override
    public void setTopLevelPackageTokens(String[] topLevelPackageTokens) {
        this.topLevelPackageTokens = topLevelPackageTokens;
    }

    @Override
    public void setUserInput(Map<String, Object> userInput) {
        super.setUserInput(userInput);
        String userTopLevelPackageName = this.getUserTopLevelPackageName();
        if (userTopLevelPackageName != null) {
            String[] userTopLevelPackage = userTopLevelPackageName.split("\\.");
            if (this.topLevelPackageTokens != null) {
                StringBuilder topLevelPackageStr = new StringBuilder();
                StringBuilder userTopLevelPackageStr = new StringBuilder();
                int i = 0;
                while (i < userTopLevelPackage.length || i < this.topLevelPackageTokens.length) {
                    if (i >= userTopLevelPackage.length) {
                        userInput.put(this.topLevelPackageTokens[i], this.topLevelPackageTokens[i]);
                        topLevelPackageStr.append("&&");
                        topLevelPackageStr.append(this.topLevelPackageTokens[i]);
                    } else if (i >= this.topLevelPackageTokens.length) {
                        userInput.put(userTopLevelPackage[i], userTopLevelPackage[i]);
                        userTopLevelPackageStr.append("&&");
                        userTopLevelPackageStr.append(userTopLevelPackage[i]);
                    } else {
                        userInput.put(this.topLevelPackageTokens[i], userTopLevelPackage[i]);
                        topLevelPackageStr.append("&&");
                        topLevelPackageStr.append(this.topLevelPackageTokens[i]);
                        userTopLevelPackageStr.append("&&");
                        userTopLevelPackageStr.append(userTopLevelPackage[i]);
                    }
                    ++i;
                }
                userInput.put("||top-level-package||", topLevelPackageStr.toString());
                userInput.put("||user-top-level-package||", userTopLevelPackageStr.toString());
            }
        }
        userInput.put(this.projectNameToken, this.projectName);
    }
}

