/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template.infrastructure.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.ide.eclipse.wizard.template.infrastructure.processor.ProcessingInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProcessingInfo
implements ProcessingInfo {
    protected Map<String, Object> userInput;
    protected Map<String, String> inputKinds;

    private Map<String, String> createReplacementContext() {
        LinkedHashMap<String, String> replacementContext = new LinkedHashMap<String, String>();
        for (String token : this.userInput.keySet()) {
            Object value = this.userInput.get(token);
            if (value instanceof String) {
                replacementContext.put(token, (String)value);
            }
            if (value != null) continue;
            replacementContext.put("." + token, "");
            replacementContext.put("/" + token, "");
            replacementContext.put("\\" + token, "");
            replacementContext.put(token, "");
        }
        return replacementContext;
    }

    @Override
    public Collection<String> getExclusionPatterns() {
        ArrayList<String> exclusionPatterns = new ArrayList<String>();
        exclusionPatterns.add("/**/target/**");
        exclusionPatterns.add("/**/*.svn/**");
        exclusionPatterns.add("/**/*.git/**");
        return exclusionPatterns;
    }

    @Override
    public Collection<String> getInclusionPatterns() {
        return null;
    }

    private String getNameFromKind(String kind, String defaultKind) {
        for (String elementName : this.inputKinds.keySet()) {
            String inputKind = this.inputKinds.get(elementName);
            if (!inputKind.equals(kind)) continue;
            return (String)this.userInput.get(elementName);
        }
        return (String)this.userInput.get(defaultKind);
    }

    @Override
    public Map<String, String> getResourceReplacementContext() {
        Map<String, String> replacementContext = this.getTemplateReplacementContext();
        for (String token : replacementContext.keySet()) {
            String value = replacementContext.get(token);
            String kind = this.inputKinds.get(token);
            if (kind == null || !kind.equals("fixedtoken")) {
                value = value.replace(".", "/");
            }
            replacementContext.put(token, value);
        }
        return replacementContext;
    }

    @Override
    public Map<String, String> getTemplateReplacementContext() {
        return this.createReplacementContext();
    }

    public String getUserTopLevelPackageName() {
        return this.getNameFromKind("topLevelPackage", "topLevelPackage");
    }

    @Override
    public void setInputKinds(Map<String, String> inputKinds) {
        this.inputKinds = inputKinds;
    }

    @Override
    public void setUserInput(Map<String, Object> userInput) {
        this.userInput = userInput;
    }
}

